/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import java.util.HashSet;
import java.util.Iterator;

class NodeRequestStatus {
    private final Object syncRoot = new Object();
    private HashSet<Long> requestSet = new HashSet();
    private HashSet<Long> acknowledgedRequestSet = new HashSet();
    private long lastRequestId;
    private long lastAcknowledgeId;

    public final void RegisterRequest(long id) {
        if (!this.requestSet.contains(id)) {
            this.requestSet.add(id);
        }
        this.lastRequestId = id;
    }

    public final long getLastAcknowledged() {
        if (this.acknowledgedRequestSet.size() != 0) {
            return this.GetMinValue(this.acknowledgedRequestSet);
        }
        return -1L;
    }

    public final Object getSyncRoot() {
        return this.syncRoot;
    }

    public final void Acknowledge(long Id) {
        if (this.requestSet.contains(Id)) {
            this.requestSet.remove(Id);
            this.acknowledgedRequestSet.add(Id);
            this.lastAcknowledgeId = Id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clean() {
        long minimum = this.requestSet.size() != 0 ? this.GetMinValue(this.requestSet) : this.lastRequestId;
        HashSet<Long> hashSet = this.acknowledgedRequestSet;
        synchronized (hashSet) {
            long lastAcknowledged = this.acknowledgedRequestSet.size() != 0 ? this.GetMaxValue(this.acknowledgedRequestSet) : this.lastAcknowledgeId;
            long[] ids = this.GetArray(this.acknowledgedRequestSet);
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] >= minimum) continue;
                this.acknowledgedRequestSet.remove(ids[i]);
            }
            if (!this.acknowledgedRequestSet.contains(lastAcknowledged)) {
                this.acknowledgedRequestSet.add(lastAcknowledged);
            }
        }
    }

    private long GetMinValue(HashSet<Long> collection) {
        long minVal = Long.MAX_VALUE;
        for (long current : collection) {
            if (minVal <= current) continue;
            minVal = current;
        }
        return minVal == Long.MAX_VALUE ? -1L : minVal;
    }

    private long GetMaxValue(HashSet<Long> collection) {
        long maxVal = Long.MIN_VALUE;
        for (long current : collection) {
            if (maxVal >= current) continue;
            maxVal = current;
        }
        return maxVal;
    }

    private long[] GetArray(HashSet<Long> collection) {
        long[] longtypeArray = new long[collection.size()];
        int index = 0;
        Iterator<Long> iterator = collection.iterator();
        while (iterator.hasNext()) {
            long value;
            longtypeArray[index] = value = iterator.next().longValue();
            ++index;
        }
        return longtypeArray;
    }
}

