/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataReader.ReaderResultSet;
import Alachisoft.NCache.Common.DataReader.RecordColumn;
import Alachisoft.NCache.Common.DataReader.RecordRow;
import Alachisoft.NCache.Common.DataReader.RecordSetImpl;
import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import Alachisoft.NCache.Common.DataStructures.ColumnType;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.RecordSet;
import Alachisoft.NCache.Common.Enum.AggregateFunctionType;
import Alachisoft.NCache.Common.Enum.ExceptionType;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Partition;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Queries.AverageResult;
import Alachisoft.NCache.Common.Queries.OrderByArgument;
import Util.ResponseHelper;
import com.alachisoft.ncache.client.MessageItem;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.command.MessagePublishBulkCommand;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.command.SurrogateCommand;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.ModuleOperation;
import com.alachisoft.ncache.client.internal.communication.ResponseList;
import com.alachisoft.ncache.client.internal.util.DictionaryEntry;
import com.alachisoft.ncache.client.internal.util.Logs;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.common.protobuf.ExceptionProtocol;
import com.alachisoft.ncache.common.protobuf.MessagePublishCommandProtocol;
import com.alachisoft.ncache.common.protobuf.OrderByArgumentProtocol;
import com.alachisoft.ncache.common.protobuf.ReaderResultSetProtocol;
import com.alachisoft.ncache.common.protobuf.RecordColumnProtocol;
import com.alachisoft.ncache.common.protobuf.RecordRowProtocol;
import com.alachisoft.ncache.common.protobuf.RecordSetProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ValueProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.InvalidReaderException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Request {
    private long _requestId = -1L;
    private boolean _isBulk = false;
    private CommandResponse _finalResponse = null;
    private Object _responseMutex = new Object();
    private int _commandID = 0;
    private ResponseProtocol.Response.Type _type;
    private HashMap<Address, HashMap<Integer, ResponseList>> _responses;
    private HashMap<Address, Command> _commands;
    private HashMap<Address, EnumerationDataChunk> _chunks;
    private ArrayList<Command> _failedCommands;
    private ArrayList<CommandResponse> _rawResponses = null;
    private HashMap<Address, SurrogateCommand> _surrogateCommands = new HashMap();
    private boolean isRequestTimeoutReset;
    private long requestTimeout;
    private String name;
    private boolean isAyncCallbackSpecified = false;
    private boolean isAsync = false;
    private Address reRoutedAddress;
    private String cacheId;
    private AtomicInteger commandIDCounter = new AtomicInteger(0);
    private Logs privateLogger = new Logs();

    public Request(boolean isBulk, long timeout) {
        this._isBulk = isBulk;
        this.setRequestTimeout(timeout);
    }

    public final boolean getIsDedicatedRequest() {
        for (Command command : this._commands.values()) {
            if (command.getClientLastViewId() != -5L) continue;
            return true;
        }
        return false;
    }

    public final int getNextCommandID() {
        return this.commandIDCounter.incrementAndGet();
    }

    public final boolean getIsRequestTimeoutReset() {
        return this.isRequestTimeoutReset;
    }

    public final void setIsRequestTimeoutReset(boolean value) {
        this.isRequestTimeoutReset = value;
    }

    public final long getRequestTimeout() {
        return this.requestTimeout;
    }

    public final void setRequestTimeout(long value) {
        this.requestTimeout = value;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    public final ArrayList<Command> getFailedCommands() {
        if (this._failedCommands == null) {
            this._failedCommands = new ArrayList();
        }
        return this._failedCommands;
    }

    public final boolean getIsAyncCallbackSpecified() {
        return this.isAyncCallbackSpecified;
    }

    public final void setIsAyncCallbackSpecified(boolean value) {
        this.isAyncCallbackSpecified = value;
    }

    public final boolean getIsAsync() {
        return this.isAsync;
    }

    public final void setIsAsync(boolean value) {
        this.isAsync = value;
    }

    public final Address getReRoutedAddress() {
        return this.reRoutedAddress;
    }

    public final void setReRoutedAddress(Address value) {
        this.reRoutedAddress = value;
    }

    public final boolean getIsBulk() {
        return this._commands.size() > 1 || this._isBulk;
    }

    public final RequestType getCommandRequestType() {
        Iterator<Command> iterator = this._commands.values().iterator();
        if (iterator.hasNext()) {
            Command command = iterator.next();
            return command.getCommandRequestType();
        }
        return RequestType.InternalCommand;
    }

    public final long getRequestId() {
        return this._requestId;
    }

    public final void setRequestId(long value) {
        this._requestId = value;
        for (Command command : this._commands.values()) {
            command.setRequestId(value);
        }
    }

    public final HashMap<Address, Command> getCommands() {
        if (this._commands == null) {
            this._commands = new HashMap();
        }
        return this._commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int NumberOfCompleteResponses(boolean includeFailedResponsesOnly) throws CommandException {
        int count = 0;
        Object object = this._responseMutex;
        synchronized (object) {
            this.DeserializeRawResponsesIfPresent();
            for (HashMap<Integer, ResponseList> allResponses : this._responses.values()) {
                for (ResponseList responseList : allResponses.values()) {
                    if (!responseList.IsComplete(includeFailedResponsesOnly)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getTimeoutMessage() throws CommandException {
        StringBuilder sb = new StringBuilder("Operation timed out. No response from the server(s).");
        sb.append(" [");
        Object object = this._responseMutex;
        synchronized (object) {
            for (Address ip : this._commands.keySet()) {
                if (!this._responses.containsKey(ip)) {
                    sb.append(ip + ", ");
                    continue;
                }
                if (!this.ExpectingResponseFrom(ip)) continue;
                sb.append(ip + ", ");
            }
        }
        int length = sb.length();
        sb.delete(length - 2, length);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CommandResponse getResponse() throws InvalidReaderException, CommandException {
        Object object = this._responseMutex;
        synchronized (object) {
            this.DeserializeRawResponsesIfPresent();
            for (Map.Entry<Address, HashMap<Integer, ResponseList>> allResponses : this._responses.entrySet()) {
                for (ResponseList responses : allResponses.getValue().values()) {
                    for (CommandResponse rsp : responses.getResponses()) {
                        if (rsp.getExpMessage() != null && !rsp.getExpMessage().isEmpty() && rsp.getExpValue() != null && rsp.getExpValue() != ExceptionProtocol.Exception.Type.STATE_TRANSFER_EXCEPTION && rsp.getExpValue() != ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND && rsp.getExpValue() != ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND) {
                            this._finalResponse = rsp;
                            return this._finalResponse;
                        }
                        this.MergeResponse(allResponses.getKey(), rsp);
                    }
                }
            }
        }
        return this._finalResponse;
    }

    public void setLogger(Logs logger) {
        this.privateLogger = logger;
    }

    private Logs getLogger() {
        return this.privateLogger;
    }

    public final HashMap<Address, ResponseList> getResponses() {
        HashMap<Address, ResponseList> responses = new HashMap<Address, ResponseList>();
        for (Map.Entry<Address, HashMap<Integer, ResponseList>> allResponses : this._responses.entrySet()) {
            for (ResponseList rspList : allResponses.getValue().values()) {
                ResponseList existingList = null;
                existingList = responses.get(allResponses.getKey());
                if (existingList != null) {
                    existingList.MergeWith(rspList);
                    continue;
                }
                responses.put(allResponses.getKey(), rspList);
            }
        }
        return responses;
    }

    public final boolean getIsCompleteResponseReceived() throws CommandException {
        return this.NumberOfCompleteResponses(false) >= this._commands.size();
    }

    public final boolean getHasFailedResponses() throws CommandException {
        return this.NumberOfCompleteResponses(true) > 0;
    }

    public final void addCommand(Address address, Command command) {
        this.setName(command.getCommandName());
        command.setParent(this);
        command.setCommandID(this.getNextCommandID());
        if (this._commands == null) {
            this._commands = new HashMap();
        }
        if (!this._commands.containsKey(address)) {
            this._commands.put(address, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResponse(Address address, CommandResponse response) {
        this._type = response.getType();
        if (response.isSurrogate()) {
            Address actualAddress = null;
            if (this._surrogateCommands != null && this._surrogateCommands.containsKey(address)) {
                actualAddress = this._surrogateCommands.get(address).getActualTargetNode();
                this._surrogateCommands.remove(address);
            }
            address = actualAddress;
            response.setActualTargetNode(actualAddress);
        }
        Object object = this._responseMutex;
        synchronized (object) {
            if (this._responses.containsKey(address)) {
                if (!response.getIsInternalResponse() && response.isNeedsDeserialization()) {
                    if (this._rawResponses == null) {
                        this._rawResponses = new ArrayList();
                    }
                    this._rawResponses.add(response);
                } else {
                    if (response.getCommandId() <= 0) {
                        HashMap<Integer, ResponseList> responses = this._responses.get(address);
                        for (ResponseList rsp : responses.values()) {
                            if (rsp.IsComplete(false)) continue;
                            rsp.AddResponse(response);
                            break;
                        }
                        return;
                    }
                    ResponseList responseList = this._responses.get(address).get(response.getCommandId());
                    if (responseList != null && (Connection.WriteRequestIdInResponse || !responseList.IsComplete(false))) {
                        responseList.AddResponse(response);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DeserializeRawResponsesIfPresent() throws CommandException {
        if (this._rawResponses != null && this._rawResponses.size() > 0) {
            for (int i = 0; i < this._rawResponses.size(); ++i) {
                CommandResponse respnse = this._rawResponses.get(i);
                ByteArrayInputStream targetStream = new ByteArrayInputStream(respnse.getRawResult());
                try {
                    try {
                        respnse.setResult(ResponseHelper.deserializeResponse((ResponseProtocol.Response.Type)respnse.getType(), (InputStream)targetStream));
                    }
                    finally {
                        ((InputStream)targetStream).close();
                    }
                }
                catch (Exception ex) {
                    throw new CommandException(ex.getMessage());
                }
                respnse.setNeedsDeserialization(false);
                this.addResponse(respnse.getSourceAddress(), respnse);
            }
            this._rawResponses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void InitializeResponse(Address address, Command command) {
        if (command instanceof SurrogateCommand) {
            address = ((SurrogateCommand)command).getActualTargetNode();
        }
        Object object = this._responseMutex;
        synchronized (object) {
            if (this._responses == null) {
                this._responses = new HashMap();
            }
            if (!this._responses.containsKey(address)) {
                this._responses.put(address, new HashMap());
            }
            HashMap<Integer, ResponseList> allResponses = this._responses.get(address);
            allResponses.put(command.getCommandID(), new ResponseList(command));
        }
        command.setFinalDestinationAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void InitializeFailedResponse(Address address, Command command) {
        Object object = this._responseMutex;
        synchronized (object) {
            if (this._responses == null) {
                this._responses = new HashMap();
            }
            if (!this._responses.containsKey(address)) {
                this._responses.put(address, new HashMap());
            }
            HashMap<Integer, ResponseList> allResponses = this._responses.get(address);
            allResponses.put(command.getCommandID(), new ResponseList(command));
            allResponses.get(command.getCommandID()).AddResponse(new CommandResponse(true, address));
        }
        command.setFinalDestinationAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveResponse(Address address, int commandId) {
        Object object = this._responseMutex;
        synchronized (object) {
            if (address != null && this._responses.containsKey(address)) {
                this._responses.get(address).remove(commandId);
                if (this._responses.get(address).isEmpty()) {
                    this._responses.remove(address);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ClearResponses() {
        Object object = this._responseMutex;
        synchronized (object) {
            if (this._responses != null) {
                this._responses.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ExpectingResponseFrom(Address address) throws CommandException {
        Object object = this._responseMutex;
        synchronized (object) {
            this.DeserializeRawResponsesIfPresent();
            if (this._responses != null && this._responses.containsKey(address)) {
                for (ResponseList responseList : this._responses.get(address).values()) {
                    if (responseList.IsComplete(false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final void Reset(Address ip) throws CommandException {
        this.ResetInternal(ip);
        if (this._surrogateCommands != null && this._surrogateCommands.containsKey(ip)) {
            SurrogateCommand surrogateCommand = this._surrogateCommands.get(ip);
            this._surrogateCommands.remove(ip);
            if (surrogateCommand != null) {
                this.ResetInternal(surrogateCommand.getActualTargetNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ResetInternal(Address ip) throws CommandException {
        Object object = this._responseMutex;
        synchronized (object) {
            this.DeserializeRawResponsesIfPresent();
            if (this._responses.containsKey(ip)) {
                HashMap<Integer, ResponseList> allResponses = this._responses.get(ip);
                for (ResponseList responseList : allResponses.values()) {
                    if (responseList.IsComplete(false)) continue;
                    responseList.Clear();
                    responseList.AddResponse(new CommandResponse(true, ip));
                    if (this._failedCommands == null) {
                        this._failedCommands = new ArrayList();
                    }
                    this._failedCommands.add(responseList.getCommand());
                }
            }
        }
    }

    public final void SetAggregateFunctionResult() {
        switch (this._finalResponse.getQueryResultSet().getAggregateFunctionType()) {
            case MAX: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.MAX, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
                break;
            }
            case MIN: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.MIN, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
                break;
            }
            case COUNT: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.COUNT, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
                break;
            }
            case SUM: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.SUM, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
                break;
            }
            case AVG: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.AVG, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
                break;
            }
            case TERMFREQ: {
                this._finalResponse.getQueryResultSet().setAggregateFunctionResult(new DictionaryEntry(AggregateFunctionType.TERMFREQ, this._finalResponse.getQueryResultSet().getAggregateFunctionResult().getValue()));
            }
        }
    }

    public final void MergeResponse(Address address, CommandResponse response) throws InvalidReaderException {
        if (this._finalResponse == null && response.getType() != ResponseProtocol.Response.Type.GET_NEXT_CHUNK && response.getType() != ResponseProtocol.Response.Type.GET_READER_CHUNK && response.getType() != ResponseProtocol.Response.Type.EXECUTE_READER && response.getType() != ResponseProtocol.Response.Type.EXECUTE_READER_CQ) {
            this._finalResponse = response;
            if (response.isBrokerReset()) {
                this.MergeFailedResponse(response);
            }
        } else if (response.isBrokerReset()) {
            this.MergeFailedResponse(response);
        } else {
            block0 : switch (response.getType()) {
                case POLL: {
                    this._finalResponse.getPollingResult().getRemovedKeys().addAll(response.getPollingResult().getRemovedKeys());
                    this._finalResponse.getPollingResult().getUpdatedKeys().addAll(response.getPollingResult().getUpdatedKeys());
                    break;
                }
                case ADD_BULK: 
                case INSERT_BULK: 
                case GET_BULK: 
                case BULK_GET_CACHEITEM: 
                case REMOVE_BULK: 
                case GET_GROUP_DATA: 
                case GET_TAG: 
                case HYBRID_BULK: 
                case INVOKE_ENTRY_PROCESSOR: 
                case MESSAGE_ACKNOWLEDGEMENT: 
                case MESSAGE_PUBLISH_BULK: {
                    HashMap hashMap = response.getResultMap();
                    HashMap finalMap = this._finalResponse.getResultMap();
                    if (finalMap != null && hashMap != null) {
                        finalMap.putAll(hashMap);
                    }
                    HashMap map = response.getVersionMap();
                    finalMap = this._finalResponse.getVersionMap();
                    if (finalMap == null || map == null) break;
                    finalMap.putAll(map);
                    break;
                }
                case CONTAINS_BULK: {
                    HashMap hashMap = response.getResultMap();
                    HashMap finalMap = this._finalResponse.getResultMap();
                    if (finalMap == null || hashMap == null) break;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (finalMap.containsKey(entry.getKey())) {
                            ((ArrayList)finalMap.get(entry.getKey())).addAll((ArrayList)entry.getValue());
                            continue;
                        }
                        finalMap.put(entry.getKey(), entry.getValue());
                    }
                    break;
                }
                case GET_MESSAGE: {
                    for (Map.Entry<String, List<MessageItem>> entry : response.getMessageDic().entrySet()) {
                        if (!this._finalResponse.getMessageDic().containsKey(entry.getKey())) {
                            this._finalResponse.getMessageDic().put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        for (MessageItem message : entry.getValue()) {
                            this._finalResponse.getMessageDic().get(entry.getKey()).add(message);
                        }
                    }
                    break;
                }
                case GET_GROUP_KEYS: 
                case GET_KEYS_TAG: {
                    this._finalResponse.getResultList().addAll(response.getResultList());
                    break;
                }
                case EXECUTE_READER: 
                case EXECUTE_READER_CQ: {
                    List protoReaders;
                    if (this._finalResponse == null) {
                        this._finalResponse = response;
                    }
                    if (this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND || this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND) {
                        this._finalResponse = response;
                        if (response.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND && response.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND) break;
                    }
                    List list = protoReaders = response.getType() == ResponseProtocol.Response.Type.EXECUTE_READER ? response.getProtobufResponse().getExecuteReaderResponse().getReaderResultSetsList() : response.getProtobufResponse().getExecuteReaderCQResponse().getReaderResultSetsList();
                    if (protoReaders == null || protoReaders.size() <= 0) break;
                    for (ReaderResultSetProtocol.ReaderResultSet protoReaderResultSet : protoReaders) {
                        ReaderResultSet readerResultSet = null;
                        for (ReaderResultSet set : this._finalResponse.getReaderResultSets()) {
                            if (!protoReaderResultSet.getReaderId().equals(set.getReaderID()) || !protoReaderResultSet.getNodeAddress().equals(set.getNodeAddress())) continue;
                            readerResultSet = set;
                            break;
                        }
                        if (readerResultSet != null) {
                            this.PopulateRows(readerResultSet.getRecordSet(), protoReaderResultSet.getRecordSet().getRowsList());
                            continue;
                        }
                        readerResultSet = this.ConvertToReaderResult(protoReaderResultSet);
                        this._finalResponse.getReaderResultSets().add(readerResultSet);
                    }
                    break;
                }
                case GET_READER_CHUNK: {
                    if (this._finalResponse == null) {
                        this._finalResponse = response;
                    }
                    ReaderResultSetProtocol.ReaderResultSet protoReaderChunkResultSet = response.getProtobufResponse().getGetReaderChunkResponse().getReaderResultSets();
                    ReaderResultSet readerChunkResultSet = this._finalResponse.getReaderNextChunk();
                    if (readerChunkResultSet != null) {
                        this.PopulateRows(readerChunkResultSet.getRecordSet(), protoReaderChunkResultSet.getRecordSet().getRowsList());
                        break;
                    }
                    readerChunkResultSet = this.ConvertToReaderResult(protoReaderChunkResultSet);
                    this._finalResponse.setReaderNextChunk(readerChunkResultSet);
                    break;
                }
                case DELETE_QUERY: 
                case REMOVE_QUERY: {
                    if (this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND || this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND) {
                        if (response.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND || response.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND) break;
                        this._finalResponse = response;
                        break;
                    }
                    if ((this._finalResponse == null || response.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND) && response.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND) break;
                    this._finalResponse.setRemovedKeyCount(this._finalResponse.getRemovedKeyCount() + response.getRemovedKeyCount());
                    break;
                }
                case SEARCH: {
                    if (this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.TYPE_INDEX_NOT_FOUND || this._finalResponse.getExpValue() == ExceptionProtocol.Exception.Type.ATTRIBUTE_INDEX_NOT_FOUND) {
                        this._finalResponse = response;
                        break;
                    }
                    switch (response.getQueryResultSet().getAggregateFunctionType()) {
                        case NOTAPPLICABLE: {
                            ArrayList list = response.getResultList();
                            if (list == null) break block0;
                            this._finalResponse.getResultList().addAll(list);
                            break block0;
                        }
                    }
                    if (!this._finalResponse.getQueryResultSet().getIsInitialized()) {
                        this.SetAggregateFunctionResult();
                        this._finalResponse.getQueryResultSet().Initialize(this._finalResponse.getQueryResultSet());
                    }
                    this._finalResponse.getQueryResultSet().Compile(response.getQueryResultSet());
                    break;
                }
                case GET_SERVER_MAPPING: {
                    this._finalResponse.setServerMappingList(response.getServerMappingList());
                    break;
                }
                case SEARCH_ENTRIES_CQ: {
                    String uniqueId;
                    HashMap map1 = response.getResultMap();
                    HashMap finalMap1 = this._finalResponse.getResultMap();
                    if (finalMap1 != null && map1 != null) {
                        finalMap1.putAll(map1);
                    }
                    if (response.getQueryResultSet() == null || response.getQueryResultSet().getCQUniqueId() == null || (uniqueId = response.getQueryResultSet().getCQUniqueId()).equals("-1") || uniqueId.isEmpty() || this._finalResponse.getQueryResultSet() == null || this._finalResponse.getQueryResultSet().getCQUniqueId() != null && !this._finalResponse.getQueryResultSet().getCQUniqueId().isEmpty()) break;
                    this._finalResponse.getQueryResultSet().setCQUniqueId(response.getQueryResultSet().getCQUniqueId());
                    break;
                }
                case GET_NEXT_CHUNK: {
                    EnumerationDataChunk chunk;
                    if (this._finalResponse == null) {
                        this._finalResponse = response;
                    }
                    if (this._chunks == null) {
                        this._chunks = new HashMap();
                    }
                    if (this._chunks.containsKey(address)) {
                        chunk = this._chunks.get(address);
                    } else {
                        chunk = new EnumerationDataChunk();
                        chunk.setData(new ArrayList());
                        this._chunks.put(address, chunk);
                    }
                    for (int i = 0; i < response.getNextChunk().size(); ++i) {
                        EnumerationDataChunk enumerationDataChunk = response.getNextChunk().get(i);
                        chunk.getData().addAll(enumerationDataChunk.getData());
                        chunk.setPointer(enumerationDataChunk.getPointer());
                        if (chunk.getPointer().getNodeIpAddress() != null) continue;
                        chunk.getPointer().setNodeIpAddress(address);
                    }
                    this._finalResponse.setNextChunk(new ArrayList<EnumerationDataChunk>(this._chunks.values()));
                    break;
                }
                case TASK_ENUMERATOR: {
                    this._finalResponse.setTaskEnumerator(response.getTaskEnumerator());
                    break;
                }
                case EXCEPTION: {
                    if (response.getExpValue().getNumber() != ExceptionType.STATE_TRANSFER_EXCEPTION.getValue()) break;
                    this._finalResponse = response;
                    break;
                }
            }
        }
    }

    private ReaderResultSet ConvertToReaderResult(ReaderResultSetProtocol.ReaderResultSet readerResultSetProto) throws InvalidReaderException {
        if (readerResultSetProto == null) {
            return null;
        }
        ReaderResultSet readerResultSet = new ReaderResultSet();
        readerResultSet.setIsGrouped(readerResultSetProto.getIsGrouped());
        readerResultSet.setNodeAddress(readerResultSetProto.getNodeAddress());
        readerResultSet.setNextIndex(readerResultSetProto.getNextIndex());
        readerResultSet.setReaderID(readerResultSetProto.getReaderId());
        ArrayList<OrderByArgument> orderByArgs = new ArrayList<OrderByArgument>();
        for (OrderByArgumentProtocol.OrderByArgument obaProto : readerResultSetProto.getOrderByArgumentsList()) {
            OrderByArgument arg = new OrderByArgument();
            arg.setAttributeName(obaProto.getAttributeName());
            arg.setOrder(obaProto.getOrder().getNumber());
            orderByArgs.add(arg);
        }
        readerResultSet.setOrderByArguments(orderByArgs);
        RecordSetImpl recordSet = null;
        if (readerResultSetProto.getRecordSet() != null) {
            recordSet = new RecordSetImpl();
            RecordSetProtocol.RecordSet recordSetProto = readerResultSetProto.getRecordSet();
            for (RecordColumnProtocol.RecordColumn columnProto : recordSetProto.getColumnsList()) {
                RecordColumn column = new RecordColumn(columnProto.getName());
                column.setAggregateFunctionType(AggregateFunctionType.forValue((int)columnProto.getAggregateFunctionType().getNumber()));
                column.setColumnType(ColumnType.forValue((int)columnProto.getColumnType().getNumber()));
                column.setDataType(ColumnDataType.forValue((int)columnProto.getDataType().getNumber()));
                column.setIsFilled(columnProto.getIsFilled());
                column.setIsHidden(columnProto.getIsHidden());
                column.setUserSpecifiedColumn(columnProto.getIsUserSpecifiedColumn());
                recordSet.addColumn(column);
            }
            this.PopulateRows(recordSet, recordSetProto.getRowsList());
        }
        readerResultSet.setRecordSet(recordSet);
        return readerResultSet;
    }

    private void PopulateRows(RecordSetImpl recordSet, List<RecordRowProtocol.RecordRow> rows) throws InvalidReaderException {
        try {
            if (recordSet != null && rows != null) {
                for (RecordRowProtocol.RecordRow rowProto : rows) {
                    RecordRow row = recordSet.createRow();
                    if (recordSet.getColumns() != null) {
                        block8: for (int i = 0; i < recordSet.getColumns().getCount(); ++i) {
                            ColumnDataType columnDataType;
                            if (rowProto.getValues(i) == null || (columnDataType = recordSet.getColumns().get(i).getDataType()) == null) continue;
                            switch (columnDataType) {
                                case AverageResult: {
                                    AverageResult avgResult = new AverageResult();
                                    avgResult.setSum(new BigDecimal(rowProto.getValues(i).getAvgResult().getSum()));
                                    avgResult.setCount(new BigDecimal(rowProto.getValues(i).getAvgResult().getCount()));
                                    row.set(i, (Object)avgResult);
                                    continue block8;
                                }
                                case CompressedValueEntry: {
                                    ValueProtocol.Value val = rowProto.getValues(i).getBinaryObject();
                                    UserBinaryObject ubObject = UserBinaryObject.createUserBinaryObject((Collection)val.getDataList());
                                    byte[] bytes = ubObject.getFullObject();
                                    CompressedValueEntry cmpEntry = new CompressedValueEntry();
                                    cmpEntry.flag = new BitSet((byte)rowProto.getValues(i).getFlag());
                                    cmpEntry.setType(EntryType.forValue((int)rowProto.getValues(i).getType()));
                                    cmpEntry.value = bytes;
                                    row.set(i, (Object)cmpEntry);
                                    continue block8;
                                }
                                case Metadata: {
                                    row.set(i, (Object)rowProto.getValues(i).getStringValue());
                                    if (!EntryType.getMappings().containsValue(row.get(i).toString())) continue block8;
                                    row.set(i, (Object)EntryType.valueOf((String)row.get(i).toString()));
                                    continue block8;
                                }
                                default: {
                                    if (rowProto.getValues(i).getFlag() == Integer.MIN_VALUE) continue block8;
                                    row.set(i, RecordSet.ToObject((String)rowProto.getValues(i).getStringValue(), (ColumnDataType)recordSet.getColumns().get(i).getDataType()));
                                }
                            }
                        }
                    }
                    recordSet.addRow(row);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidReaderException("Reader state has been lost.: ", ex);
        }
    }

    public final String getCacheId() {
        return this.cacheId;
    }

    public final void setCacheId(String value) {
        this.cacheId = value;
    }

    private void MergeFailedResponse(CommandResponse response) {
        boolean success;
        Command command = null;
        command = this._commands.get(response.getResetConnectionIP());
        boolean bl = success = command != null;
        if (!success) {
            try {
                command = this._commands.get(new Address(InetAddress.getLocalHost().getHostAddress(), 9800));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        switch (this._type) {
            case ADD_BULK: 
            case INSERT_BULK: 
            case GET_BULK: 
            case REMOVE_BULK: 
            case INVOKE_ENTRY_PROCESSOR: {
                for (int index = 0; index < command.getBulkKeys().length; ++index) {
                    String key = command.getBulkKeys()[index];
                    this._finalResponse.getResultMap().put(key, new ConnectionException("Connection with server lost [" + response.getResetConnectionIP() + "]"));
                }
                this._finalResponse.setBrokerRequested(false);
                break;
            }
            case MESSAGE_PUBLISH_BULK: {
                for (MessagePublishCommandProtocol.MessagePublishCommand messagePublishCommand : ((MessagePublishBulkCommand)command)._commandInstance.getMessagePublishCommandList()) {
                    this._finalResponse.getResultMap().put(messagePublishCommand.getMessageId(), new ConnectionException("Connection with server lost [" + response.getResetConnectionIP() + "]"));
                }
                this._finalResponse.setBrokerRequested(false);
                break;
            }
            case HYBRID_BULK: {
                for (int index = 0; index < command.getBridgeOperations().length; ++index) {
                    BridgeOperation bridgeoperation = command.getBridgeOperations()[index];
                    this._finalResponse.getResultMap().put(bridgeoperation, new ConnectionException("Connection with server lost [" + response.getResetConnectionIP() + "]"));
                }
                this._finalResponse.setBrokerRequested(false);
                break;
            }
            case POLL: 
            case GET_GROUP_DATA: 
            case GET_TAG: 
            case MESSAGE_ACKNOWLEDGEMENT: 
            case GET_MESSAGE: 
            case GET_GROUP_KEYS: 
            case GET_KEYS_TAG: 
            case EXECUTE_READER: 
            case EXECUTE_READER_CQ: 
            case SEARCH: 
            case SEARCH_ENTRIES_CQ: 
            case SEARCH_CQ: 
            case SEARCH_ENTRIES: {
                this._finalResponse.setBrokerRequested(true);
                this._finalResponse.setResetConnectionIP(response.getResetConnectionIP());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<Map.Entry<Address, Command>> GetSendFailureCommands() throws CommandException {
        ArrayList<AbstractMap.SimpleEntry<Address, Command>> failedSendCommands = null;
        Object object = this._responseMutex;
        synchronized (object) {
            this.DeserializeRawResponsesIfPresent();
            for (Map.Entry<Address, HashMap<Integer, ResponseList>> allResponses : this._responses.entrySet()) {
                block4: for (ResponseList responses : allResponses.getValue().values()) {
                    for (CommandResponse rsp : responses.getResponses()) {
                        if (!rsp.getIsSendFailure()) continue;
                        if (failedSendCommands == null) {
                            failedSendCommands = new ArrayList<AbstractMap.SimpleEntry<Address, Command>>();
                        }
                        failedSendCommands.add(new AbstractMap.SimpleEntry<Address, Command>(allResponses.getKey(), responses.getCommand()));
                        continue block4;
                    }
                }
            }
        }
        return failedSendCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void InitializeFailedSendResponse(Address address, Command command) {
        Object object = this._responseMutex;
        synchronized (object) {
            if (this._responses == null) {
                this._responses = new HashMap();
            }
            if (!this._responses.containsKey(address)) {
                this._responses.put(address, new HashMap());
            }
            HashMap<Integer, ResponseList> allResponses = this._responses.get(address);
            allResponses.put(command.getCommandID(), new ResponseList(command));
            CommandResponse response = new CommandResponse(false, address);
            response.setSendFailure(true);
            allResponses.get(command.getCommandID()).AddResponse(response);
        }
        command.setFinalDestinationAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void RemoveResponse(ArrayList<Map.Entry<Address, Command>> failedSendCommands) {
        Object object = this._responseMutex;
        synchronized (object) {
            for (Map.Entry<Address, Command> pair : failedSendCommands) {
                Address address = pair.getKey();
                Command command = pair.getValue();
                if (address == null || !this._responses.containsKey(address)) continue;
                this._responses.get(address).remove(command.getCommandID());
                if (!this._responses.get(address).isEmpty()) continue;
                this._responses.remove(address);
            }
        }
    }

    public final void AddSurrogateCommand(SurrogateCommand surrogateCommand, Address address) {
        if (this._surrogateCommands == null) {
            this._surrogateCommands = new HashMap();
        }
        surrogateCommand.setParent(this);
        this._surrogateCommands.put(address, surrogateCommand);
    }

    public final void RemoveSurrogateCommand(Address address) {
        if (this._surrogateCommands != null) {
            this._surrogateCommands.remove(address);
        }
    }

    public void getModuleResponses(ModuleOperation operation) throws OperationFailedException {
        HashMap<Address, ResponseList> responses = this.getResponses();
        if (responses != null) {
            for (Map.Entry<Address, ResponseList> perServerResponse : responses.entrySet()) {
                for (CommandResponse response : perServerResponse.getValue().getResponses()) {
                    Partition tempVar = new Partition();
                    tempVar.setAddress(perServerResponse.getKey());
                    Partition partition = tempVar;
                    try {
                        response.parseResponse();
                    }
                    catch (Exception e) {
                        operation.AddFailure(partition, e);
                        continue;
                    }
                    if (response.getProtobufResponse().getModuleResponse() == null) {
                        throw new OperationFailedException("protobuff response is null");
                    }
                    operation.AddResult(partition, response.getProtobufResponse().getModuleResponse().getPayload(0).toByteArray());
                }
            }
        }
    }
}

