/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import com.alachisoft.ncache.client.datastructures.DistributedDataStructure;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.CounterImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedHashSetImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedListImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedMapImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedQueueImpl;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public class DataTypeCreator {
    public static DistributedDataStructure createDataTypeHandle(EntryType entryType, String key, CacheImpl cache) throws OperationFailedException {
        DataTypeCreator.ValidateCacheInstance(cache);
        switch (entryType) {
            case Dictionary: {
                return new DistributedMapImpl(key, cache, new WriteThruOptions(WriteMode.None), null);
            }
            case List: {
                return new DistributedListImpl(key, cache, new WriteThruOptions(WriteMode.None), null);
            }
            case Queue: {
                return new DistributedQueueImpl(key, cache, new WriteThruOptions(WriteMode.None), null);
            }
            case Set: {
                return new DistributedHashSetImpl(key, cache, new WriteThruOptions(WriteMode.None), null);
            }
            case Counter: {
                return new CounterImpl(key, cache, new WriteThruOptions(WriteMode.None), null);
            }
        }
        throw new OperationFailedException("{ " + entryType + "} data type is not supported.");
    }

    public static <T> DistributedDataStructure createDataTypeHandle(EntryType entryType, String key, CacheImpl cache, Class<?> cls) throws OperationFailedException {
        if (cls == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cls");
        }
        DataTypeCreator.ValidateCacheInstance(cache);
        Class type = DataTypeCreator.ExtractGenericType(cls);
        return DataTypeCreator.OptimizedCreateDataStructureHandle(key, cache, type, entryType);
    }

    private static Class ExtractGenericType(Class<?> cls) {
        if (!DistributedDataStructure.class.isAssignableFrom(cls)) {
            return cls;
        }
        Type[] genArgs = cls.getGenericInterfaces();
        int genTypeNum = genArgs == null ? 0 : genArgs.length;
        try {
            return genTypeNum > 0 ? Class.forName(genArgs[genTypeNum - 1].getTypeName()) : cls;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static <T> DistributedDataStructure OptimizedCreateDataStructureHandle(String key, CacheImpl cache, Class cls, EntryType entryType) throws OperationFailedException {
        switch (cls.getName()) {
            case "java.lang.String": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.math.BigDecimal": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Double": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Integer": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Long": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Float": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Short": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Byte": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.lang.Character": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
            case "java.util.Date": {
                return DataTypeCreator.NonReflectiveCreateDataType(entryType, key, cache, cls);
            }
        }
        return DataTypeCreator.ReflectiveCreateDataType(entryType, cls, key, cache, cls);
    }

    private static <T> DistributedDataStructure NonReflectiveCreateDataType(EntryType entryType, String key, CacheImpl cache, Class<?> cls) {
        switch (entryType) {
            case Counter: {
                return new CounterImpl(key, cache, null, null);
            }
            case Dictionary: {
                return new DistributedMapImpl(key, cache, null, cls);
            }
            case List: {
                return new DistributedListImpl(key, cache, null, cls);
            }
            case Queue: {
                return new DistributedQueueImpl(key, cache, null, (Class)cls);
            }
            case Set: {
                return new DistributedHashSetImpl(key, cache, null, cls);
            }
        }
        throw new UnsupportedOperationException("'" + entryType + "' data type is not supported.");
    }

    private static <T> DistributedDataStructure ReflectiveCreateDataType(EntryType entryType, Class genericType, String name, CacheImpl cache, Class<?> cls) throws OperationFailedException {
        Class parameterizedClass = null;
        DistributedDataStructure distributedDataStructure = null;
        switch (entryType) {
            case Counter: {
                parameterizedClass = CounterImpl.class;
                break;
            }
            case Dictionary: {
                parameterizedClass = DistributedMapImpl.class;
                break;
            }
            case List: {
                parameterizedClass = DistributedListImpl.class;
                break;
            }
            case Queue: {
                parameterizedClass = DistributedQueueImpl.class;
                break;
            }
            case Set: {
                parameterizedClass = DistributedHashSetImpl.class;
                break;
            }
            default: {
                throw new OperationFailedException("'" + entryType + "' data type is not supported.");
            }
        }
        try {
            Class[] params = new Class[]{String.class, CacheImpl.class, WriteThruOptions.class, Class.class};
            distributedDataStructure = (DistributedDataStructure)parameterizedClass.getConstructor(params).newInstance(name, cache, null, cls);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new OperationFailedException((Throwable)e);
        }
        return distributedDataStructure;
    }

    private static void ValidateCacheInstance(CacheImpl cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cache");
        }
    }
}

