/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Caching.Util.CollectionUtil;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.datastructures.DistributedDataStructure;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.CacheRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.GeneralFailureRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

abstract class DistributedDataStructureImpl
implements DistributedDataStructure {
    protected Class _valueType;
    protected TimeSpan _lockTimeout = new TimeSpan();
    protected LockHandle _lockHandle;
    private String _key;
    private CacheImpl _cache;
    private WriteThruOptions _writeThruOptions;

    DistributedDataStructureImpl(String key, CacheImpl cache, WriteThruOptions options, Class<?> cls) {
        this._key = key;
        this._cache = cache;
        this._lockTimeout = TimeSpan.MaxValue;
        this._valueType = cls;
        this._lockHandle = new LockHandle(null, new Date(Long.MAX_VALUE));
        this._writeThruOptions = options == null ? new WriteThruOptions(WriteMode.None, "") : options;
    }

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public WriteThruOptions getWriteThruOptions() {
        return this._writeThruOptions;
    }

    @Override
    public void setWriteThruOptions(WriteThruOptions value) {
        this._writeThruOptions = value == null ? new WriteThruOptions() : new WriteThruOptions(value.getMode(), value.getProviderName());
    }

    @Override
    public boolean lock(TimeSpan timeout) {
        this._lockTimeout = timeout;
        this._lockHandle = new LockHandle(this._lockHandle);
        boolean tempVar = false;
        try {
            tempVar = this.getCache().lock(this.getKey(), timeout, this._lockHandle);
        }
        catch (CacheException e) {
            throw new CacheRuntimeException((Throwable)e);
        }
        return tempVar;
    }

    @Override
    public void unlock() {
        try {
            this.getCache().unlock(this.getKey(), this._lockHandle);
        }
        catch (CacheException e) {
            throw new CacheRuntimeException((Throwable)e);
        }
        this._lockHandle = new LockHandle(null, new Date(Long.MAX_VALUE));
    }

    CacheImpl getCache() {
        if (this._cache == null) {
            throw new OperationFailedRuntimeException(10006, ErrorMessages.getErrorMessage((int)45006, (String[])new String[0]));
        }
        return this._cache;
    }

    public int size() {
        try {
            return this.CountInternal(this.getDataType());
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    public void clear() {
        try {
            this.ClearInternal(this.getDataType());
        }
        catch (AggregateException | OperationFailedException e) {
            throw new OperationFailedRuntimeException(e);
        }
        catch (GeneralFailureException e) {
            throw new GeneralFailureRuntimeException((Throwable)e);
        }
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public void addChangeListener(DataStructureDataChangeListener dataTypeDataChangeListener, EnumSet<EventType> eventType, DataTypeEventDataFilter datafilter) throws CacheException {
        if (this.getCache() == null) {
            throw new OperationFailedRuntimeException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (dataTypeDataChangeListener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: dataTypeDataChangeListener");
        }
        short[] callbackRefs = this.getCache().getEventManager().registerCollectionEvent(dataTypeDataChangeListener, EventUtil.getEventTypeInternalEnumSet(eventType), datafilter);
        this.getCache().addCollectionNotificationListener(this._key, callbackRefs[0], callbackRefs[1], callbackRefs[2], datafilter, this.getDataType(), true);
    }

    public void removeChangeListener(DataStructureDataChangeListener dataTypeDataChangeListener, EnumSet<EventType> eventType) throws Exception {
        if (this.getCache() == null) {
            throw new OperationFailedRuntimeException(10006, ErrorMessages.getErrorMessage((int)10006, (String[])new String[0]));
        }
        if (dataTypeDataChangeListener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: dataTypeDataChangeListener");
        }
        short[] callbackRefs = this.getCache().getEventManager().UnregisterCollectionNotification(dataTypeDataChangeListener, EventUtil.getEventTypeInternalEnumSet(eventType));
        this.getCache().removeCollectionNotificationListener(this._key, callbackRefs[0], callbackRefs[1], callbackRefs[2], EventUtil.getEventTypeInternal(eventType), this.getDataType());
    }

    final void validateTypeNotCacheItem(Class type) {
        if (type.equals(CacheItem.class)) {
            throw new OperationFailedRuntimeException(ErrorMessages.getErrorMessage((int)45004, (String[])new String[0]));
        }
    }

    protected abstract com.alachisoft.ncache.runtime.caching.DistributedDataStructure getDataType();

    protected final void ClearInternal(com.alachisoft.ncache.runtime.caching.DistributedDataStructure dataType) throws OperationFailedException, GeneralFailureException, AggregateException {
        this.getCache().clearCollection(this.getKey(), dataType, this._lockHandle.getLockId(), this._lockTimeout);
    }

    final int CountInternal(com.alachisoft.ncache.runtime.caching.DistributedDataStructure dataType) throws OperationFailedException, GeneralFailureException, AggregateException {
        return this.getCache().collectionCount(this.getKey(), dataType, this._lockHandle.getLockId(), this._lockTimeout);
    }

    final <T> void CopyToInternal(Iterable<T> source, T[] destination, int destinationStartIndex, int sourceCount) {
        if (destination == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: destination");
        }
        if (!CollectionUtil.validateCopyToParams((int)destinationStartIndex, (int)destination.length, (int)sourceCount)) {
            return;
        }
        for (T item : source) {
            destination[destinationStartIndex++] = item;
        }
    }

    protected final <T> void CopyToInternal(Iterable<T> source, List<T> destination, int destinationStartIndex, int sourceCount) {
        if (destination == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: destination");
        }
        if (!CollectionUtil.validateCopyToParams((int)destinationStartIndex, (int)destination.size(), (int)sourceCount)) {
            return;
        }
        for (T item : source) {
            destination.set(destinationStartIndex++, item);
        }
    }
}

