/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.datastructure;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.DataTypes.KeyValuePairedEnumerationFilter;
import Alachisoft.NCache.Common.DataTypes.Responses.GetPairedCollectionChunkResponse;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.datastructure.DistributedCollectionIteratorImpl;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.runtime.CacheRuntimeException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import java.util.AbstractMap;
import java.util.Map;

class DistributedPairedCollectionIterator<K, V>
extends DistributedCollectionIteratorImpl<Map.Entry<K, V>> {
    private KeyValuePairedEnumerationFilter _filter;
    private Class _valueType;

    DistributedPairedCollectionIterator(CacheImpl cache, String key, DistributedDataStructure collectionType, KeyValuePairedEnumerationFilter filter, Class<?> cls) {
        super(cache, key, collectionType, cls);
        this._filter = filter;
    }

    @Override
    protected boolean moveNextInternal(boolean peekOnly) throws OperationFailedException, AggregateException, GeneralFailureException {
        if (this._index >= this._size && !this.getNextAvailableChunk()) {
            return this.MoveNextRare();
        }
        GetPairedCollectionChunkResponse response = (GetPairedCollectionChunkResponse)this._response;
        Map.Entry pair = (Map.Entry)response.getDataChunk().get(this._index);
        if (peekOnly) {
            return true;
        }
        try {
            this._current = this.GetKeyValueFromProtoPair(pair, this._filter);
            ++this._index;
        }
        catch (OperationFailedException e) {
            throw new OperationFailedRuntimeException((Throwable)e);
        }
        catch (CacheException e) {
            throw new CacheRuntimeException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean getNextAvailableChunk() throws OperationFailedException, GeneralFailureException, AggregateException {
        if (this._response == null || !this._response.getIsLastChunk()) {
            this._response = this._cache.getPairedCollectionChunkResponse(this._key, this._collectionType, this._response != null ? this._response.getVersion() : 0, this._response != null ? this._response.getNextIndex() : 0, this._filter);
            GetPairedCollectionChunkResponse response = (GetPairedCollectionChunkResponse)this._response;
            if (response.getDataChunk().size() == 0) {
                return false;
            }
            this._size = response.getDataChunk().size();
            this._index = 0;
            return true;
        }
        return false;
    }

    private Map.Entry<K, V> GetKeyValueFromProtoPair(Map.Entry<String, ExtendedJsonValueBase> pair, KeyValuePairedEnumerationFilter filter) throws CacheException {
        switch (filter) {
            case KeysOnly: {
                return new AbstractMap.SimpleEntry<String, Object>(pair.getKey(), null);
            }
            case ValuesOnly: {
                return new AbstractMap.SimpleEntry(null, this._cache.safeDeserialize(pair.getValue(), this._cache.getSerializationContext(), new BitSet(32), UserObjectType.DistributedDataType, null));
            }
            case BothKeysAndValues: {
                return new AbstractMap.SimpleEntry(pair.getKey(), this._cache.safeDeserialize(pair.getValue(), this._cache.getSerializationContext(), new BitSet(32), UserObjectType.DistributedDataType, null));
            }
        }
        return null;
    }
}

