/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.runtime.caching.DataSourceModifiedListener;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import tangible.RefObject;

public class ConversionUtil {
    public static void GetWriteOptions(WriteThruOptions writeOption, RefObject<WriteMode> mode, RefObject<String> providerName, RefObject<DataSourceModifiedListener> dataSourceModifiedCallback, RefObject<EnumSet<EventTypeInternal>> eventTypeInternal) {
        mode.argvalue = WriteMode.None;
        providerName.argvalue = null;
        dataSourceModifiedCallback.argvalue = null;
        eventTypeInternal.argvalue = EnumSet.of(EventTypeInternal.None);
        if (writeOption != null) {
            mode.argvalue = writeOption.getMode();
            providerName.argvalue = writeOption.getProviderName();
            dataSourceModifiedCallback.argvalue = writeOption.getDataSourceModificationListener();
            eventTypeInternal.argvalue = EventUtil.getEventTypeInternalEnumSet(writeOption.getEventTypes());
        }
    }

    public static void GetWriteOptions(WriteThruOptions writeOption, RefObject<WriteMode> mode, RefObject<String> providerName) {
        mode.argvalue = WriteMode.None;
        providerName.argvalue = null;
        if (writeOption != null) {
            mode.argvalue = writeOption.getMode();
            providerName.argvalue = writeOption.getProviderName();
        }
    }

    public static void GetReadOptions(ReadThruOptions readOption, RefObject<ReadMode> mode, RefObject<String> providerName) {
        mode.argvalue = ReadMode.None;
        providerName.argvalue = null;
        if (readOption != null) {
            mode.argvalue = readOption.getReadMode();
            providerName.argvalue = readOption.getProviderName();
        }
    }

    public static Date getAbsoluteExpiration(Expiration _expiration) {
        return _expiration != null ? ConversionUtil.getExpirationAbsoluteInternal(_expiration) : NCDateTime.MaxValue;
    }

    public static TimeSpan getSlidingExpiration(Expiration _expiration) {
        return _expiration != null ? ConversionUtil.getExpirationSlidingInternal(_expiration) : TimeSpan.Zero;
    }

    public static Date getExpirationAbsoluteInternal(Expiration _expiration) {
        switch (_expiration.getExpirationType()) {
            case DefaultAbsolute: {
                return ExpirationConstants.AbsoluteDefaultExpiration;
            }
            case DefaultAbsoluteLonger: {
                return ExpirationConstants.AbsoluteDefaultLongerExpiration;
            }
            case Absolute: {
                return new NCDateTime(new NCDateTime(new Date()).getTicks() + _expiration.getExpireAfter().getTotalTicks()).getDate();
            }
        }
        return ExpirationConstants.AbsoluteNoneExpiration;
    }

    public static TimeSpan getExpirationSlidingInternal(Expiration _expiration) {
        switch (_expiration.getExpirationType()) {
            case DefaultSliding: {
                return ExpirationConstants.SlidingDefaultExpiration;
            }
            case DefaultSlidingLonger: {
                return ExpirationConstants.SlidingDefaultLongerExpiration;
            }
            case Sliding: {
                return _expiration.getExpireAfter();
            }
            case None: {
                return TimeSpan.Zero;
            }
        }
        return ExpirationConstants.SlidingNoneExpiration;
    }

    public static Tag[] toArray(List<Tag> values) {
        if (values == null) {
            return null;
        }
        return values.toArray(new Tag[values.size()]);
    }

    public static <T> T[] toArray(Iterable<T> values, Class<T> cls) {
        if (values == null) {
            return null;
        }
        return Iterables.toArray(values, cls);
    }
}

