/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Management.ThinClientConfigManager;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.internal.util.Search;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import tangible.OutObject;

public class DirectoryUtil {
    public static CacheServerConfig getCacheDom(String cacheId, String userId, String password, boolean inproc) throws SecurityException {
        String filePath = DirectoryUtil.getBaseFilePath("config.ncconf");
        CacheServerConfig dom = null;
        if (filePath != null) {
            try {
                dom = ThinClientConfigManager.GetConfigDom((String)cacheId, (String)filePath, (String)userId, (String)password, (boolean)inproc);
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
        }
        return dom;
    }

    public static boolean searchGlobalDirectory(String directoryName, boolean createNew, OutObject<String> path) {
        String ncacheInstallDirectory = AppUtil.getInstallDir();
        if (ncacheInstallDirectory == null) {
            return false;
        }
        path.argValue = new File(ncacheInstallDirectory, directoryName).getPath();
        Path filepath = Paths.get((String)path.argValue, new String[0]);
        if (Files.isDirectory(filepath, LinkOption.NOFOLLOW_LINKS)) {
            if (createNew) {
                new File((String)path.argValue).mkdirs();
                return true;
            }
            return true;
        }
        return false;
    }

    public static String getBaseFilePath(String fileName) {
        OutObject tempOutResult = new OutObject();
        String tempVar = DirectoryUtil.searchLocal(fileName, (OutObject<Search>)tempOutResult);
        Search result = (Search)((Object)tempOutResult.argValue);
        return tempVar;
    }

    public static String getBaseFilePath(String fileName, Search search, OutObject<Search> result) {
        if (search == Search.LocalSearch) {
            return DirectoryUtil.searchLocal(fileName, result);
        }
        if (search == Search.LocalConfigSearch) {
            return DirectoryUtil.searchLocalConfig(fileName, result);
        }
        return DirectoryUtil.searchGlobal(fileName, result);
    }

    private static String searchLocal(String fileName, OutObject<Search> result) {
        result.argValue = Search.LocalSearch;
        Object path = null;
        path = DirectoryUtil.searchWebConfig(fileName, result);
        if (path != null && !((String)path).equalsIgnoreCase("")) {
            return path;
        }
        path = Paths.get("", new String[0]).toAbsolutePath().toString() + File.separatorChar + fileName;
        if (new File((String)path).isFile()) {
            return path;
        }
        return DirectoryUtil.searchLocalConfig(fileName, result);
    }

    private static String searchWebConfig(String fileName, OutObject<Search> result) {
        String path = CacheManager.getConfigPath();
        if (path != null && !path.equalsIgnoreCase("")) {
            if (!path.endsWith(Character.toString(File.separatorChar))) {
                path = path.concat(Character.toString(File.separatorChar));
            }
            if (new File(path = path.concat(fileName)).isFile()) {
                return path;
            }
        }
        return path;
    }

    private static String searchLocalConfig(String fileName, OutObject<Search> result) {
        result.argValue = Search.LocalConfigSearch;
        String path = null;
        String roleRootDir = System.getenv("RoleRoot");
        if (roleRootDir != null) {
            path = roleRootDir + "\\approot\\" + fileName;
            if (!new File(path).isFile()) {
                path = roleRootDir + "\\approot\\bin\\config\\" + fileName;
                if (new File(path).isFile()) {
                    return path;
                }
            } else {
                return path;
            }
        }
        return DirectoryUtil.searchGlobal(fileName, result);
    }

    private static String searchGlobal(String fileName, OutObject<Search> result) {
        String directoryPath;
        File file;
        result.argValue = Search.GlobalSearch;
        OutObject tempOutDirectoryPath = new OutObject();
        if (DirectoryUtil.searchGlobalDirectory("config", false, (OutObject<String>)tempOutDirectoryPath) && (file = new File(directoryPath = (String)tempOutDirectoryPath.argValue, fileName)).exists()) {
            return file.getPath();
        }
        return null;
    }
}

