/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.util;

import com.alachisoft.ncache.client.internal.util.IndexHelper;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class QueryCommandHelper {
    public static List<KeyValueProtocol.KeyValue> getValuesFromMap(Map from) {
        ArrayList<KeyValueProtocol.KeyValue> keyValueList = new ArrayList<KeyValueProtocol.KeyValue>();
        ValueWithTypeProtocol.ValueWithType.Builder valueWithType = null;
        for (Map.Entry object : from.entrySet()) {
            KeyValueProtocol.KeyValue.Builder keyValue = KeyValueProtocol.KeyValue.newBuilder();
            Map.Entry entry = object;
            keyValue.setKey(entry.getKey().toString());
            if (entry.getValue() instanceof ArrayList) {
                ArrayList list = (ArrayList)entry.getValue();
                for (Object value : list) {
                    if (value == null) {
                        throw new IllegalArgumentException("NCache query does not support null values. ", null);
                    }
                    Class<?> type = value.getClass();
                    boolean isTag = IndexHelper.isTag(type);
                    if (!IndexHelper.isIndexable(type) && !isTag) {
                        throw new IllegalArgumentException("The provided type is not indexable.Parameter name: " + type.getName());
                    }
                    valueWithType = ValueWithTypeProtocol.ValueWithType.newBuilder();
                    valueWithType.setValue(QueryCommandHelper.getValueString(value));
                    if (isTag) {
                        valueWithType.setType(String.class.getName());
                    } else {
                        valueWithType.setType(value.getClass().getName());
                    }
                    keyValue.addValue(valueWithType);
                }
            } else {
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("NCache query does not support null values. ", null);
                }
                Class<?> type = entry.getValue().getClass();
                boolean isTag = IndexHelper.isTag(type);
                if (!IndexHelper.isIndexable(type) && !isTag) {
                    throw new IllegalArgumentException("The provided type is not indexable.Parameter name: " + type.getName());
                }
                valueWithType = ValueWithTypeProtocol.ValueWithType.newBuilder();
                valueWithType.setValue(QueryCommandHelper.getValueString(entry.getValue()));
                if (isTag) {
                    valueWithType.setType(String.class.getName());
                } else {
                    valueWithType.setType(entry.getValue().getClass().getName());
                }
                keyValue.addValue(valueWithType);
            }
            keyValueList.add(keyValue.build());
        }
        return keyValueList;
    }

    private static String getValueString(Object value) {
        String valueString = "";
        if (value == null) {
            throw new RuntimeException("NCache query does not support null values");
        }
        if (value instanceof String) {
            valueString = value.toString();
            return valueString;
        }
        if (value instanceof Date) {
            valueString = Long.toString(new NCDateTime((Date)value).getTicks());
            return valueString;
        }
        return value.toString();
    }
}

