/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheEventDescriptor;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.internal.caching.Entry;
import com.alachisoft.ncache.jsr107.CacheEventListener;
import com.alachisoft.ncache.jsr107.NCacheConfiguration;
import com.alachisoft.ncache.jsr107.NCacheEntry;
import com.alachisoft.ncache.jsr107.NCacheManager;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.Duration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;

public class NCacheCache<K, V>
implements javax.cache.Cache<K, V> {
    private static final Object NOT_THERE = new Object();
    protected final NCacheManager cacheManager;
    protected final Cache ncache;
    private final NCacheConfiguration<K, V> cfg;
    private CacheLoader<K, V> cacheLoader = null;
    private CacheWriter cacheWriter = null;
    private boolean closed = false;
    private CacheEventDescriptor addEventDescriptor = null;
    private CacheEventDescriptor deleteEventDescriptor = null;
    private CacheEventDescriptor updateEventDescriptor = null;
    private boolean isExpireConfigure = false;

    public NCacheCache(NCacheManager cacheManager, NCacheConfiguration<K, V> cfg, Cache ncache) {
        if (ncache == null) {
            throw new NullPointerException();
        }
        this.cacheManager = cacheManager;
        this.cfg = cfg;
        this.ncache = ncache;
        Iterable<CacheEntryListenerConfiguration<K, V>> cacheEntryListenerConfigurations = cfg.getInitialCacheEntryListenerConfigurations();
        if (cacheEntryListenerConfigurations != null) {
            for (CacheEntryListenerConfiguration<K, V> listenerCfg : cacheEntryListenerConfigurations) {
                this.registerCacheEntryListener(listenerCfg);
            }
        }
    }

    public V get(K key) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key cannot be null");
        }
        Object value = null;
        String cacheKey = this.getNCacheKey(key);
        try {
            value = this.cfg.isReadThrough() ? this.ncache.get(cacheKey, new ReadThruOptions(ReadMode.None), null) : this.ncache.get(cacheKey, Object.class);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
        return this.getValue(value);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNCacheStatus();
        if (keys == null) {
            throw this.getNullPointerException("key");
        }
        ArrayList<String> cacheKeys = new ArrayList();
        cacheKeys = this.getCacheKeys(keys);
        Map result = null;
        try {
            result = this.cfg.isReadThrough() ? this.ncache.getBulk(cacheKeys, new ReadThruOptions(ReadMode.ReadThru), null) : this.ncache.getBulk(cacheKeys, null);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
        return result;
    }

    public boolean containsKey(K key) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        String cacheKey = this.getNCacheKey(key);
        try {
            return this.ncache.contains(cacheKey);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkNCacheStatus();
        if (keys == null) {
            throw this.getNullPointerException("keys");
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        this.cacheManager.getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (String key : NCacheCache.this.getCacheKeys(keys)) {
                    try {
                        Object value = null;
                        if (NCacheCache.this.ncache.contains(key)) {
                            if (replaceExistingValues) {
                                value = NCacheCache.this.ncache.get(key, new ReadThruOptions(ReadMode.ReadThru), null);
                            }
                        } else {
                            value = NCacheCache.this.ncache.get(key, new ReadThruOptions(ReadMode.ReadThru), null);
                        }
                        if (value == null || NCacheCache.this.getExpiratonType() != 3) continue;
                        NCacheCache.this.insert(key, value);
                    }
                    catch (Exception e) {
                        if (completionListener != null) {
                            completionListener.onException((Exception)new CacheLoaderException((Throwable)e));
                        }
                        return null;
                    }
                }
                if (completionListener != null) {
                    completionListener.onCompletion();
                }
                return null;
            }
        });
    }

    public void put(K key, V value) {
        this.put(key, value, null, null);
    }

    public void put(K key, V value, CacheDependency depdenency, CacheItemPriority priority) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (value == null) {
            throw this.getNullPointerException("Value");
        }
        String cacheKey = this.getNCacheKey(key);
        try {
            Expiration expiration;
            CacheItem cacheItem = new CacheItem(value);
            if (priority != null) {
                cacheItem.setCacheItemPriority(priority);
            }
            if (depdenency != null) {
                cacheItem.setDependency(depdenency);
            }
            if (this.getExpiratonType() == 1 || this.getExpiratonType() == 4) {
                expiration = new Expiration(ExpirationType.Sliding, this.getSlidingExpiration());
                cacheItem.setExpiration(expiration);
            }
            if (this.getExpiratonType() == 2) {
                expiration = new Expiration(ExpirationType.Absolute, this.getSlidingExpiration());
                cacheItem.setExpiration(expiration);
            }
            if (this.getExpiratonType() == 3) {
                this.insert(key, value);
                return;
            }
            WriteMode writeMode = this.cfg.writeThru ? WriteMode.WriteThru : WriteMode.None;
            this.ncache.insert(cacheKey, cacheItem, new WriteThruOptions(writeMode), null, false);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public V getAndPut(K key, V valueToPut) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (valueToPut == null) {
            throw this.getNullPointerException("value");
        }
        Object value = null;
        try {
            value = this.get(key);
            if (this.getExpiratonType() == 3) {
                this.insert(key, valueToPut);
            } else {
                this.put(key, valueToPut);
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
        return this.getValue(value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkNCacheStatus();
        if (map == null) {
            throw this.getNullPointerException("map");
        }
        String[] keys = new String[map.size()];
        CacheItem[] cacheItems = new CacheItem[map.size()];
        int index = -1;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Expiration expiration;
            if (entry.getValue() == null) {
                throw this.getNullPointerException("value");
            }
            if (entry.getKey() == null) {
                throw this.getNullPointerException("key");
            }
            keys[++index] = this.getNCacheKey(entry.getKey());
            cacheItems[index] = new CacheItem(entry.getValue());
            if (this.getExpiratonType() == 1 || this.getExpiratonType() == 4) {
                expiration = new Expiration(ExpirationType.Sliding, this.getSlidingExpiration());
                cacheItems[index].setExpiration(expiration);
            }
            if (this.getExpiratonType() == 2) {
                expiration = new Expiration(ExpirationType.Sliding, this.getSlidingExpiration());
                cacheItems[index].setExpiration(expiration);
            }
            if (this.getExpiratonType() != 3) continue;
            if (this.containsKey(entry.getKey())) {
                try {
                    expiration = new Expiration(ExpirationType.Sliding, this.getSlidingExpiration());
                    cacheItems[index].setExpiration(this.getAccessExpiryDuration(entry.getKey(), this.ncache.getCacheItem(keys[index])));
                }
                catch (Exception exception) {}
                continue;
            }
            cacheItems[index].setExpiration(new Expiration(ExpirationType.Sliding, this.getSlidingExpiration()));
        }
        try {
            HashMap<String, CacheItem> inputMap = new HashMap<String, CacheItem>();
            for (int i = 0; i < keys.length; ++i) {
                inputMap.put(keys[i], cacheItems[i]);
            }
            if (this.cfg.writeThru) {
                this.ncache.insertBulk(inputMap, new WriteThruOptions(WriteMode.WriteThru));
            } else {
                this.ncache.insertBulk(inputMap);
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public boolean putIfAbsent(K key, V value) {
        this.checkNCacheStatus();
        if (!this.containsKey(key)) {
            if (this.getExpiratonType() == 3 || this.getExpiratonType() == 4) {
                this.insert(key, value);
            } else {
                this.put(key, value);
            }
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        String cacheKey = this.getNCacheKey(key);
        try {
            Object obj = null;
            obj = this.cfg.writeThru ? this.ncache.remove(cacheKey, null, null, new WriteThruOptions(WriteMode.WriteThru), null) : this.ncache.remove(cacheKey, null, null);
            return obj != null;
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public boolean remove(K key, V value) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (value == null) {
            throw this.getNullPointerException("value");
        }
        V old = this.get(key);
        if (old != null) {
            if (this.containsKey(key) && old.equals(value)) {
                this.remove(key);
                return true;
            }
            if (this.getExpiratonType() == 4) {
                this.insert(key, this.get(key));
            }
        }
        return false;
    }

    public V getAndRemove(K key) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        String cacheKey = this.getNCacheKey(key);
        try {
            if (this.cfg.isWriteThrough()) {
                return this.getValue(this.ncache.remove(cacheKey, null, null, new WriteThruOptions(WriteMode.WriteThru), null));
            }
            return this.getValue(this.ncache.remove(cacheKey, null, null, null, null));
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (oldValue == null) {
            throw this.getNullPointerException("oldValue");
        }
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        V value = this.get(key);
        if (value != null && value.equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V value) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (value == null) {
            throw this.getNullPointerException("value");
        }
        if (this.containsKey(key)) {
            if (this.getExpiratonType() == 3) {
                this.insert(key, value);
            } else {
                this.put(key, value);
            }
            return true;
        }
        return false;
    }

    public V getAndReplace(K key, V value) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (value == null) {
            throw this.getNullPointerException("value");
        }
        V existingValue = this.get(key);
        if (existingValue != null) {
            if (this.getExpiratonType() == 3) {
                this.insert(key, value);
            } else {
                this.put(key, value);
            }
        }
        return existingValue;
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNCacheStatus();
        if (keys == null) {
            throw this.getNullPointerException("keys");
        }
        ArrayList<String> cacheKeys = new ArrayList<String>();
        int index = -1;
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException();
            }
            cacheKeys.add(this.getNCacheKey(key));
        }
        try {
            if (this.cfg.isWriteThrough()) {
                this.ncache.removeBulk(cacheKeys, new WriteThruOptions(WriteMode.WriteThru), null);
            } else {
                this.ncache.deleteBulk(cacheKeys);
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public void removeAll() {
        this.checkNCacheStatus();
        try {
            this.ncache.clear();
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public void clear() {
        this.checkNCacheStatus();
        try {
            this.ncache.clear();
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> type) {
        this.checkNCacheStatus();
        if (type.isAssignableFrom(this.cfg.getClass())) {
            return (C)((Configuration)type.cast(this.cfg));
        }
        return null;
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        Object finaloutcome;
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (entryProcessor == null) {
            throw this.getNullPointerException("EntryProcessor");
        }
        try {
            V value = this.get(key);
            boolean fromLoader = false;
            if (this.cfg.isReadThrough()) {
                value = this.get(key);
                fromLoader = true;
            }
            TayzGridMutableEntry<K, V> entry = new TayzGridMutableEntry<K, V>(this, value, key, fromLoader);
            finaloutcome = entryProcessor.process(entry, arguments);
            entry.apply(this);
        }
        catch (EntryProcessorException t) {
            if (t instanceof CacheException) {
                throw t;
            }
            throw new EntryProcessorException((Throwable)t);
        }
        return (T)finaloutcome;
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> set, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNCacheStatus();
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap<K, 2> results = new HashMap<K, 2>();
        for (K key : set) {
            final T result = this.invoke(key, entryProcessor, arguments);
            if (result == null) continue;
            results.put(key, new EntryProcessorResult<T>(){

                public T get() throws EntryProcessorException {
                    return result;
                }
            });
        }
        return results;
    }

    public String getName() {
        this.checkNCacheStatus();
        return this.ncache.toString();
    }

    public CacheManager getCacheManager() {
        this.checkNCacheStatus();
        return this.cacheManager;
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                this.cacheManager.destroyCache(this.ncache.toString());
                this.closed = true;
            }
            catch (Exception ex) {
                throw new CacheException(ex.getMessage());
            }
        }
    }

    void dispose() {
        this.checkNCacheStatus();
        this.cacheManager.destroyCache(this.getName());
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> type) {
        this.checkNCacheStatus();
        if (type.isAssignableFrom(this.ncache.getClass())) {
            return type.cast(this.ncache);
        }
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        return null;
    }

    public final void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkNCacheStatus();
        Factory factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        CacheEntryListener cacheEntryListener = (CacheEntryListener)factory.create();
        CacheEventListener<K, V> cacheEventListener = new CacheEventListener<K, V>(cacheEntryListener, this, cacheEntryListenerConfiguration);
        try {
            EnumSet<EventType> eventType = null;
            if (cacheEventListener.isAddedListenerConfigure()) {
                eventType = EnumSet.of(EventType.ItemAdded);
                this.addEventDescriptor = this.ncache.getMessagingService().addCacheNotificationListener(cacheEventListener, eventType, EventDataFilter.DataWithMetadata);
            }
            if (cacheEventListener.isUpdatedListenerConfigure()) {
                eventType = EnumSet.of(EventType.ItemUpdated);
                this.updateEventDescriptor = this.ncache.getMessagingService().addCacheNotificationListener(cacheEventListener, eventType, EventDataFilter.DataWithMetadata);
            }
            if (cacheEventListener.isRemovedListenerConfigure() || cacheEventListener.isExpiredListenerConfigure()) {
                if (cacheEventListener.isExpiredListenerConfigure()) {
                    this.isExpireConfigure = true;
                }
                eventType = EnumSet.of(EventType.ItemRemoved);
                this.deleteEventDescriptor = this.ncache.getMessagingService().addCacheNotificationListener(cacheEventListener, eventType, EventDataFilter.DataWithMetadata);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        try {
            this.checkNCacheStatus();
            Factory factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
            CacheEntryListener cacheEntryListener = (CacheEntryListener)factory.create();
            CacheEventListener<K, V> cacheEventListener = new CacheEventListener<K, V>(cacheEntryListener, this, cacheEntryListenerConfiguration);
            if (cacheEventListener.isAddedListenerConfigure() && this.addEventDescriptor != null) {
                this.ncache.getMessagingService().removeCacheNotificationListener(this.addEventDescriptor);
            }
            if (cacheEventListener.isUpdatedListenerConfigure() && this.updateEventDescriptor != null) {
                this.ncache.getMessagingService().removeCacheNotificationListener(this.updateEventDescriptor);
            }
            if (cacheEventListener.isRemovedListenerConfigure() && this.deleteEventDescriptor != null && !this.isExpireConfigure) {
                this.ncache.getMessagingService().removeCacheNotificationListener(this.deleteEventDescriptor);
            }
            if (cacheEventListener.isExpiredListenerConfigure() && this.deleteEventDescriptor != null) {
                this.isExpireConfigure = false;
            }
            this.ncache.getMessagingService().removeCacheNotificationListener(this.deleteEventDescriptor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNCacheStatus();
        try {
            return new NCacheEntryIterator(this);
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    void shutdown() {
        try {
            this.closed = true;
            this.ncache.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkNCacheStatus() {
        if (this.closed) {
            throw new IllegalStateException("The specified cache is close");
        }
    }

    private String getNCacheKey(K key) {
        return key.toString();
    }

    private V getValue(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (V)object;
        }
        catch (Exception ex) {
            throw new ClassCastException();
        }
    }

    private NullPointerException getNullPointerException(String argument) {
        return new NullPointerException("argument : " + argument + " pass in the function is null");
    }

    private ArrayList<String> getCacheKeys(Set<? extends K> keys) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        int index = -1;
        for (K key : keys) {
            if (key == null) {
                throw this.getNullPointerException("key");
            }
            cacheKeys.add(this.getNCacheKey(key));
        }
        return cacheKeys;
    }

    protected TimeSpan getSlidingExpiration() {
        Duration duration = this.cfg.getExpiryPolicy().getExpiryForCreation();
        int sec = (int)TimeUnit.SECONDS.convert(duration.getDurationAmount(), duration.getTimeUnit());
        return new TimeSpan(0, 0, sec);
    }

    protected Date getAbsoluteExpiration() {
        Duration duration = this.cfg.getExpiryPolicy().getExpiryForCreation();
        int sec = (int)TimeUnit.SECONDS.convert(duration.getDurationAmount(), duration.getTimeUnit());
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, sec);
        return calendar.getTime();
    }

    protected byte getExpiratonType() {
        if (this.cfg.getExpiryPolicy().getClass().toString().contains("TouchedExpiryPolicy")) {
            return 1;
        }
        if (this.cfg.getExpiryPolicy().getClass().toString().contains("CreatedExpiryPolicy")) {
            return 2;
        }
        if (this.cfg.getExpiryPolicy().getClass().toString().contains("AccessedExpiryPolicy")) {
            return 3;
        }
        if (this.cfg.getExpiryPolicy().getClass().toString().contains("ModifiedExpiryPolicy")) {
            return 4;
        }
        return 0;
    }

    private void insert(K key, V value) {
        this.checkNCacheStatus();
        if (key == null) {
            throw this.getNullPointerException("key");
        }
        if (value == null) {
            throw this.getNullPointerException("Value");
        }
        String cacheKey = this.getNCacheKey(key);
        try {
            CacheItem item = this.ncache.getCacheItem(cacheKey);
            if (item != null) {
                Date now = new Date();
                TimeSpan timeSpan = new TimeSpan(Math.abs(item.getLastModifiedTime().getHours() - now.getHours()), Math.abs(item.getLastModifiedTime().getMinutes() - now.getMinutes()), Math.abs(item.getLastModifiedTime().getSeconds() - now.getSeconds()));
                CacheItem cacheItem = new CacheItem(value);
                TimeSpan duration = this.getSlidingExpiration();
                int interval = (int)((long)((int)timeSpan.getTotalMiliSeconds()) - duration.getTotalMiliSeconds() < 0L ? -(timeSpan.getTotalMiliSeconds() - duration.getTotalMiliSeconds()) : timeSpan.getTotalMiliSeconds() - duration.getTotalMiliSeconds());
                TimeSpan time = new TimeSpan((long)interval);
                cacheItem.setExpiration(new Expiration(ExpirationType.Sliding, time));
                WriteMode mode = this.cfg.writeThru ? WriteMode.WriteThru : WriteMode.None;
                System.out.println("Key  = " + cacheItem.getExpiration().toString());
                this.ncache.insert(cacheKey, cacheItem, new WriteThruOptions(mode), null, false);
            } else {
                CacheItem cacheItem = new CacheItem(value);
                cacheItem.setExpiration(new Expiration(ExpirationType.Sliding, this.getSlidingExpiration()));
                WriteMode dsOption = this.cfg.writeThru ? WriteMode.WriteThru : WriteMode.None;
                this.ncache.insert(cacheKey, cacheItem, new WriteThruOptions(dsOption), null, false);
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex.getMessage());
        }
    }

    private Expiration getAccessExpiryDuration(K key, CacheItem item) {
        String cacheKey = this.getNCacheKey(key);
        TimeSpan time = this.getSlidingExpiration();
        if (item != null) {
            Date now = new Date();
            TimeSpan timeSpan = new TimeSpan(Math.abs(item.getLastModifiedTime().getHours() - now.getHours()), Math.abs(item.getLastModifiedTime().getMinutes() - now.getMinutes()), Math.abs(item.getLastModifiedTime().getSeconds() - now.getSeconds()));
            TimeSpan duration = this.getSlidingExpiration();
            int interval = (int)((long)((int)timeSpan.getTotalMiliSeconds()) - duration.getTotalMiliSeconds() < 0L ? -(timeSpan.getTotalMiliSeconds() - duration.getTotalMiliSeconds()) : timeSpan.getTotalMiliSeconds() - duration.getTotalMiliSeconds());
            time = new TimeSpan((long)interval);
        }
        return new Expiration(ExpirationType.Sliding, time);
    }

    public void setClose() {
        this.closed = false;
    }

    private static class TayzGridMutableEntry<K, V>
    implements MutableEntry<K, V> {
        private final NCacheCache<K, V> jCache;
        private final K key;
        private final boolean fromLoader;
        private final V initialValue;
        private volatile V newValue;
        private volatile boolean deleted;
        private volatile boolean skipDelete;

        public TayzGridMutableEntry(NCacheCache<K, V> jCache, V element, K key, boolean fromLoader) {
            this.jCache = jCache;
            this.key = key;
            this.fromLoader = fromLoader;
            this.initialValue = element != null ? element : null;
            this.newValue = this.initialValue;
        }

        public boolean exists() {
            return !this.deleted && this.newValue != null;
        }

        public void remove() {
            this.skipDelete = this.initialValue == null && this.newValue != null;
            this.newValue = null;
            this.deleted = true;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            Duration expiryForAccess;
            if (this.newValue != this.initialValue) {
                return this.newValue;
            }
            if (this.initialValue != null && !this.fromLoader && (expiryForAccess = ((NCacheCache)this.jCache).cfg.getExpiryPolicy().getExpiryForAccess()) != null && expiryForAccess.isZero()) {
                this.remove();
            }
            return this.initialValue;
        }

        public void setValue(V value) {
            if (value == null) {
                throw new EntryProcessorException();
            }
            this.deleted = false;
            this.newValue = value;
        }

        public <T> T unwrap(Class<T> type) {
            if (type.isAssignableFrom(this.getClass())) {
                return type.cast(this);
            }
            if (type.isAssignableFrom(Object.class)) {
                return type.cast(this);
            }
            return null;
        }

        void apply(NCacheCache<K, V> jCache) {
            if (this.deleted && !this.skipDelete) {
                jCache.remove(this.key);
            }
            if (this.newValue != this.initialValue && this.newValue != null) {
                jCache.put(this.key, this.newValue);
            }
        }
    }

    private static class NCacheEntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private NCacheCache<K, V> jcache;
        private Cache.Entry<K, V> current;
        private Enumeration enumerator;

        public NCacheEntryIterator(NCacheCache jcache) {
            this.jcache = jcache;
            this.current = null;
            this.enumerator = jcache.ncache;
        }

        @Override
        public boolean hasNext() {
            return this.enumerator.hasMoreElements();
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.enumerator.hasMoreElements()) {
                try {
                    this.current = null;
                    Entry map = (Entry)this.enumerator.nextElement();
                    if (this.jcache.getExpiratonType() == 3) {
                        ((NCacheCache)this.jcache).insert(map.getKey(), map.getValue());
                    }
                    if (map.getValue() != null) {
                        this.current = new NCacheEntry(new CacheItem(map.getValue()), map.getKey(), ((NCacheCache)this.jcache).cfg.getKeyType(), ((NCacheCache)this.jcache).cfg.getValueType());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.current;
        }

        @Override
        public void remove() {
        }
    }
}

