/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107;

import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.jsr107.CacheEventListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

public class NCacheConfiguration<K, V>
implements CompleteConfiguration {
    private final Set<CacheEntryListenerConfiguration<K, V>> initialCacheEntryListenerConfigurations;
    private final ConcurrentMap<CacheEntryListenerConfiguration<K, V>, CacheEventListener<K, V>> cacheEntryListenerConfigurations = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, CacheEventListener<K, V>>();
    private final ExpiryPolicy expiryPolicy;
    private final Class keyType;
    private final Class valueType;
    private final Factory<ExpiryPolicy> expiryPolicyFactory;
    boolean readThru;
    boolean writeThru;
    boolean statisticsEnabled;
    boolean managementEnabled;
    boolean storeByValue;
    ClientConfiguration clientConfiguration;
    private Factory<CacheLoader<K, V>> cacheLoaderFactory;
    private Factory<CacheWriter<K, V>> cacheWriterFactory;

    public NCacheConfiguration(String cacheName, Configuration configuration, Class keyType, Class valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration cConfiguration = (CompleteConfiguration)configuration;
            this.expiryPolicyFactory = cConfiguration.getExpiryPolicyFactory();
            this.expiryPolicy = (ExpiryPolicy)this.expiryPolicyFactory.create();
            try {
                this.readThru = cConfiguration.isReadThrough();
                this.writeThru = cConfiguration.isWriteThrough();
                this.storeByValue = cConfiguration.isStoreByValue();
                this.cacheLoaderFactory = cConfiguration.getCacheLoaderFactory();
            }
            catch (Exception ex) {
                throw new CacheException((Throwable)ex);
            }
            HashSet<CacheEntryListenerConfiguration> set = new HashSet<CacheEntryListenerConfiguration>();
            for (CacheEntryListenerConfiguration kvCacheEntryListenerConfiguration : cConfiguration.getCacheEntryListenerConfigurations()) {
                set.add(kvCacheEntryListenerConfiguration);
            }
            this.initialCacheEntryListenerConfigurations = Collections.unmodifiableSet(set);
        } else {
            this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
            this.expiryPolicy = (ExpiryPolicy)this.expiryPolicyFactory.create();
            this.storeByValue = true;
            this.readThru = false;
            this.writeThru = false;
            this.initialCacheEntryListenerConfigurations = new HashSet<CacheEntryListenerConfiguration<K, V>>();
        }
    }

    public NCacheConfiguration(Configuration<K, V> configuration) {
        this(null, configuration, configuration.getKeyType(), configuration.getValueType());
    }

    public boolean isReadThrough() {
        return this.readThru;
    }

    public boolean isWriteThrough() {
        return this.writeThru;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    void setManagementEnabled(boolean managementEnabled) {
        this.managementEnabled = managementEnabled;
    }

    public Iterable getCacheEntryListenerConfigurations() {
        return this.cacheEntryListenerConfigurations.keySet();
    }

    public Factory getCacheLoaderFactory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Factory getCacheWriterFactory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Factory getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    public Class getKeyType() {
        return this.keyType;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getInitialCacheEntryListenerConfigurations() {
        return this.initialCacheEntryListenerConfigurations;
    }

    public boolean addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, CacheEventListener<K, V> cacheEventListener) {
        return this.cacheEntryListenerConfigurations.putIfAbsent(cacheEntryListenerConfiguration, cacheEventListener) == null;
    }

    public CacheEventListener<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        return (CacheEventListener)this.cacheEntryListenerConfigurations.remove(cacheEntryListenerConfiguration);
    }
}

