/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Parser;

import Alachisoft.NCache.Parser.FAEdge;
import java.util.ArrayList;

public class FAState {
    private ArrayList m_edges = new ArrayList();
    private int m_acceptSymbol = -1;

    public final ArrayList getEdges() {
        return this.m_edges;
    }

    public final int getAcceptSymbol() {
        return this.m_acceptSymbol;
    }

    public final void setAcceptSymbol(int value) {
        this.m_acceptSymbol = value;
    }

    public final int getEdgeCount() {
        return this.m_edges.size();
    }

    public final FAEdge GetEdge(int p_index) {
        if (p_index >= 0 && p_index < this.m_edges.size()) {
            return (FAEdge)this.m_edges.get(p_index);
        }
        return null;
    }

    public final void AddEdge(String p_characters, int p_targetIndex) {
        if (p_characters.equals("")) {
            FAEdge edge = new FAEdge(p_characters, p_targetIndex);
            this.m_edges.add(edge);
        } else {
            int index = -1;
            int edgeCount = this.m_edges.size();
            for (int n = 0; n < edgeCount && index == -1; ++n) {
                FAEdge edge = (FAEdge)this.m_edges.get(n);
                if (edge.getTargetIndex() != p_targetIndex) continue;
                index = n;
            }
            if (index == -1) {
                FAEdge edge = new FAEdge(p_characters, p_targetIndex);
                this.m_edges.add(edge);
            } else {
                FAEdge edge = (FAEdge)this.m_edges.get(index);
                edge.AddCharacters(p_characters);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("DFA state:\n");
        for (Object edgeObj : this.m_edges) {
            FAEdge edge = (FAEdge)edgeObj;
            result.append("- ").append(edge).append("\n");
        }
        if (this.m_acceptSymbol != -1) {
            result.append("- accept symbol: ").append(this.m_acceptSymbol).append("\n");
        }
        return result.toString();
    }
}

