/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.CacheLoader;

import Alachisoft.NCache.Caching.CacheLoader.JarFileLoader;
import Alachisoft.NCache.Caching.DatasourceProviders.ClassPaths;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.CacheLoader.LoaderConfig;
import Alachisoft.NCache.Common.Enum.LoaderStatus;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.cacheloader.CacheLoader;
import com.alachisoft.ncache.runtime.cacheloader.RefreshPreference;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class CacheStartupLoader
implements AutoCloseable,
Runnable {
    private CacheLoader _cacheLoader;
    private String _cacheId;
    private String _distributionHint;
    private int _retryInterval;
    private ILogger _loaderSvcLog;
    private boolean _enabled;
    private boolean _isTaskCompleted;
    private boolean _isSecurityException = false;
    private boolean _isloaderTaskIntruppted = false;
    private boolean _toLoad = false;
    private Thread _thread;
    private final Object _mutex = new Object();
    private LoaderStatus _loaderStatus;
    private Object _userContext;
    private boolean _executeCacheLoader;
    private int _noOfRetries;
    private LoaderConfig _config;
    private static final String DefaultDistributionHint = "default dataset";
    private static final String EventBasedDistributionHint = "EventBasedDistributionDataset";
    private String _userName;
    private String _password;
    private JarFileLoader _loader;

    public LoaderStatus getLoaderStatus() {
        return this._loaderStatus;
    }

    public boolean getIsCacheLoaderTaskCompleted() {
        return this._isTaskCompleted;
    }

    public void setIsCacheLoaderTaskCompleted(boolean value) {
        this._isTaskCompleted = value;
    }

    public boolean getIsCacheLoaderTaskIntruppted() {
        return this._isloaderTaskIntruppted;
    }

    public void setIsCacheLoaderTaskIntruppted(boolean value) {
        this._isloaderTaskIntruppted = value;
    }

    public boolean getIsCacheloaderEnabled() {
        return this._enabled;
    }

    public boolean getExecuteCacheLoader() {
        return this._executeCacheLoader;
    }

    public void setExecuteCacheLoader(boolean value) {
        this._executeCacheLoader = value;
    }

    public int getNoOfRetries() {
        return this._noOfRetries;
    }

    public void setNoOfRetries(int value) {
        this._noOfRetries = value;
    }

    public int getRetryInterval() {
        return this._retryInterval * 1000;
    }

    public void setRetryInterval(int value) {
        this._retryInterval = value;
    }

    public Object getUserContext() throws IOException {
        return this.Safeserialize(this._userContext);
    }

    public void setUserContext(Object value) throws IOException, ClassNotFoundException {
        this._userContext = this.SafeDeserialize(value);
    }

    public LoaderConfig getConfig() {
        return this._config;
    }

    public void setConfig(LoaderConfig value) {
        this._config = value;
    }

    public String getDistributionHint() {
        return this._distributionHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this._mutex;
        synchronized (object) {
            this._thread = new Thread(this::run);
            this._thread.setName("Cachestartuploader [ " + this._cacheId + " ] ");
            this._thread.setDaemon(true);
            this._thread.run();
        }
    }

    public void stop() {
        this.close();
    }

    public CacheStartupLoader(LoaderConfig config, String cacheId, String loggerLevel) throws ConfigurationException, IOException, ClassNotFoundException {
        this._cacheId = cacheId;
        if (config != null) {
            this._noOfRetries = config.getRetries();
            this._retryInterval = config.getRetryInterval();
            this._enabled = config.getEnabled();
            this._userContext = this.SafeDeserialize(config.getUserContext());
        }
        JLogger jLogger = new JLogger();
        try {
            jLogger.Initialize(LoggerNames.LoaderService);
            jLogger.SetLevel(loggerLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._loaderSvcLog = jLogger;
        this._config = config;
        this.initialize(config);
    }

    private void initialize(LoaderConfig config) throws ConfigurationException {
        block22: {
            if (config == null) {
                throw new IllegalArgumentException("properties");
            }
            try {
                if (config.getAssembly() == null || config.getAssembly().isEmpty()) {
                    throw new ConfigurationException("Missing jar name");
                }
                if (config.getClassName() == null || config.getClassName().isEmpty()) {
                    throw new ConfigurationException("Missing class name");
                }
                String classname = config.getClassName();
                String assemblyFullName = config.getFullName();
                Map startupparams = config.getStartupParams() != null ? config.getStartupParams() : new HashMap();
                this._toLoad = config.getToLoad();
                if (!(config.getTag() == null || config.getTag().isEmpty() || config.getTag().equals(DefaultDistributionHint) || config.getTag().equals(EventBasedDistributionHint))) {
                    this._distributionHint = config.getTag();
                }
                if (config.getUserName() != null && !config.getUserName().isEmpty() && config.getPassword() != null && !config.getPassword().isEmpty()) {
                    this._userName = config.getUserName();
                    this._password = config.getPassword();
                }
                try {
                    if (!assemblyFullName.endsWith(".jar") && !assemblyFullName.endsWith(".class")) break block22;
                    String path = RegUtil.getNCHome() + AppUtil.DeployedAssemblyDir + this._cacheId;
                    try {
                        if (this._loader == null) {
                            this._loader = ClassPaths.addPath((File)new File(path));
                        }
                    }
                    catch (Exception e) {
                        String message = String.format("Could not load jar \"" + path + "\". %1$s", e.getMessage());
                        throw new Exception(message);
                    }
                    if (this._loader != null) {
                        this._cacheLoader = (CacheLoader)this._loader.loadClass(classname).newInstance();
                    }
                    if (this._cacheLoader == null) {
                        throw new Exception("Unable to instantiate " + classname);
                    }
                    for (int retryCount = 0; retryCount <= this._noOfRetries; ++retryCount) {
                        try {
                            this._cacheLoader.init(startupparams, this._cacheId);
                            break;
                        }
                        catch (Exception ex) {
                            Thread.sleep(this._retryInterval);
                            if (retryCount != this._noOfRetries) continue;
                            if (this._loaderSvcLog != null && this._loaderSvcLog.getIsErrorEnabled()) {
                                if (this._distributionHint.equals(EventBasedDistributionHint)) {
                                    this._loaderSvcLog.Error("GetRefreshedDatasets: for cache name " + this._cacheId + "CacheStartupLoader.Initialize()", CacheStartupLoader.getStackTrace(ex));
                                } else {
                                    this._loaderSvcLog.Error("dataset:" + this._distributionHint + " for cache name " + this._cacheId + "CacheStartupLoader.Initialize()", CacheStartupLoader.getStackTrace(ex));
                                }
                            }
                            throw ex;
                        }
                    }
                }
                catch (ClassCastException e) {
                    throw new ConfigurationException("The class specified does not implement ICacheLoader");
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            catch (ConfigurationException e2) {
                throw e2;
            }
            catch (Exception e) {
                throw new ConfigurationException("Configuration Error: " + e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCache() {
        try {
            int retryCount = 0;
            boolean userReturn = false;
            while (retryCount <= this._noOfRetries) {
                String message;
                if (this._toLoad) {
                    if (this._cacheLoader == null) continue;
                    try {
                        this._userContext = this._cacheLoader.loadDatasetOnStartup(this._distributionHint);
                        break;
                    }
                    catch (InterruptedException ex) {
                        message = "Cache startup loader forcefully stopped for cache name [" + this._cacheId + "] with distribution dataset: " + this._distributionHint;
                        if (this._loaderSvcLog != null && this._loaderSvcLog.getIsErrorEnabled()) {
                            this._loaderSvcLog.Error("CacheStartupLoader.loadCache()", CacheStartupLoader.getStackTrace(ex));
                            continue;
                        }
                        this._isTaskCompleted = true;
                        break;
                    }
                    catch (Exception ex) {
                        Thread.sleep(this._retryInterval);
                        if (retryCount == this._noOfRetries) {
                            if (this._loaderSvcLog != null && this._loaderSvcLog.getIsErrorEnabled()) {
                                this._loaderSvcLog.Error("CacheStartupLoader.loadCache()", "ICacheLoader.loadDatasetOnStartup() Error: " + CacheStartupLoader.getStackTrace(ex));
                            }
                            this._isTaskCompleted = true;
                            break;
                        }
                        ++retryCount;
                        continue;
                    }
                }
                try {
                    this._userContext = this._cacheLoader.refreshDataset(this._distributionHint, this._userContext);
                    break;
                }
                catch (InterruptedException ex) {
                    message = "Cache refresher forcefully stopped for cache name [" + this._cacheId + "] with distribution dataset: " + this._distributionHint;
                    if (this._loaderSvcLog != null && this._loaderSvcLog.getIsErrorEnabled()) {
                        this._loaderSvcLog.Error("CacheStartupLoader.loadCache()", CacheStartupLoader.getStackTrace(ex));
                        continue;
                    }
                    this._isTaskCompleted = true;
                    break;
                }
                catch (Exception ex) {
                    Thread.sleep(this._retryInterval);
                    if (retryCount == this._noOfRetries) {
                        if (this._loaderSvcLog != null && this._loaderSvcLog.getIsErrorEnabled()) {
                            this._loaderSvcLog.Error("CacheStartupLoader.loadCache()", "ICacheLoader.refreshDataset() Error: " + CacheStartupLoader.getStackTrace(ex));
                        }
                        this._isTaskCompleted = true;
                        break;
                    }
                    ++retryCount;
                }
            }
            this._isTaskCompleted = true;
            this._loaderStatus = LoaderStatus.Completed;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void close() {
        block10: {
            try {
                if (this._cacheLoader != null) {
                    int retryCount = 0;
                    while (retryCount <= this._noOfRetries) {
                        try {
                            this._cacheLoader.close();
                        }
                        catch (InterruptedException e2) {
                            Thread.sleep(this._retryInterval);
                            if (++retryCount != this._noOfRetries) continue;
                        }
                        catch (Exception ex) {
                            Thread.sleep(this._retryInterval);
                            if (++retryCount != this._noOfRetries) continue;
                            if (this._loaderSvcLog == null || !this._loaderSvcLog.getIsErrorEnabled()) break;
                            this._loaderSvcLog.Error("ICacheLoader.Stop() Error: " + CacheStartupLoader.getStackTrace(ex));
                        }
                        break;
                    }
                    this._cacheLoader = null;
                }
                if (this._thread != null && this._thread.isAlive()) {
                    this._thread.interrupt();
                }
                if (this._loaderSvcLog != null) {
                    this._loaderSvcLog.CriticalInfo("LoaderServer.StopLoader()", "Cache startup loader stopped for cache name [" + this._cacheId + "] with distribution dataset: " + this._config.getTag());
                    this._loaderSvcLog.close();
                }
            }
            catch (InterruptedException retryCount) {
            }
            catch (Exception ex) {
                if (this._loaderSvcLog == null || !this._loaderSvcLog.getIsErrorEnabled()) break block10;
                this._loaderSvcLog.Error("CacheLoader.Stop():", CacheStartupLoader.getStackTrace(ex));
            }
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.loadCache();
            }
            catch (Exception e) {
                if (this._loaderSvcLog == null || !this._loaderSvcLog.getIsErrorEnabled()) break block2;
                this._loaderSvcLog.Error("CacheLoader.run():", "Error while laoding " + this._cacheId + " " + CacheStartupLoader.getStackTrace(e));
            }
        }
    }

    public Map<String, RefreshPreference> getRefreshedDatasets() {
        Map newDistributionHints;
        block5: {
            newDistributionHints = null;
            HashMap<String, Object> datasetsWithContexts = new HashMap<String, Object>();
            try {
                if (this._cacheLoader != null) {
                    if (this._config != null && this._config.getTagsList() != null) {
                        for (Map.Entry item : this._config.getTagsList().entrySet()) {
                            datasetsWithContexts.put((String)item.getKey(), this.SafeDeserialize(item.getValue()));
                        }
                    }
                    newDistributionHints = this._cacheLoader.getDatasetsToRefresh(datasetsWithContexts);
                }
            }
            catch (Exception ex) {
                if (this._loaderSvcLog == null || !this._loaderSvcLog.getIsErrorEnabled()) break block5;
                this._loaderSvcLog.Error("CacheStartupLoader.loadCache()", "ICacheLoader.getRefreshedDatasets() Error: " + ex.getMessage());
            }
        }
        return newDistributionHints;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getStackTrace(Throwable throwable) {
        try {
            Throwable throwable2 = null;
            try (StringWriter sw = new StringWriter();){
                String string;
                PrintWriter pw = new PrintWriter(sw);
                Throwable throwable3 = null;
                try {
                    throwable.printStackTrace(pw);
                    string = sw.toString();
                }
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            CacheStartupLoader.$closeResource(throwable3, pw);
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                }
                CacheStartupLoader.$closeResource(throwable3, pw);
                return string;
            }
        }
        catch (IOException ioe) {
            return throwable.getMessage();
        }
    }

    private Object Safeserialize(Object serializableObject) throws IOException {
        if (serializableObject != null) {
            serializableObject = CompactBinaryFormatter.toByteBuffer((Object)serializableObject, (String)this._cacheId);
        }
        return serializableObject;
    }

    private Object SafeDeserialize(Object serializableObject) throws IOException, ClassNotFoundException {
        if (serializableObject != null) {
            byte[] object = (byte[])serializableObject;
            serializableObject = CompactBinaryFormatter.fromByteBuffer((byte[])object, (String)this._cacheId);
        }
        return serializableObject;
    }
}

