/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.CallbackTasks;

import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.SocketServer.CallbackTasks.ICallbackTask;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.Util.EventHelper;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.BulkEventItemResponseProtocol;
import com.alachisoft.ncache.common.protobuf.BulkEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import java.util.HashMap;

public class DataSourceUpdatedCallbackTask
implements ICallbackTask {
    private short _id;
    private Object _result;
    private OpCode _opCode = OpCode.values()[0];
    private String _clientId;

    public DataSourceUpdatedCallbackTask(short id, Object result, OpCode opCode, String clientId) {
        this._id = id;
        this._result = result;
        this._opCode = opCode;
        this._clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void Process() {
        StringBuilder keyPackage = new StringBuilder();
        keyPackage.append(String.format("DSUPDATECALLBACK \"%1$s\"%2$s\"%3$s\"", this._id, this._opCode.getValue(), ((HashMap)this._result).size()));
        ClientManager clientManager = null;
        HashMap hashMap = ConnectionManager.ConnectionTable;
        synchronized (hashMap) {
            clientManager = (ClientManager)ConnectionManager.ConnectionTable.get(this._clientId);
        }
        if (clientManager != null) {
            ResponseProtocol.Response.Builder response = ResponseProtocol.Response.newBuilder();
            BulkEventItemResponseProtocol.BulkEventItemResponse.Builder eventItems = BulkEventItemResponseProtocol.BulkEventItemResponse.newBuilder();
            eventItems.setEventType(BulkEventItemResponseProtocol.BulkEventItemResponse.EventType.DS_UPDATED_CALLBACK);
            eventItems.setDSUpdatedCallback(EventHelper.GetDSUPdateCallbackResponse(this._id, this._opCode, this._result));
            BulkEventResponseProtocol.BulkEventResponse.Builder eventResponse = BulkEventResponseProtocol.BulkEventResponse.newBuilder();
            eventResponse.addEventList(eventItems);
            response.setBulkEventResponse(eventResponse);
            response.setResponseType(ResponseProtocol.Response.Type.BULK_EVENT);
            byte[] serializedResponse = ResponseHelper.SerializeResponse((ResponseProtocol.Response)response.build());
            ConnectionManager.AssureSend(clientManager, serializedResponse);
        }
    }
}

