/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetCommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.protobuf.ByteString;
import java.util.Date;
import java.util.List;
import tangible.RefObject;

public class GetCommand
extends CommandBase {
    private OperationResult _getResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._getResult;
    }

    @Override
    public boolean getCanHaveLargedata() {
        return true;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"GetCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("GetCommand", "command: " + command + " Error" + arEx);
            }
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            Object lockId = cmdInfo.LockId;
            long version = cmdInfo.CacheItemVersion;
            NCDateTime time = new NCDateTime(1970, 1, 1, 0, 0, 0, 0);
            Date lockDate = time.getDate();
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            CompressedValueEntry flagValueEntry = null;
            RefObject tempRef_version = new RefObject((Object)version);
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            flagValueEntry = nCache.getCache().GetGroup((Object)cmdInfo.Key, cmdInfo.FlagMap, cmdInfo.Group, cmdInfo.SubGroup, tempRef_version, tempRef_lockId, tempRef_lockDate, cmdInfo.LockTimeout, cmdInfo.LockAccessTypes, new ReadThruOptions(cmdInfo.ReadMode, cmdInfo.ProviderName), cmdInfo.ProviderName, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            version = (Long)tempRef_version.argvalue;
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            UserBinaryObject ubObj = flagValueEntry == null ? null : (UserBinaryObject)flagValueEntry.value;
            ResponseProtocol.Response.Builder resBuilder = ResponseProtocol.Response.newBuilder();
            GetResponseProtocol.GetResponse.Builder getResponse = GetResponseProtocol.GetResponse.newBuilder();
            resBuilder.setRequestId(command.getRequestID());
            resBuilder.setResponseType(ResponseProtocol.Response.Type.GET);
            if (lockId != null) {
                getResponse.setLockId(lockId.toString());
            }
            getResponse.setLockTime(new NCDateTime(lockDate).getTicks());
            getResponse.setVersion(version);
            if (ubObj == null) {
                resBuilder.setGet(getResponse.build());
                this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)resBuilder.build()));
            } else {
                getResponse.setFlag((int)flagValueEntry.flag.getData());
                List list = ubObj.getDataList();
                for (int i = 0; i < list.size(); ++i) {
                    getResponse.addData(ByteString.copyFrom((byte[])((byte[])ubObj.getDataList().get(i))));
                }
                resBuilder.setGet(getResponse.build());
                this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)resBuilder.build()));
            }
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"GetCmd.Exec", (String)"cmd executed on cache");
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        GetCommandProtocol.GetCommand getCommand = command.getGetCommand();
        cmdInfo.CacheItemVersion = getCommand.getVersion();
        cmdInfo.FlagMap = new BitSet((byte)getCommand.getFlag());
        cmdInfo.Group = getCommand.getGroup().length() == 0 ? null : getCommand.getGroup();
        cmdInfo.Key = getCommand.getKey();
        cmdInfo.LockAccessTypes = LockAccessType.forValue((int)getCommand.getLockInfo().getLockAccessType());
        cmdInfo.LockId = getCommand.getLockInfo().getLockId();
        cmdInfo.LockTimeout = new TimeSpan(getCommand.getLockInfo().getLockTimeout());
        cmdInfo.ProviderName = getCommand.getProviderName().length() == 0 ? null : getCommand.getProviderName();
        cmdInfo.ReadMode = ReadMode.forValue((int)getCommand.getReadMode());
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.SubGroup = getCommand.getSubGroup().length() == 0 ? null : getCommand.getSubGroup();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Key;
        public String Group;
        public String SubGroup;
        public BitSet FlagMap;
        public LockAccessType LockAccessTypes = LockAccessType.values()[0];
        public Object LockId;
        public TimeSpan LockTimeout = new TimeSpan();
        public long CacheItemVersion;
        public String ProviderName;
        public ReadMode ReadMode;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.Group = this.Group;
            varCopy.SubGroup = this.SubGroup;
            varCopy.FlagMap = this.FlagMap;
            varCopy.LockAccessTypes = this.LockAccessTypes;
            varCopy.LockId = this.LockId;
            varCopy.LockTimeout = this.LockTimeout;
            varCopy.CacheItemVersion = this.CacheItemVersion;
            varCopy.ProviderName = this.ProviderName;
            return varCopy;
        }
    }
}

