/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency;
import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.BridgeActivityMonitor;
import Alachisoft.NCache.Common.Logger.BridgeOperationMonitor;
import Alachisoft.NCache.Common.Util.DebugAnalysis;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.HybridBulkCommandProtocol;
import com.alachisoft.ncache.common.protobuf.HybridBulkResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.serialization.standard.io.ObjectInputStream;
import com.alachisoft.ncache.serialization.standard.io.ObjectOutputStream;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

public class HybridBulkCommand
extends CommandBase {
    static BridgeOperationMonitor s_monitor = new BridgeOperationMonitor();
    private OperationResult _getResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._getResult;
    }

    @Override
    public boolean getCanHaveLargedata() {
        return false;
    }

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        byte[] data = null;
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("HybridBulk", "command: " + command + " Error" + arEx);
            }
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (RuntimeException exc) {
            this._getResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            data = CompressionUtil.Decompress((byte[])cmdInfo.buffer, (BitSet)cmdInfo.Flag);
            HashMap<BridgeOperation, Exception> failedOperations = new HashMap<BridgeOperation, Exception>();
            ByteArrayInputStream val = new ByteArrayInputStream(data);
            ObjectInputStream ow = new ObjectInputStream((InputStream)val, "");
            Object tempVar2 = ow.readObject();
            BridgeOperation[] operations = (BridgeOperation[])(tempVar2 instanceof BridgeOperation[] ? tempVar2 : null);
            if (operations != null) {
                String group = null;
                String subgroup = null;
                BridgeOperation operation = null;
                if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                    SocketServer.getLogger().getNCacheLog().CriticalInfo("Bridge.HybridBulkCommand", "Operations Send From Bridge: " + operations.length);
                }
                if (DebugAnalysis.getEnableDetailLogging() && HybridBulkCommand.s_monitor._logger == null) {
                    HybridBulkCommand.s_monitor._logger = nCache.getCache().getNCacheLog();
                }
                for (int i = 0; i < operations.length; ++i) {
                    try {
                        operation = operations[i];
                        if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                            SocketServer.getLogger().getNCacheLog().CriticalInfo("Bridge.HybridBulkCommand", "Operations Send From Bridge Value: " + operation.getKey() + ":" + operation.getOpCode());
                        }
                        if (operation == null) continue;
                        if (DebugAnalysis.getEnableDetailLogging()) {
                            BridgeActivityMonitor.getBridgeMonitor((String)(nCache.getCache().getName() + clientManager.getUniqueCacheID() + " OnTarget")).NodeActivity((String)operation.getKey(), operation);
                        }
                        if (DebugAnalysis.getEnableDetailLogging()) {
                            s_monitor.IncrementBridgeOperation(operation.getOpCode());
                        }
                        switch (operation.getOpCode()) {
                            case Add: 
                            case Update: {
                                Object key = operation.getKey();
                                Object tempVar4 = operation.getData();
                                CacheEntry entry = (CacheEntry)(tempVar4 instanceof CacheEntry ? tempVar4 : null);
                                group = entry.getGroupInfo() != null ? entry.getGroupInfo().getGroup() : null;
                                subgroup = entry.getGroupInfo() != null ? entry.getGroupInfo().getSubGroup() : null;
                                nCache.getCache().Insert(key, entry.getValue(), entry.getExpirationHint(), entry.getSyncDependency(), entry.getEvictionHint(), group, subgroup, entry.getQueryInfo(), entry.getFlag(), entry.getVersion(), new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.BridgeOperation), entry.getBridgeOpTimeStamp());
                                break;
                            }
                            case Remove: {
                                Object key = operation.getKey();
                                BitSet flags = new BitSet();
                                if (operation.getDoWriteBehind()) {
                                    flags.SetBit((byte)2);
                                }
                                nCache.getCache().Remove((String)key, flags, null, null, 0L, LockAccessType.IGNORE_LOCK, null, this.PopulateOperationContext(operation));
                                break;
                            }
                            case Clear: {
                                nCache.getCache().Clear(this.PopulateOperationContext(operation));
                                break;
                            }
                            case AddHint: {
                                Object key = operation.getKey();
                                Object tempVar5 = operation.getData();
                                ExpirationHint hint = (ExpirationHint)(tempVar5 instanceof ExpirationHint ? tempVar5 : null);
                                nCache.getCache().AddExpirationHint(key, hint, this.PopulateOperationContext(operation));
                                break;
                            }
                            case AddSyncDependency: {
                                Object key = operation.getKey();
                                Object tempVar6 = operation.getData();
                                CacheSyncDependency dependency = (CacheSyncDependency)(tempVar6 instanceof CacheSyncDependency ? tempVar6 : null);
                                nCache.getCache().AddSyncDependency(key, dependency, this.PopulateOperationContext(operation));
                                break;
                            }
                            case UpdateIndice: {
                                Object key = operation.getKey();
                                nCache.getCache().Get(key);
                                break;
                            }
                            case RegisterKeyNotification: {
                                Object key = operation.getKey();
                                Object tempVar7 = operation.getData();
                                Object[] notificatins = (Object[])(tempVar7 instanceof Object[] ? tempVar7 : null);
                                CallbackInfo updateCallback = (CallbackInfo)(notificatins[0] instanceof CallbackInfo ? notificatins[0] : null);
                                CallbackInfo removeCallback = (CallbackInfo)(notificatins[0] instanceof CallbackInfo ? notificatins[0] : null);
                                nCache.getCache().RegisterKeyNotificationCallback((String)key, updateCallback, removeCallback, this.PopulateOperationContext(operation));
                                break;
                            }
                            case UnregisterKeyNotification: {
                                Object key = operation.getKey();
                                Object tempVar8 = operation.getData();
                                Object[] notificatins = (Object[])(tempVar8 instanceof Object[] ? tempVar8 : null);
                                CallbackInfo updateCallback = (CallbackInfo)(notificatins[0] instanceof CallbackInfo ? notificatins[0] : null);
                                CallbackInfo removeCallback = (CallbackInfo)(notificatins[0] instanceof CallbackInfo ? notificatins[0] : null);
                                nCache.getCache().UnregisterKeyNotificationCallback((String)key, updateCallback, removeCallback, this.PopulateOperationContext(operation));
                                break;
                            }
                            case AddDepKeyList: {
                                Object key = operation.getKey();
                                break;
                            }
                            case RemoveDepKeyList: {
                                Object key = operation.getKey();
                                break;
                            }
                            case RemoveGroup: {
                                Object key = operation.getKey();
                                break;
                            }
                            case RemoveKeyDep: {
                                Object key = operation.getKey();
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugAnalysis.getEnableDetailLogging()) {
                            s_monitor.IncremenFailedtBridgeOperation(operation.getOpCode());
                        }
                        failedOperations.put(operation, e);
                    }
                }
            }
            ResponseProtocol.Response.Builder rspBuilder = ResponseProtocol.Response.newBuilder();
            HybridBulkResponseProtocol.HybridBulkResponse.Builder commandResponse = HybridBulkResponseProtocol.HybridBulkResponse.newBuilder();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)stream, "");
            outputStream.writeObject(failedOperations);
            outputStream.flush();
            commandResponse.setBinaryResult(ByteString.copyFrom((byte[])stream.toByteArray()));
            rspBuilder.setHybridBulkResponse(commandResponse);
            rspBuilder.setRequestId(Long.parseLong(cmdInfo.RequestId));
            rspBuilder.setResponseType(ResponseProtocol.Response.Type.HYBRID_BULK);
            ResponseProtocol.Response response = rspBuilder.build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._getResult = OperationResult.Failure;
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        HybridBulkCommandProtocol.HybridBulkCommand hybridBulkCommand = command.getHybridBulkCommand();
        cmdInfo.Flag = new BitSet((byte)hybridBulkCommand.getFlag());
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.buffer = ByteString.copyFrom((List)hybridBulkCommand.getDataList()).toByteArray();
        return cmdInfo;
    }

    private OperationContext PopulateOperationContext(BridgeOperation operation) {
        OperationContext oc = new OperationContext();
        oc.Add(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.BridgeOperation);
        oc.Add(OperationContextFieldName.BridgeOpTimeStamp, (Object)operation.getBridgeOpTimeStamp());
        return oc;
    }

    private static final class CommandInfo {
        public String RequestId;
        public BitSet Flag;
        public byte[] buffer;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Flag = this.Flag;
            varCopy.buffer = this.buffer;
            return varCopy;
        }
    }
}

