/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.SocketServer.CacheProvider;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ConnectionManager;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.InitCommandProtocol;
import com.alachisoft.ncache.common.protobuf.InitializeCacheResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import java.io.Serializable;
import java.net.InetSocketAddress;

public class InitializeCommand
extends CommandBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (RuntimeException exc) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", clientManager.getClientSocket().getInetAddress().toString() + ":" + clientManager.getClientSocket().getPort() + " parsing error " + exc.toString());
            }
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            Serializable remoteAddress;
            clientManager.setClientID(cmdInfo.ClientID);
            clientManager.IsDotNetClient = cmdInfo.IsDotNetClient;
            if (!(LicenseManager.isEntCacheServer() || LicenseManager.isProCacheServer() || LicenseManager.isExpress())) {
                InetSocketAddress localAddress = (InetSocketAddress)clientManager.getClientSocket().getLocalSocketAddress();
                remoteAddress = (InetSocketAddress)clientManager.getClientSocket().getRemoteSocketAddress();
                if (!localAddress.getHostName().equals(remoteAddress.getHostName())) {
                    throw new OperationNotSupportedException("Server can not accept remote clients in this edition of NCache");
                }
            }
            clientManager.setCmdExecuter(new NCache(cmdInfo.CacheId, cmdInfo.IsDotNetClient, clientManager, cmdInfo.LicenceCode, cmdInfo.UserName, cmdInfo.Password, cmdInfo.UserNameBinary, cmdInfo.PassworNameBinary, cmdInfo.IsBridgeClient));
            if (LicenseManager.isEnterprise() || LicenseManager.isProfessional()) {
                CacheProvider.getProvider().GetLicenseLogger().Add(cmdInfo.LicenseInfo);
            }
            ClientManager cmgr = null;
            remoteAddress = ConnectionManager.ConnectionTable;
            synchronized (remoteAddress) {
                block22: {
                    if (ConnectionManager.ConnectionTable.containsKey(clientManager.getClientID())) {
                        if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                            SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", "Another client with same clientID exists. Client ID is " + clientManager.getClientID());
                        }
                        cmgr = ConnectionManager.ConnectionTable.get(clientManager.getClientID()) instanceof ClientManager ? ConnectionManager.ConnectionTable.get(clientManager.getClientID()) : null;
                        ConnectionManager.ConnectionTable.remove(clientManager.getClientID());
                    }
                    ConnectionManager.ConnectionTable.put(clientManager.getClientID(), clientManager);
                    try {
                        if (cmgr != null) {
                            cmgr.dispose();
                        }
                    }
                    catch (RuntimeException e) {
                        if (!SocketServer.getLogger().getIsErrorLogsEnabled()) break block22;
                        SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", " an error occured while forcefully disposing a client. " + e.toString());
                    }
                }
            }
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", clientManager.getClientID() + " is connected to " + cmdInfo.CacheId);
            }
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setInitCache(InitializeCacheResponseProtocol.InitializeCacheResponse.newBuilder().setCacheType(((NCache)clientManager.getCmdExecuter()).getCache().getCacheType().toLowerCase()).setTargetCacheUniqueID(((NCache)clientManager.getCmdExecuter()).getCache().getTargetCacheUniqueID())).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.INIT).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
            if (SocketServer.getLogger().getIsDetailedLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Info("InitializeCommand.Execute", clientManager.getClientSocket().getInetAddress().toString() + ":" + clientManager.getClientSocket().getPort() + " : " + clientManager.getClientID() + " connected to " + cmdInfo.CacheId);
            }
        }
        catch (SecurityException sec) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", clientManager.getClientSocket().getInetAddress().toString() + ":" + clientManager.getClientSocket().getPort() + " : " + clientManager.getClientID() + " failed to connect to " + cmdInfo.CacheId + " Error: " + sec.toString());
            }
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)((Object)sec), (long)command.getRequestID()));
        }
        catch (Exception exc) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("InitializeCommand.Execute", clientManager.getClientSocket().getInetAddress().toString() + ":" + clientManager.getClientSocket().getPort() + " : " + clientManager.getClientID() + " failed to connect to " + cmdInfo.CacheId + " Error: " + exc.toString());
            }
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        InitCommandProtocol.InitCommand initCommand = command.getInitCommand();
        cmdInfo.RequestId = String.valueOf(command.getRequestID());
        cmdInfo.CacheId = initCommand.getCacheId();
        cmdInfo.ClientID = initCommand.getClientId();
        cmdInfo.IsBridgeClient = initCommand.getIsBridgeClient();
        cmdInfo.IsDotNetClient = initCommand.getIsDotnetClient();
        cmdInfo.LicenceCode = initCommand.getLicenceCode();
        cmdInfo.LicenseInfo = initCommand.getLicenceInfo().equals("") ? null : LicenseInfo.deserialize((String)initCommand.getLicenceInfo());
        cmdInfo.Password = initCommand.getPwd();
        cmdInfo.PassworNameBinary = initCommand.getBinaryPwd().toByteArray();
        cmdInfo.RequestId = new Long(initCommand.getRequestId()).toString();
        cmdInfo.UserName = initCommand.getUserId();
        cmdInfo.UserNameBinary = initCommand.getBinaryUserid().toByteArray();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String CacheId;
        public String UserName;
        public String Password;
        public boolean IsDotNetClient;
        public String ClientID;
        public String LicenceCode;
        public LicenseInfo LicenseInfo;
        public byte[] UserNameBinary;
        public byte[] PassworNameBinary;
        public boolean IsBridgeClient;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.CacheId = this.CacheId;
            varCopy.UserName = this.UserName;
            varCopy.Password = this.Password;
            varCopy.IsDotNetClient = this.IsDotNetClient;
            varCopy.ClientID = this.ClientID;
            varCopy.LicenceCode = this.LicenceCode;
            varCopy.LicenseInfo = this.LicenseInfo;
            varCopy.UserNameBinary = this.UserNameBinary;
            varCopy.PassworNameBinary = this.PassworNameBinary;
            varCopy.IsBridgeClient = this.IsBridgeClient;
            return varCopy;
        }
    }
}

