/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Queries.QueryDataFilters;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Util.JavaClrTypeMapping;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.RegisterCQCommandProtocol;
import com.alachisoft.ncache.common.protobuf.RegisterCQResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RegisterCQCommand
extends CommandBase {
    private static char Delimitor = (char)124;

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (RuntimeException exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            QueryDataFilters datafilters = new QueryDataFilters(cmdInfo.addDataFilter, cmdInfo.updateDataFilter, cmdInfo.removeDataFilter);
            String queryId = nCache.getCache().RegisterCQ(cmdInfo.Query, cmdInfo.Values, cmdInfo.clientUniqueId, clientManager.getClientID(), cmdInfo.notifyAdd, cmdInfo.notifyUpdate, cmdInfo.notifyRemove, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation), datafilters);
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setRegisterCQResponse(RegisterCQResponseProtocol.RegisterCQResponse.newBuilder().setCqId(queryId)).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.REGISTER_CQ).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        RegisterCQCommandProtocol.RegisterCQCommand registerCQCommand = command.getRegisterCQCommand();
        cmdInfo.Query = registerCQCommand.getQuery();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.notifyAdd = registerCQCommand.getNotifyAdd();
        cmdInfo.notifyUpdate = registerCQCommand.getNotifyUpdate();
        cmdInfo.notifyRemove = registerCQCommand.getNotifyRemove();
        cmdInfo.clientUniqueId = registerCQCommand.getClientUniqueId();
        cmdInfo.addDataFilter = registerCQCommand.getAddDataFilter();
        cmdInfo.removeDataFilter = registerCQCommand.getRemvoeDataFilter();
        cmdInfo.updateDataFilter = registerCQCommand.getUpdateDataFilter();
        cmdInfo.Values = new HashMap();
        for (KeyValueProtocol.KeyValue searchValue : registerCQCommand.getValuesList()) {
            String key = searchValue.getKey();
            Class<?> type = null;
            Object value = null;
            for (ValueWithTypeProtocol.ValueWithType valueWithType : searchValue.getValueList()) {
                String typeStr = valueWithType.getType();
                if (clientManager.IsDotNetClient) {
                    typeStr = JavaClrTypeMapping.ClrToJava((String)valueWithType.getType());
                }
                try {
                    type = Class.forName(typeStr);
                    if (valueWithType.getValue() != null) {
                        if (type == Date.class) {
                            if (clientManager.IsDotNetClient) {
                                value = new ConfigurationBuilder().ConvertToPrimitive(type, valueWithType.getValue(), "");
                            } else {
                                long ticks = Long.parseLong(valueWithType.getValue());
                                value = new Date(ticks);
                            }
                        } else {
                            value = new ConfigurationBuilder().ConvertToPrimitive(type, valueWithType.getValue(), "");
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot convert '" + valueWithType.getValue() + "' to " + type.toString());
                }
                if (!cmdInfo.Values.containsKey(key)) {
                    cmdInfo.Values.put(key, value);
                    continue;
                }
                ArrayList<Object> list = cmdInfo.Values.get(key) instanceof ArrayList ? cmdInfo.Values.get(key) : null;
                if (list == null) {
                    list = new ArrayList<Object>();
                    list.add(cmdInfo.Values.get(key));
                    cmdInfo.Values.remove(key);
                    list.add(value);
                    cmdInfo.Values.put(key, list);
                    continue;
                }
                list.add(value);
            }
        }
        return cmdInfo;
    }

    private Object GetValueObject(String value) throws Exception {
        Object retVal = null;
        String[] vals = value.split(Pattern.quote(new Character(Delimitor).toString()), -1);
        String valObj = vals[0];
        String typeStr = vals[1];
        Class<?> objType = Class.forName(typeStr);
        retVal = objType == Date.class ? objType.cast(valObj) : objType.cast(valObj);
        return retVal;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Query;
        public Map Values;
        public boolean notifyAdd;
        public boolean notifyUpdate;
        public boolean notifyRemove;
        public String clientUniqueId;
        public int addDataFilter;
        public int removeDataFilter;
        public int updateDataFilter;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Query = this.Query;
            varCopy.Values = this.Values;
            varCopy.notifyAdd = this.notifyAdd;
            varCopy.notifyUpdate = this.notifyUpdate;
            varCopy.notifyRemove = this.notifyRemove;
            varCopy.clientUniqueId = this.clientUniqueId;
            varCopy.addDataFilter = this.addDataFilter;
            varCopy.removeDataFilter = this.removeDataFilter;
            varCopy.updateDataFilter = this.updateDataFilter;
            return varCopy;
        }
    }
}

