/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command.ResponseBuilders;

import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Persistence.Event;
import Alachisoft.NCache.SocketServer.Command.ResponseBuilders.ResponseBuilderBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.EventIdProtocol;
import com.alachisoft.ncache.common.protobuf.EventInfoProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.SyncEventsResponseProtocol;
import java.util.ArrayList;
import java.util.List;

public class SyncEventResponseBuilder
extends ResponseBuilderBase {
    public static List<byte[]> BuildResponse(ArrayList<Event> events, String requestId, List<byte[]> serializedResponse, String clientId) {
        long requestID = Long.parseLong(requestId);
        ResponseProtocol.Response.Builder response = ResponseProtocol.Response.newBuilder();
        SyncEventsResponseProtocol.SyncEventsResponse.Builder syncEventResponse = SyncEventsResponseProtocol.SyncEventsResponse.newBuilder();
        response.setSyncEventsResponse(syncEventResponse);
        response.setRequestId(requestID);
        response.setResponseType(ResponseProtocol.Response.Type.SYNC_EVENTS);
        for (Event evt : events) {
            EventInfoProtocol.EventInfo.Builder evtInfo = EventInfoProtocol.EventInfo.newBuilder();
            EventIdProtocol.EventId.Builder eventId = EventIdProtocol.EventId.newBuilder();
            eventId.setEventUniqueId(evt.getPersistedEventId().getEventUniqueID());
            eventId.setEventCounter(evt.getPersistedEventId().getEventCounter());
            eventId.setOperationCounter(evt.getPersistedEventId().getOperationCounter());
            evtInfo.setEventId(eventId);
            switch (evt.getPersistedEventId().getEventType()) {
                case CACHE_CLEARED_EVENT: {
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.CACHE_CLEARED_EVENT);
                    break;
                }
                case CQ_CALLBACK: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    evtInfo.setQueryId(evt.getPersistedEventId().getQueryId());
                    evtInfo.setChangeType(evt.getPersistedEventId().getQueryChangeType().getValue());
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.CQ_CALLBACK);
                    break;
                }
                case ITEM_ADDED_EVENT: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.ITEM_ADDED_EVENT);
                    break;
                }
                case ITEM_REMOVED_CALLBACK: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    evtInfo.setFlag((int)evt.getPersistedEventInfo().getFlag().getData());
                    for (CallbackInfo cbInfo : evt.getPersistedEventInfo().getCallBackInfoList()) {
                        if (!cbInfo.getClient().equals(clientId)) continue;
                        evtInfo.setCallbackId(((Integer)cbInfo.getCallback()).intValue());
                    }
                    evtInfo.addAllValue((Iterable)((ArrayList)evt.getPersistedEventInfo().getValue()));
                    evtInfo.setItemRemoveReason(evt.getPersistedEventInfo().getReason().getValue());
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.ITEM_REMOVED_CALLBACK);
                    break;
                }
                case ITEM_REMOVED_EVENT: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.ITEM_REMOVED_EVENT);
                    break;
                }
                case ITEM_UPDATED_CALLBACK: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    for (CallbackInfo cbInfo : evt.getPersistedEventInfo().getCallBackInfoList()) {
                        if (!cbInfo.getClient().equals(clientId)) continue;
                        evtInfo.setCallbackId(((Integer)cbInfo.getCallback()).intValue());
                    }
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.ITEM_UPDATED_CALLBACK);
                    break;
                }
                case ITEM_UPDATED_EVENT: {
                    evtInfo.setKey(evt.getPersistedEventInfo().getKey());
                    evtInfo.setEventType(EventInfoProtocol.EventInfo.EventType.ITEM_UPDATED_EVENT);
                }
            }
            response.setSyncEventsResponse(syncEventResponse.addEventInfo(evtInfo));
        }
        serializedResponse.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response.build()));
        return serializedResponse;
    }
}

