/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Util.JavaClrTypeMapping;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.ResponseBuilders.SearchResponseBuilder;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.SearchCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SearchCommand
extends CommandBase {
    private static char Delimitor = (char)124;

    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
        }
        catch (RuntimeException exc) {
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            QueryResultSet resultSet = null;
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            if (cmdInfo.CommandVersion <= 1) {
                operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)this.forcedViewId);
            } else {
                operationContext.Add(OperationContextFieldName.ClientLastViewId, (Object)cmdInfo.ClientLastViewId);
            }
            resultSet = nCache.getCache().Search(cmdInfo.Query, cmdInfo.Values, operationContext);
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setSearch(SearchResponseBuilder.BuildResponse(resultSet, cmdInfo.CommandVersion)).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.SEARCH).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        int index;
        CommandInfo cmdInfo = new CommandInfo();
        SearchCommandProtocol.SearchCommand searchCommand = command.getSearchCommand();
        cmdInfo.Query = searchCommand.getQuery();
        if (clientManager.IsDotNetClient) {
            index = cmdInfo.Query.indexOf("$Text$");
            if (index != -1) {
                cmdInfo.Query = cmdInfo.Query.replace("$Text$", "System.String");
            } else {
                index = cmdInfo.Query.indexOf("$TEXT$");
                if (index != -1) {
                    cmdInfo.Query = cmdInfo.Query.replace("$TEXT$", "System.String");
                } else {
                    index = cmdInfo.Query.indexOf("$text$");
                    if (index != -1) {
                        cmdInfo.Query = cmdInfo.Query.replace("$text$", "System.String");
                    }
                }
            }
        } else {
            index = cmdInfo.Query.indexOf("$Text$");
            if (index != -1) {
                cmdInfo.Query = cmdInfo.Query.replace("$Text$", "java.lang.String");
            } else {
                index = cmdInfo.Query.indexOf("$TEXT$");
                if (index != -1) {
                    cmdInfo.Query = cmdInfo.Query.replace("$TEXT$", "java.lang.String");
                } else {
                    index = cmdInfo.Query.indexOf("$text$");
                    if (index != -1) {
                        cmdInfo.Query = cmdInfo.Query.replace("$text$", "java.lang.String");
                    }
                }
            }
        }
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        cmdInfo.CommandVersion = command.getCommandVersion();
        cmdInfo.ClientLastViewId = command.getClientLastViewId();
        cmdInfo.Values = new HashMap();
        for (KeyValueProtocol.KeyValue searchValue : searchCommand.getValuesList()) {
            String key = searchValue.getKey();
            Class<?> type = null;
            Object value = null;
            for (ValueWithTypeProtocol.ValueWithType valueWithType : searchValue.getValueList()) {
                String typeStr = valueWithType.getType();
                if (clientManager.IsDotNetClient) {
                    typeStr = JavaClrTypeMapping.ClrToJava((String)valueWithType.getType());
                }
                try {
                    type = Class.forName(typeStr);
                    if (valueWithType.getValue() != null) {
                        value = type == Date.class ? HelperFxn.getDateFromTicks((long)Long.parseLong(valueWithType.getValue())) : new ConfigurationBuilder().ConvertToPrimitive(type, valueWithType.getValue(), "");
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot convert '" + valueWithType.getValue() + "' to " + type.toString());
                }
                if (!cmdInfo.Values.containsKey(key)) {
                    cmdInfo.Values.put(key, value);
                    continue;
                }
                ArrayList<Object> list = cmdInfo.Values.get(key) instanceof ArrayList ? cmdInfo.Values.get(key) : null;
                if (list == null) {
                    list = new ArrayList<Object>();
                    list.add(cmdInfo.Values.get(key));
                    cmdInfo.Values.remove(key);
                    list.add(value);
                    cmdInfo.Values.put(key, list);
                    continue;
                }
                list.add(value);
            }
        }
        return cmdInfo;
    }

    private Object GetValueObject(String value) throws Exception {
        Object retVal = null;
        String[] vals = value.split(Pattern.quote(new Character(Delimitor).toString()), -1);
        String valObj = vals[0];
        String typeStr = vals[1];
        Class<?> objType = Class.forName(typeStr);
        retVal = objType == Date.class ? objType.cast(valObj) : objType.cast(valObj);
        return retVal;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Query;
        public Map Values;
        public int CommandVersion;
        public long ClientLastViewId;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Query = this.Query;
            varCopy.Values = this.Values;
            varCopy.CommandVersion = this.CommandVersion;
            varCopy.ClientLastViewId = this.ClientLastViewId;
            return varCopy;
        }
    }
}

