/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.SocketServer.Command;

import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.SocketServer.ClientManager;
import Alachisoft.NCache.SocketServer.Command.OperationResult;
import Alachisoft.NCache.SocketServer.ICommandExecuter;
import Alachisoft.NCache.SocketServer.NCache;
import Alachisoft.NCache.SocketServer.SocketServer;
import SocketServer.Command.CommandBase;
import Util.ResponseHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.ResponseProtocol;
import com.alachisoft.ncache.common.protobuf.UnlockCommandProtocol;
import com.alachisoft.ncache.common.protobuf.UnlockResponseProtocol;

public class UnlockCommand
extends CommandBase {
    private OperationResult _unlockResult = OperationResult.Success;

    @Override
    public OperationResult getOperationResult() {
        return this._unlockResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteCommand(ClientManager clientManager, CommandProtocol.Command command) {
        CommandInfo cmdInfo = new CommandInfo();
        try {
            cmdInfo = this.ParseCommand(command, clientManager).clone();
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"UnlockCmd.Exec", (String)"cmd parsed");
            }
        }
        catch (IllegalArgumentException arEx) {
            if (SocketServer.getLogger().getIsErrorLogsEnabled()) {
                SocketServer.getLogger().getNCacheLog().Error("UnlockCommand", "command: " + command + " Error" + arEx);
            }
            this._unlockResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)arEx, (long)command.getRequestID()));
            }
            return;
        }
        catch (RuntimeException exc) {
            this._unlockResult = OperationResult.Failure;
            if (!this.immatureId.equals("-2")) {
                this._serializedResponsePackets.add(ResponseHelper.SerializeExceptionResponse((Exception)exc, (long)command.getRequestID()));
            }
            return;
        }
        try {
            ICommandExecuter tempVar = clientManager.getCmdExecuter();
            NCache nCache = (NCache)(tempVar instanceof NCache ? tempVar : null);
            nCache.getCache().Unlock((Object)cmdInfo.Key, cmdInfo.lockId, cmdInfo.isPreemptive, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            ResponseProtocol.Response response = ResponseProtocol.Response.newBuilder().setUnlockResponse(UnlockResponseProtocol.UnlockResponse.newBuilder()).setRequestId(Long.parseLong(cmdInfo.RequestId)).setResponseType(ResponseProtocol.Response.Type.UNLOCK).build();
            this._serializedResponsePackets.add(ResponseHelper.SerializeResponse((ResponseProtocol.Response)response));
        }
        catch (Exception exc) {
            this._unlockResult = OperationResult.Failure;
            this._serializedResponsePackets.add(clientManager.ReplyPacket(super.ExceptionPacket(exc, cmdInfo.RequestId), super.ExceptionMessage(exc)));
        }
        finally {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"UnlockCmd.Exec", (String)"cmd executed on cache");
            }
        }
    }

    private CommandInfo ParseCommand(CommandProtocol.Command command, ClientManager clientManager) {
        CommandInfo cmdInfo = new CommandInfo();
        UnlockCommandProtocol.UnlockCommand unlockCommand = command.getUnlockCommand();
        cmdInfo.isPreemptive = unlockCommand.getPreemptive();
        if (!unlockCommand.getPreemptive()) {
            cmdInfo.lockId = unlockCommand.getLockId();
        }
        cmdInfo.Key = unlockCommand.getKey();
        cmdInfo.RequestId = new Long(command.getRequestID()).toString();
        return cmdInfo;
    }

    private static final class CommandInfo {
        public String RequestId;
        public String Key;
        public boolean isPreemptive;
        public Object lockId;

        private CommandInfo() {
        }

        public CommandInfo clone() {
            CommandInfo varCopy = new CommandInfo();
            varCopy.RequestId = this.RequestId;
            varCopy.Key = this.Key;
            varCopy.isPreemptive = this.isPreemptive;
            varCopy.lockId = this.lockId;
            return varCopy;
        }
    }
}

