/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jmx2snmp.jmx;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import org.vafer.jmx2snmp.jmx.RMIServerSocketFactoryImpl;

public final class JmxServer {
    private final InetAddress address;
    private final int protocolPort;
    private final int namingPort;
    private RMIConnectorServer rmiServer;
    private String url;
    private Registry registry;

    public JmxServer(InetAddress pAddress, int pProtocolPort, int pNamingPort) {
        this.address = pAddress;
        this.protocolPort = pProtocolPort;
        this.namingPort = pNamingPort;
    }

    public JmxServer() throws UnknownHostException {
        this(InetAddress.getLocalHost());
    }

    public JmxServer(InetAddress pAddress) {
        this(pAddress, 0, 5100);
    }

    public String getUrl() {
        return this.url;
    }

    public int getProtocolPort() {
        return this.protocolPort;
    }

    public int getNamingPort() {
        return this.namingPort;
    }

    public synchronized void start() throws Exception {
        if (this.rmiServer != null) {
            return;
        }
        RMIServerSocketFactoryImpl serverFactory = new RMIServerSocketFactoryImpl(this.address);
        this.registry = LocateRegistry.createRegistry(this.namingPort, null, serverFactory);
        HashMap<String, RMIServerSocketFactoryImpl> env = new HashMap<String, RMIServerSocketFactoryImpl>();
        env.put("jmx.remote.rmi.server.socket.factory", serverFactory);
        StringBuffer serviceUrl = new StringBuffer();
        serviceUrl.append("service:jmx:");
        serviceUrl.append("rmi://").append(this.address.getHostAddress()).append(':').append(this.protocolPort).append("/jndi/");
        serviceUrl.append("rmi://").append(this.address.getHostAddress()).append(':').append(this.namingPort).append("/connector");
        this.url = serviceUrl.toString();
        this.rmiServer = new RMIConnectorServer(new JMXServiceURL(this.url), env, ManagementFactory.getPlatformMBeanServer());
        this.rmiServer.start();
    }

    public synchronized void stop() throws Exception {
        this.rmiServer.stop();
        UnicastRemoteObject.unexportObject(this.registry, true);
        this.registry = null;
        this.rmiServer = null;
        this.url = null;
    }
}

