/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.Mapping;
import org.weakref.jmx.guice.ObjectNameFunction;
import org.weakref.jmx.guice.SetMapping;

class GuiceMBeanExporter {
    @Inject
    public GuiceMBeanExporter(Set<Mapping> mappings, Set<SetMapping<?>> setMappings, Set<MapMapping<?, ?>> mapMappings, MBeanExporter exporter, Injector injector) {
        this.export(mappings, exporter, injector);
        this.exportSets(setMappings, exporter, injector);
        this.exportMaps(mapMappings, exporter, injector);
    }

    private <K, V> void exportMaps(Set<MapMapping<K, V>> mapMappings, MBeanExporter exporter, Injector injector) {
        for (MapMapping<K, V> mapping : mapMappings) {
            ObjectNameFunction<Map.Entry<K, V>> namingFunction = mapping.getObjectNameFunction();
            Map map = (Map)injector.getInstance(mapping.getKey());
            for (Map.Entry entry : map.entrySet()) {
                ObjectName name = namingFunction.name(entry);
                exporter.export(name, entry.getValue());
            }
        }
    }

    private <T> void exportSets(Set<SetMapping<T>> setMappings, MBeanExporter exporter, Injector injector) {
        for (SetMapping<T> mapping : setMappings) {
            ObjectNameFunction objectNameFunction = mapping.getObjectNameFunction();
            Set set = (Set)injector.getInstance(mapping.getKey());
            for (Object instance : set) {
                ObjectName name = objectNameFunction.name(instance);
                exporter.export(name, instance);
            }
        }
    }

    private void export(Set<Mapping> mappings, MBeanExporter exporter, Injector injector) {
        for (Mapping mapping : mappings) {
            exporter.export(mapping.getName(), injector.getInstance(mapping.getKey()));
        }
    }
}

