import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterResourceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Service Perimeter to add this resource to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html#perimeter_name AccessContextManagerServicePerimeterResource#perimeter_name}
     *
     * @stability stable
     */
    readonly perimeterName: string;
    /**
     * A GCP resource that is inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html#resource AccessContextManagerServicePerimeterResource#resource}
     *
     * @stability stable
     */
    readonly resource: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html#timeouts AccessContextManagerServicePerimeterResource#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerServicePerimeterResourceTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterResourceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html#create AccessContextManagerServicePerimeterResource#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html#delete AccessContextManagerServicePerimeterResource#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html google_access_context_manager_service_perimeter_resource}.
 *
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterResource extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter_resource.html google_access_context_manager_service_perimeter_resource} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimeterResourceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _perimeterName;
    /**
     * @stability stable
     */
    get perimeterName(): string;
    /**
     * @stability stable
     */
    set perimeterName(value: string);
    /**
     * @stability stable
     */
    get perimeterNameInput(): string;
    private _resource;
    /**
     * @stability stable
     */
    get resource(): string;
    /**
     * @stability stable
     */
    set resource(value: string);
    /**
     * @stability stable
     */
    get resourceInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerServicePerimeterResourceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AccessContextManagerServicePerimeterResourceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerServicePerimeterResourceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
