import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersConfig extends cdktf.TerraformMetaArguments {
    /**
     * The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#parent AccessContextManagerServicePerimeters#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * service_perimeters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_perimeters AccessContextManagerServicePerimeters#service_perimeters}
     *
     * @stability stable
     */
    readonly servicePerimeters?: AccessContextManagerServicePerimetersServicePerimeters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#timeouts AccessContextManagerServicePerimeters#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerServicePerimetersTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom[];
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom[];
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpec {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom[];
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom[];
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatus {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimeters {
    /**
     * Description of the ServicePerimeter and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#description AccessContextManagerServicePerimeters#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#name AccessContextManagerServicePerimeters#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the type of the Perimeter.
     *
     * There are two types: regular and
     * bridge. Regular Service Perimeter contains resources, access levels,
     * and restricted services. Every resource can be in at most
     * ONE regular Service Perimeter.
     *
     * In addition to being in a regular service perimeter, a resource can also
     * be in zero or more perimeter bridges. A perimeter bridge only contains
     * resources. Cross project operations are permitted if all effected
     * resources share some perimeter (whether bridge or regular). Perimeter
     * Bridge does not contain access levels or services: those are governed
     * entirely by the regular perimeter that resource is in.
     *
     * Perimeter Bridges are typically useful when building more complex
     * topologies with many independent perimeters that need to share some data
     * with a common perimeter, but should not be able to share data among
     * themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#perimeter_type AccessContextManagerServicePerimeters#perimeter_type}
     *
     * @stability stable
     */
    readonly perimeterType?: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#title AccessContextManagerServicePerimeters#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Use explicit dry run spec flag.
     *
     * Ordinarily, a dry-run spec implicitly exists
     * for all Service Perimeters, and that spec is identical to the status for those
     * Service Perimeters. When this flag is set, it inhibits the generation of the
     * implicit spec, thereby allowing the user to explicitly provide a
     * configuration ("spec") to use in a dry-run version of the Service Perimeter.
     * This allows the user to test changes to the enforced config ("status") without
     * actually enforcing them. This testing is done through analyzing the differences
     * between currently enforced and suggested restrictions. useExplicitDryRunSpec must
     * bet set to True if any of the fields in the spec are set to non-default values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#use_explicit_dry_run_spec AccessContextManagerServicePerimeters#use_explicit_dry_run_spec}
     *
     * @stability stable
     */
    readonly useExplicitDryRunSpec?: boolean;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#spec AccessContextManagerServicePerimeters#spec}
     *
     * @stability stable
     */
    readonly spec?: AccessContextManagerServicePerimetersServicePerimetersSpec[];
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#status AccessContextManagerServicePerimeters#status}
     *
     * @stability stable
     */
    readonly status?: AccessContextManagerServicePerimetersServicePerimetersStatus[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#create AccessContextManagerServicePerimeters#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#delete AccessContextManagerServicePerimeters#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#update AccessContextManagerServicePerimeters#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters}.
 *
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeters extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimetersConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _parent;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string;
    private _servicePerimeters?;
    /**
     * @stability stable
     */
    get servicePerimeters(): AccessContextManagerServicePerimetersServicePerimeters[];
    /**
     * @stability stable
     */
    set servicePerimeters(value: AccessContextManagerServicePerimetersServicePerimeters[]);
    /**
     * @stability stable
     */
    resetServicePerimeters(): void;
    /**
     * @stability stable
     */
    get servicePerimetersInput(): AccessContextManagerServicePerimetersServicePerimeters[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerServicePerimetersTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AccessContextManagerServicePerimetersTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerServicePerimetersTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
