import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApigeeEnvgroupAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The Apigee environment group associated with the Apigee environment, in the format 'organizations/{{org_name}}/envgroups/{{envgroup_name}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html#envgroup_id ApigeeEnvgroupAttachment#envgroup_id}
     *
     * @stability stable
     */
    readonly envgroupId: string;
    /**
     * The resource ID of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html#environment ApigeeEnvgroupAttachment#environment}
     *
     * @stability stable
     */
    readonly environment: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html#timeouts ApigeeEnvgroupAttachment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApigeeEnvgroupAttachmentTimeouts;
}
/**
 * @stability stable
 */
export interface ApigeeEnvgroupAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html#create ApigeeEnvgroupAttachment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html#delete ApigeeEnvgroupAttachment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html google_apigee_envgroup_attachment}.
 *
 * @stability stable
 */
export declare class ApigeeEnvgroupAttachment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment.html google_apigee_envgroup_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApigeeEnvgroupAttachmentConfig);
    private _envgroupId;
    /**
     * @stability stable
     */
    get envgroupId(): string;
    /**
     * @stability stable
     */
    set envgroupId(value: string);
    /**
     * @stability stable
     */
    get envgroupIdInput(): string;
    private _environment;
    /**
     * @stability stable
     */
    get environment(): string;
    /**
     * @stability stable
     */
    set environment(value: string);
    /**
     * @stability stable
     */
    get environmentInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ApigeeEnvgroupAttachmentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ApigeeEnvgroupAttachmentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApigeeEnvgroupAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
