import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The domain to authenticate users with when using App Engine's User API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#auth_domain AppEngineApplication#auth_domain}
     *
     * @stability stable
     */
    readonly authDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#database_type AppEngineApplication#database_type}.
     *
     * @stability stable
     */
    readonly databaseType?: string;
    /**
     * The location to serve the app from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#location_id AppEngineApplication#location_id}
     *
     * @stability stable
     */
    readonly locationId: string;
    /**
     * The project ID to create the application under.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#project AppEngineApplication#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The serving status of the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#serving_status AppEngineApplication#serving_status}
     *
     * @stability stable
     */
    readonly servingStatus?: string;
    /**
     * feature_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#feature_settings AppEngineApplication#feature_settings}
     *
     * @stability stable
     */
    readonly featureSettings?: AppEngineApplicationFeatureSettings[];
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#iap AppEngineApplication#iap}
     *
     * @stability stable
     */
    readonly iap?: AppEngineApplicationIap[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#timeouts AppEngineApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineApplicationTimeouts;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationUrlDispatchRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get service(): string;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationFeatureSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#split_health_checks AppEngineApplication#split_health_checks}.
     *
     * @stability stable
     */
    readonly splitHealthChecks: boolean;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationIap {
    /**
     * Adapted for use with the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#enabled AppEngineApplication#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * OAuth2 client ID to use for the authentication flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_id AppEngineApplication#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 client secret to use for the authentication flow.
     *
     * The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_secret AppEngineApplication#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#create AppEngineApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#update AppEngineApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application}.
 *
 * @stability stable
 */
export declare class AppEngineApplication extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineApplicationConfig);
    /**
     * @stability stable
     */
    get appId(): string;
    private _authDomain?;
    /**
     * @stability stable
     */
    get authDomain(): string;
    /**
     * @stability stable
     */
    set authDomain(value: string);
    /**
     * @stability stable
     */
    resetAuthDomain(): void;
    /**
     * @stability stable
     */
    get authDomainInput(): string | undefined;
    /**
     * @stability stable
     */
    get codeBucket(): string;
    private _databaseType?;
    /**
     * @stability stable
     */
    get databaseType(): string;
    /**
     * @stability stable
     */
    set databaseType(value: string);
    /**
     * @stability stable
     */
    resetDatabaseType(): void;
    /**
     * @stability stable
     */
    get databaseTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get defaultBucket(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    /**
     * @stability stable
     */
    get gcrDomain(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _locationId;
    /**
     * @stability stable
     */
    get locationId(): string;
    /**
     * @stability stable
     */
    set locationId(value: string);
    /**
     * @stability stable
     */
    get locationIdInput(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _servingStatus?;
    /**
     * @stability stable
     */
    get servingStatus(): string;
    /**
     * @stability stable
     */
    set servingStatus(value: string);
    /**
     * @stability stable
     */
    resetServingStatus(): void;
    /**
     * @stability stable
     */
    get servingStatusInput(): string | undefined;
    /**
     * @stability stable
     */
    urlDispatchRule(index: string): AppEngineApplicationUrlDispatchRule;
    private _featureSettings?;
    /**
     * @stability stable
     */
    get featureSettings(): AppEngineApplicationFeatureSettings[];
    /**
     * @stability stable
     */
    set featureSettings(value: AppEngineApplicationFeatureSettings[]);
    /**
     * @stability stable
     */
    resetFeatureSettings(): void;
    /**
     * @stability stable
     */
    get featureSettingsInput(): AppEngineApplicationFeatureSettings[] | undefined;
    private _iap?;
    /**
     * @stability stable
     */
    get iap(): AppEngineApplicationIap[];
    /**
     * @stability stable
     */
    set iap(value: AppEngineApplicationIap[]);
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): AppEngineApplicationIap[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineApplicationTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AppEngineApplicationTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
