import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#delete_service_on_destroy AppEngineStandardAppVersion#delete_service_on_destroy}.
     *
     * @stability stable
     */
    readonly deleteServiceOnDestroy?: boolean;
    /**
     * Environment variables available to the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#env_variables AppEngineStandardAppVersion#env_variables}
     *
     * @stability stable
     */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
     * A list of the types of messages that this application is able to receive.
     *
     * Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#inbound_services AppEngineStandardAppVersion#inbound_services}
     *
     * @stability stable
     */
    readonly inboundServices?: string[];
    /**
     * Instance class that is used to run this version.
     *
     * Valid values are
     * AutomaticScaling: F1, F2, F4, F4_1G
     * BasicScaling or ManualScaling: B1, B2, B4, B4_1G, B8
     * Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If no scaling is specified, AutomaticScaling is chosen.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#instance_class AppEngineStandardAppVersion#instance_class}
     *
     * @stability stable
     */
    readonly instanceClass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#noop_on_destroy AppEngineStandardAppVersion#noop_on_destroy}.
     *
     * @stability stable
     */
    readonly noopOnDestroy?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#project AppEngineStandardAppVersion#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Desired runtime. Example python27.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#runtime AppEngineStandardAppVersion#runtime}
     *
     * @stability stable
     */
    readonly runtime: string;
    /**
     * The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#runtime_api_version AppEngineStandardAppVersion#runtime_api_version}
     *
     * @stability stable
     */
    readonly runtimeApiVersion?: string;
    /**
     * AppEngine service resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#service AppEngineStandardAppVersion#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * Whether multiple requests can be dispatched to this version at once.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#threadsafe AppEngineStandardAppVersion#threadsafe}
     *
     * @stability stable
     */
    readonly threadsafe?: boolean;
    /**
     * Relative name of the version within the service.
     *
     * For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#version_id AppEngineStandardAppVersion#version_id}
     *
     * @stability stable
     */
    readonly versionId?: string;
    /**
     * automatic_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#automatic_scaling AppEngineStandardAppVersion#automatic_scaling}
     *
     * @stability stable
     */
    readonly automaticScaling?: AppEngineStandardAppVersionAutomaticScaling[];
    /**
     * basic_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#basic_scaling AppEngineStandardAppVersion#basic_scaling}
     *
     * @stability stable
     */
    readonly basicScaling?: AppEngineStandardAppVersionBasicScaling[];
    /**
     * deployment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#deployment AppEngineStandardAppVersion#deployment}
     *
     * @stability stable
     */
    readonly deployment: AppEngineStandardAppVersionDeployment[];
    /**
     * entrypoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#entrypoint AppEngineStandardAppVersion#entrypoint}
     *
     * @stability stable
     */
    readonly entrypoint?: AppEngineStandardAppVersionEntrypoint[];
    /**
     * handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#handlers AppEngineStandardAppVersion#handlers}
     *
     * @stability stable
     */
    readonly handlers?: AppEngineStandardAppVersionHandlers[];
    /**
     * libraries block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#libraries AppEngineStandardAppVersion#libraries}
     *
     * @stability stable
     */
    readonly libraries?: AppEngineStandardAppVersionLibraries[];
    /**
     * manual_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#manual_scaling AppEngineStandardAppVersion#manual_scaling}
     *
     * @stability stable
     */
    readonly manualScaling?: AppEngineStandardAppVersionManualScaling[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#timeouts AppEngineStandardAppVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineStandardAppVersionTimeouts;
    /**
     * vpc_access_connector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#vpc_access_connector AppEngineStandardAppVersion#vpc_access_connector}
     *
     * @stability stable
     */
    readonly vpcAccessConnector?: AppEngineStandardAppVersionVpcAccessConnector[];
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings {
    /**
     * Maximum number of instances to run for this version. Set to zero to disable maxInstances configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#max_instances AppEngineStandardAppVersion#max_instances}
     *
     * @stability stable
     */
    readonly maxInstances?: number;
    /**
     * Minimum number of instances to run for this version. Set to zero to disable minInstances configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#min_instances AppEngineStandardAppVersion#min_instances}
     *
     * @stability stable
     */
    readonly minInstances?: number;
    /**
     * Target CPU utilization ratio to maintain when scaling.
     *
     * Should be a value in the range [0.50, 0.95], zero, or a negative value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#target_cpu_utilization AppEngineStandardAppVersion#target_cpu_utilization}
     *
     * @stability stable
     */
    readonly targetCpuUtilization?: number;
    /**
     * Target throughput utilization ratio to maintain when scaling.
     *
     * Should be a value in the range [0.50, 0.95], zero, or a negative value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#target_throughput_utilization AppEngineStandardAppVersion#target_throughput_utilization}
     *
     * @stability stable
     */
    readonly targetThroughputUtilization?: number;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionAutomaticScaling {
    /**
     * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
     *
     * Defaults to a runtime-specific value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#max_concurrent_requests AppEngineStandardAppVersion#max_concurrent_requests}
     *
     * @stability stable
     */
    readonly maxConcurrentRequests?: number;
    /**
     * Maximum number of idle instances that should be maintained for this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#max_idle_instances AppEngineStandardAppVersion#max_idle_instances}
     *
     * @stability stable
     */
    readonly maxIdleInstances?: number;
    /**
     * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#max_pending_latency AppEngineStandardAppVersion#max_pending_latency}
     *
     * @stability stable
     */
    readonly maxPendingLatency?: string;
    /**
     * Minimum number of idle instances that should be maintained for this version.
     *
     * Only applicable for the default version of a service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#min_idle_instances AppEngineStandardAppVersion#min_idle_instances}
     *
     * @stability stable
     */
    readonly minIdleInstances?: number;
    /**
     * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#min_pending_latency AppEngineStandardAppVersion#min_pending_latency}
     *
     * @stability stable
     */
    readonly minPendingLatency?: string;
    /**
     * standard_scheduler_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#standard_scheduler_settings AppEngineStandardAppVersion#standard_scheduler_settings}
     *
     * @stability stable
     */
    readonly standardSchedulerSettings?: AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings[];
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionBasicScaling {
    /**
     * Duration of time after the last request that an instance must wait before the instance is shut down.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#idle_timeout AppEngineStandardAppVersion#idle_timeout}
     *
     * @stability stable
     */
    readonly idleTimeout?: string;
    /**
     * Maximum number of instances to create for this version. Must be in the range [1.0, 200.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#max_instances AppEngineStandardAppVersion#max_instances}
     *
     * @stability stable
     */
    readonly maxInstances: number;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionDeploymentFiles {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#name AppEngineStandardAppVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * SHA1 checksum of the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#sha1_sum AppEngineStandardAppVersion#sha1_sum}
     *
     * @stability stable
     */
    readonly sha1Sum?: string;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#source_url AppEngineStandardAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionDeploymentZip {
    /**
     * files count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#files_count AppEngineStandardAppVersion#files_count}
     *
     * @stability stable
     */
    readonly filesCount?: number;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#source_url AppEngineStandardAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionDeployment {
    /**
     * files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#files AppEngineStandardAppVersion#files}
     *
     * @stability stable
     */
    readonly files?: AppEngineStandardAppVersionDeploymentFiles[];
    /**
     * zip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#zip AppEngineStandardAppVersion#zip}
     *
     * @stability stable
     */
    readonly zip?: AppEngineStandardAppVersionDeploymentZip[];
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionEntrypoint {
    /**
     * The format should be a shell command that can be fed to bash -c.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#shell AppEngineStandardAppVersion#shell}
     *
     * @stability stable
     */
    readonly shell: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionHandlersScript {
    /**
     * Path to the script from the application root directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#script_path AppEngineStandardAppVersion#script_path}
     *
     * @stability stable
     */
    readonly scriptPath: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionHandlersStaticFiles {
    /**
     * Whether files should also be uploaded as code data.
     *
     * By default, files declared in static file handlers are uploaded as
     * static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged
     * against both your code and static data storage resource quotas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#application_readable AppEngineStandardAppVersion#application_readable}
     *
     * @stability stable
     */
    readonly applicationReadable?: boolean;
    /**
     * Time a static file served by this handler should be cached by web proxies and browsers.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#expiration AppEngineStandardAppVersion#expiration}
     *
     * @stability stable
     */
    readonly expiration?: string;
    /**
     * HTTP headers to use for all responses from these URLs. An object containing a list of "key:value" value pairs.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#http_headers AppEngineStandardAppVersion#http_headers}
     *
     * @stability stable
     */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
     * MIME type used to serve all files served by this handler.
     *
     * Defaults to file-specific MIME types, which are derived from each file's filename extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#mime_type AppEngineStandardAppVersion#mime_type}
     *
     * @stability stable
     */
    readonly mimeType?: string;
    /**
     * Path to the static files matched by the URL pattern, from the application root directory.
     *
     * The path can refer to text matched in groupings in the URL pattern.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#path AppEngineStandardAppVersion#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Whether this handler should match the request if the file referenced by the handler does not exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#require_matching_file AppEngineStandardAppVersion#require_matching_file}
     *
     * @stability stable
     */
    readonly requireMatchingFile?: boolean;
    /**
     * Regular expression that matches the file paths for all files that should be referenced by this handler.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#upload_path_regex AppEngineStandardAppVersion#upload_path_regex}
     *
     * @stability stable
     */
    readonly uploadPathRegex?: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionHandlers {
    /**
     * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#auth_fail_action AppEngineStandardAppVersion#auth_fail_action}
     *
     * @stability stable
     */
    readonly authFailAction?: string;
    /**
     * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#login AppEngineStandardAppVersion#login}
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#redirect_http_response_code AppEngineStandardAppVersion#redirect_http_response_code}
     *
     * @stability stable
     */
    readonly redirectHttpResponseCode?: string;
    /**
     * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#security_level AppEngineStandardAppVersion#security_level}
     *
     * @stability stable
     */
    readonly securityLevel?: string;
    /**
     * URL prefix.
     *
     * Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
     * All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#url_regex AppEngineStandardAppVersion#url_regex}
     *
     * @stability stable
     */
    readonly urlRegex?: string;
    /**
     * script block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#script AppEngineStandardAppVersion#script}
     *
     * @stability stable
     */
    readonly script?: AppEngineStandardAppVersionHandlersScript[];
    /**
     * static_files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#static_files AppEngineStandardAppVersion#static_files}
     *
     * @stability stable
     */
    readonly staticFiles?: AppEngineStandardAppVersionHandlersStaticFiles[];
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionLibraries {
    /**
     * Name of the library. Example "django".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#name AppEngineStandardAppVersion#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Version of the library to select, or "latest".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#version AppEngineStandardAppVersion#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionManualScaling {
    /**
     * Number of instances to assign to the service at the start.
     *
     * *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
     * Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#instances AppEngineStandardAppVersion#instances}
     *
     * @stability stable
     */
    readonly instances: number;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#create AppEngineStandardAppVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#delete AppEngineStandardAppVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#update AppEngineStandardAppVersion#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface AppEngineStandardAppVersionVpcAccessConnector {
    /**
     * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html#name AppEngineStandardAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html google_app_engine_standard_app_version}.
 *
 * @stability stable
 */
export declare class AppEngineStandardAppVersion extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_standard_app_version.html google_app_engine_standard_app_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineStandardAppVersionConfig);
    private _deleteServiceOnDestroy?;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set deleteServiceOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetDeleteServiceOnDestroy(): void;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroyInput(): boolean | undefined;
    private _envVariables?;
    /**
     * @stability stable
     */
    get envVariables(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set envVariables(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetEnvVariables(): void;
    /**
     * @stability stable
     */
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundServices?;
    /**
     * @stability stable
     */
    get inboundServices(): string[];
    /**
     * @stability stable
     */
    set inboundServices(value: string[]);
    /**
     * @stability stable
     */
    resetInboundServices(): void;
    /**
     * @stability stable
     */
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    /**
     * @stability stable
     */
    get instanceClass(): string;
    /**
     * @stability stable
     */
    set instanceClass(value: string);
    /**
     * @stability stable
     */
    resetInstanceClass(): void;
    /**
     * @stability stable
     */
    get instanceClassInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _noopOnDestroy?;
    /**
     * @stability stable
     */
    get noopOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set noopOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetNoopOnDestroy(): void;
    /**
     * @stability stable
     */
    get noopOnDestroyInput(): boolean | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _runtime;
    /**
     * @stability stable
     */
    get runtime(): string;
    /**
     * @stability stable
     */
    set runtime(value: string);
    /**
     * @stability stable
     */
    get runtimeInput(): string;
    private _runtimeApiVersion?;
    /**
     * @stability stable
     */
    get runtimeApiVersion(): string;
    /**
     * @stability stable
     */
    set runtimeApiVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeApiVersion(): void;
    /**
     * @stability stable
     */
    get runtimeApiVersionInput(): string | undefined;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _threadsafe?;
    /**
     * @stability stable
     */
    get threadsafe(): boolean;
    /**
     * @stability stable
     */
    set threadsafe(value: boolean);
    /**
     * @stability stable
     */
    resetThreadsafe(): void;
    /**
     * @stability stable
     */
    get threadsafeInput(): boolean | undefined;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    set versionId(value: string);
    /**
     * @stability stable
     */
    resetVersionId(): void;
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    private _automaticScaling?;
    /**
     * @stability stable
     */
    get automaticScaling(): AppEngineStandardAppVersionAutomaticScaling[];
    /**
     * @stability stable
     */
    set automaticScaling(value: AppEngineStandardAppVersionAutomaticScaling[]);
    /**
     * @stability stable
     */
    resetAutomaticScaling(): void;
    /**
     * @stability stable
     */
    get automaticScalingInput(): AppEngineStandardAppVersionAutomaticScaling[] | undefined;
    private _basicScaling?;
    /**
     * @stability stable
     */
    get basicScaling(): AppEngineStandardAppVersionBasicScaling[];
    /**
     * @stability stable
     */
    set basicScaling(value: AppEngineStandardAppVersionBasicScaling[]);
    /**
     * @stability stable
     */
    resetBasicScaling(): void;
    /**
     * @stability stable
     */
    get basicScalingInput(): AppEngineStandardAppVersionBasicScaling[] | undefined;
    private _deployment;
    /**
     * @stability stable
     */
    get deployment(): AppEngineStandardAppVersionDeployment[];
    /**
     * @stability stable
     */
    set deployment(value: AppEngineStandardAppVersionDeployment[]);
    /**
     * @stability stable
     */
    get deploymentInput(): AppEngineStandardAppVersionDeployment[];
    private _entrypoint?;
    /**
     * @stability stable
     */
    get entrypoint(): AppEngineStandardAppVersionEntrypoint[];
    /**
     * @stability stable
     */
    set entrypoint(value: AppEngineStandardAppVersionEntrypoint[]);
    /**
     * @stability stable
     */
    resetEntrypoint(): void;
    /**
     * @stability stable
     */
    get entrypointInput(): AppEngineStandardAppVersionEntrypoint[] | undefined;
    private _handlers?;
    /**
     * @stability stable
     */
    get handlers(): AppEngineStandardAppVersionHandlers[];
    /**
     * @stability stable
     */
    set handlers(value: AppEngineStandardAppVersionHandlers[]);
    /**
     * @stability stable
     */
    resetHandlers(): void;
    /**
     * @stability stable
     */
    get handlersInput(): AppEngineStandardAppVersionHandlers[] | undefined;
    private _libraries?;
    /**
     * @stability stable
     */
    get libraries(): AppEngineStandardAppVersionLibraries[];
    /**
     * @stability stable
     */
    set libraries(value: AppEngineStandardAppVersionLibraries[]);
    /**
     * @stability stable
     */
    resetLibraries(): void;
    /**
     * @stability stable
     */
    get librariesInput(): AppEngineStandardAppVersionLibraries[] | undefined;
    private _manualScaling?;
    /**
     * @stability stable
     */
    get manualScaling(): AppEngineStandardAppVersionManualScaling[];
    /**
     * @stability stable
     */
    set manualScaling(value: AppEngineStandardAppVersionManualScaling[]);
    /**
     * @stability stable
     */
    resetManualScaling(): void;
    /**
     * @stability stable
     */
    get manualScalingInput(): AppEngineStandardAppVersionManualScaling[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineStandardAppVersionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: AppEngineStandardAppVersionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineStandardAppVersionTimeouts | undefined;
    private _vpcAccessConnector?;
    /**
     * @stability stable
     */
    get vpcAccessConnector(): AppEngineStandardAppVersionVpcAccessConnector[];
    /**
     * @stability stable
     */
    set vpcAccessConnector(value: AppEngineStandardAppVersionVpcAccessConnector[]);
    /**
     * @stability stable
     */
    resetVpcAccessConnector(): void;
    /**
     * @stability stable
     */
    get vpcAccessConnectorInput(): AppEngineStandardAppVersionVpcAccessConnector[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
