import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryTableIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#dataset_id BigqueryTableIamBinding#dataset_id}.
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#members BigqueryTableIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#project BigqueryTableIamBinding#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#role BigqueryTableIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#table_id BigqueryTableIamBinding#table_id}.
     *
     * @stability stable
     */
    readonly tableId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#condition BigqueryTableIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: BigqueryTableIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface BigqueryTableIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#description BigqueryTableIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#expression BigqueryTableIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html#title BigqueryTableIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html google_bigquery_table_iam_binding}.
 *
 * @stability stable
 */
export declare class BigqueryTableIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_binding.html google_bigquery_table_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryTableIamBindingConfig);
    private _datasetId;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _tableId;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): BigqueryTableIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: BigqueryTableIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): BigqueryTableIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
