import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#autogenerate_revision_name CloudRunService#autogenerate_revision_name}.
     *
     * @stability stable
     */
    readonly autogenerateRevisionName?: boolean;
    /**
     * The location of the cloud run instance. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#location CloudRunService#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#project CloudRunService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     *
     * @stability stable
     */
    readonly metadata?: CloudRunServiceMetadata[];
    /**
     * template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#template CloudRunService#template}
     *
     * @stability stable
     */
    readonly template?: CloudRunServiceTemplate[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeouts CloudRunService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudRunServiceTimeouts;
    /**
     * traffic block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#traffic CloudRunService#traffic}
     *
     * @stability stable
     */
    readonly traffic?: CloudRunServiceTraffic[];
}
/**
 * @stability stable
 */
export declare class CloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class CloudRunServiceStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get conditions(): any;
    /**
     * @stability stable
     */
    get latestCreatedRevisionName(): string;
    /**
     * @stability stable
     */
    get latestReadyRevisionName(): string;
    /**
     * @stability stable
     */
    get observedGeneration(): number;
    /**
     * @stability stable
     */
    get url(): string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
     *
     * - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
     * for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateMetadata {
    /**
     * Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.
     *
     * More
     * info: http://kubernetes.io/docs/user-guide/annotations
     *
     * *Note**: The Cloud Run API may add additional annotations that were not provided in your config.
     * If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
     * or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#annotations CloudRunService#annotations}
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects.
     *
     * May match selectors of replication controllers
     * and routes.
     * More info: http://kubernetes.io/docs/user-guide/labels
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#labels CloudRunService#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Name must be unique within a namespace, within a Cloud Run region.
     *
     * Is required when creating resources. Name is primarily intended
     * for creation idempotence and configuration definition. Cannot be updated.
     * More info: http://kubernetes.io/docs/user-guide/identifiers#names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * In Cloud Run the namespace must be equal to either the project ID or project number.
     *
     * It will default to the resource's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#namespace CloudRunService#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnv {
    /**
     * Name of the environment variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables.
     *
     * If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#value CloudRunService#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
     * Specify whether the ConfigMap must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     *
     * @stability stable
     */
    readonly optional?: boolean;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     *
     * @stability stable
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
     * Specify whether the Secret must be defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#optional CloudRunService#optional}
     *
     * @stability stable
     */
    readonly optional?: boolean;
    /**
     * local_object_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#local_object_reference CloudRunService#local_object_reference}
     *
     * @stability stable
     */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersEnvFrom {
    /**
     * An optional identifier to prepend to each key in the ConfigMap.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#prefix CloudRunService#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * config_map_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#config_map_ref CloudRunService#config_map_ref}
     *
     * @stability stable
     */
    readonly configMapRef?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef[];
    /**
     * secret_ref block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#secret_ref CloudRunService#secret_ref}
     *
     * @stability stable
     */
    readonly secretRef?: CloudRunServiceTemplateSpecContainersEnvFromSecretRef[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersPorts {
    /**
     * Port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_port CloudRunService#container_port}
     *
     * @stability stable
     */
    readonly containerPort: number;
    /**
     * Name of the port.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#name CloudRunService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Protocol used on port. Defaults to TCP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#protocol CloudRunService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainersResources {
    /**
     * Limits describes the maximum amount of compute resources allowed.
     *
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#limits CloudRunService#limits}
     *
     * @stability stable
     */
    readonly limits?: {
        [key: string]: string;
    };
    /**
     * Requests describes the minimum amount of compute resources required.
     *
     * If Requests is omitted for a container, it defaults to Limits if that is
     * explicitly specified, otherwise to an implementation-defined value.
     * The values of the map is string form of the 'quantity' k8s type:
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#requests CloudRunService#requests}
     *
     * @stability stable
     */
    readonly requests?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpecContainers {
    /**
     * Arguments to the entrypoint.
     *
     * The docker image's CMD is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#args CloudRunService#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Entrypoint array.
     *
     * Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * Variable references $(VAR_NAME) are expanded using the container's
     * environment. If a variable cannot be resolved, the reference in the input
     * string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
     * double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
     * regardless of whether the variable exists or not.
     * More info:
     * https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#command CloudRunService#command}
     *
     * @stability stable
     */
    readonly command?: string[];
    /**
     * Docker image name.
     *
     * This is most often a reference to a container located
     * in the container registry, such as gcr.io/cloudrun/hello
     * More info: https://kubernetes.io/docs/concepts/containers/images
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#image CloudRunService#image}
     *
     * @stability stable
     */
    readonly image: string;
    /**
     * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#working_dir CloudRunService#working_dir}
     *
     * @stability stable
     */
    readonly workingDir?: string;
    /**
     * env block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env CloudRunService#env}
     *
     * @stability stable
     */
    readonly env?: CloudRunServiceTemplateSpecContainersEnv[];
    /**
     * env_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#env_from CloudRunService#env_from}
     *
     * @stability stable
     */
    readonly envFrom?: CloudRunServiceTemplateSpecContainersEnvFrom[];
    /**
     * ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#ports CloudRunService#ports}
     *
     * @stability stable
     */
    readonly ports?: CloudRunServiceTemplateSpecContainersPorts[];
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#resources CloudRunService#resources}
     *
     * @stability stable
     */
    readonly resources?: CloudRunServiceTemplateSpecContainersResources[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplateSpec {
    /**
     * ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container of the Revision.
     *
     * Values are:
     * - '0' thread-safe, the system should manage the max concurrency. This is
     * the default value.
     * - '1' not-thread-safe. Single concurrency
     * - '2-N' thread-safe, max concurrency of N
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#container_concurrency CloudRunService#container_concurrency}
     *
     * @stability stable
     */
    readonly containerConcurrency?: number;
    /**
     * Email address of the IAM service account associated with the revision of the service.
     *
     * The service account represents the identity of the running revision,
     * and determines what permissions the revision has. If not provided, the revision
     * will use the project's default service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#service_account_name CloudRunService#service_account_name}
     *
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#timeout_seconds CloudRunService#timeout_seconds}
     *
     * @stability stable
     */
    readonly timeoutSeconds?: number;
    /**
     * containers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#containers CloudRunService#containers}
     *
     * @stability stable
     */
    readonly containers?: CloudRunServiceTemplateSpecContainers[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTemplate {
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#metadata CloudRunService#metadata}
     *
     * @stability stable
     */
    readonly metadata?: CloudRunServiceTemplateMetadata[];
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#spec CloudRunService#spec}
     *
     * @stability stable
     */
    readonly spec?: CloudRunServiceTemplateSpec[];
}
/**
 * @stability stable
 */
export interface CloudRunServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#create CloudRunService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#delete CloudRunService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#update CloudRunService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface CloudRunServiceTraffic {
    /**
     * LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target.
     *
     * When
     * provided LatestRevision must be true if RevisionName is empty; it must be
     * false when RevisionName is non-empty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#latest_revision CloudRunService#latest_revision}
     *
     * @stability stable
     */
    readonly latestRevision?: boolean;
    /**
     * Percent specifies percent of the traffic to this Revision or Configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#percent CloudRunService#percent}
     *
     * @stability stable
     */
    readonly percent: number;
    /**
     * RevisionName of a specific revision to which to send this portion of traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html#revision_name CloudRunService#revision_name}
     *
     * @stability stable
     */
    readonly revisionName?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service}.
 *
 * @stability stable
 */
export declare class CloudRunService extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service.html google_cloud_run_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudRunServiceConfig);
    private _autogenerateRevisionName?;
    /**
     * @stability stable
     */
    get autogenerateRevisionName(): boolean;
    /**
     * @stability stable
     */
    set autogenerateRevisionName(value: boolean);
    /**
     * @stability stable
     */
    resetAutogenerateRevisionName(): void;
    /**
     * @stability stable
     */
    get autogenerateRevisionNameInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): CloudRunServiceStatus;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): CloudRunServiceMetadata[];
    /**
     * @stability stable
     */
    set metadata(value: CloudRunServiceMetadata[]);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): CloudRunServiceMetadata[] | undefined;
    private _template?;
    /**
     * @stability stable
     */
    get template(): CloudRunServiceTemplate[];
    /**
     * @stability stable
     */
    set template(value: CloudRunServiceTemplate[]);
    /**
     * @stability stable
     */
    resetTemplate(): void;
    /**
     * @stability stable
     */
    get templateInput(): CloudRunServiceTemplate[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): CloudRunServiceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: CloudRunServiceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudRunServiceTimeouts | undefined;
    private _traffic?;
    /**
     * @stability stable
     */
    get traffic(): CloudRunServiceTraffic[];
    /**
     * @stability stable
     */
    set traffic(value: CloudRunServiceTraffic[]);
    /**
     * @stability stable
     */
    resetTraffic(): void;
    /**
     * @stability stable
     */
    get trafficInput(): CloudRunServiceTraffic[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
