import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#bucket_name ComputeBackendBucket#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * An optional textual description of the resource; provided by the client when the resource is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#description ComputeBackendBucket#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this BackendBucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#enable_cdn ComputeBackendBucket#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#name ComputeBackendBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#project ComputeBackendBucket#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#cdn_policy ComputeBackendBucket#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeBackendBucketCdnPolicy[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#timeouts ComputeBackendBucket#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendBucketTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendBucketCdnPolicy {
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh.
     *
     * After this time period,
     * the response will be revalidated before being served.
     * When serving responses to signed URL requests,
     * Cloud CDN will internally behave as though
     * all responses from this backend had a "Cache-Control: public,
     * max-age=[TTL]" header, regardless of any existing Cache-Control
     * header. The actual headers served in responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#signed_url_cache_max_age_sec ComputeBackendBucket#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendBucketTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#create ComputeBackendBucket#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#delete ComputeBackendBucket#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html#update ComputeBackendBucket#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html google_compute_backend_bucket}.
 *
 * @stability stable
 */
export declare class ComputeBackendBucket extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket.html google_compute_backend_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendBucketConfig);
    private _bucketName;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _cdnPolicy?;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeBackendBucketCdnPolicy[];
    /**
     * @stability stable
     */
    set cdnPolicy(value: ComputeBackendBucketCdnPolicy[]);
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeBackendBucketCdnPolicy[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendBucketTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeBackendBucketTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
