import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE.
     *
     * If set to 0, the cookie is non-persistent and lasts
     * only until the end of the browser session (or equivalent). The
     * maximum allowed value for TTL is one day.
     *
     * When the load balancing scheme is INTERNAL, this field is not used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#affinity_cookie_ttl_sec ComputeBackendService#affinity_cookie_ttl_sec}
     *
     * @stability stable
     */
    readonly affinityCookieTtlSec?: number;
    /**
     * Time for which instance will be drained (not accept new connections, but still work to finish started).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#connection_draining_timeout_sec ComputeBackendService#connection_draining_timeout_sec}
     *
     * @stability stable
     */
    readonly connectionDrainingTimeoutSec?: number;
    /**
     * Headers that the HTTP/S load balancer should add to proxied requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#custom_request_headers ComputeBackendService#custom_request_headers}
     *
     * @stability stable
     */
    readonly customRequestHeaders?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#description ComputeBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this BackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enable_cdn ComputeBackendService#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean;
    /**
     * The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this BackendService.
     *
     * Currently at most one health
     * check can be specified.
     *
     * A health check must be specified unless the backend service uses an internet
     * or serverless NEG as a backend.
     *
     * For internal load balancing, a URL to a HealthCheck resource must be specified instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#health_checks ComputeBackendService#health_checks}
     *
     * @stability stable
     */
    readonly healthChecks?: string[];
    /**
     * Indicates whether the backend service will be used with internal or external load balancing.
     *
     * A backend service created for one type of
     * load balancing cannot be used with the other. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL_SELF_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#load_balancing_scheme ComputeBackendService#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are -.
     *
     * ROUND_ROBIN - This is a simple policy in which each healthy backend
     *              is selected in round robin order.
     *
     * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
     *                hosts and picks the host which has fewer active requests.
     *
     * RING_HASH - The ring/modulo hash load balancer implements consistent
     *            hashing to backends. The algorithm has the property that the
     *            addition/removal of a host from a set of N hosts only affects
     *            1/N of the requests.
     *
     * RANDOM - The load balancer selects a random healthy host.
     *
     * ORIGINAL_DESTINATION - Backend host is selected based on the client
     *                       connection metadata, i.e., connections are opened
     *                       to the same address as the destination address of
     *                       the incoming connection before the connection
     *                       was redirected to the load balancer.
     *
     * MAGLEV - used as a drop in replacement for the ring hash load balancer.
     *         Maglev is not as stable as ring hash but has faster table lookup
     *         build times and host selection times. For more information about
     *         Maglev, refer to https://ai.google/research/pubs/pub44824
     *
     * This field is applicable only when the load_balancing_scheme is set to
     * INTERNAL_SELF_MANAGED. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#locality_lb_policy ComputeBackendService#locality_lb_policy}
     *
     * @stability stable
     */
    readonly localityLbPolicy?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#name ComputeBackendService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of backend port.
     *
     * The same name should appear in the instance
     * groups referenced by this service. Required when the load balancing
     * scheme is EXTERNAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#port_name ComputeBackendService#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#project ComputeBackendService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The protocol this BackendService uses to communicate with backends.
     *
     * The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
     * types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "TCP", "SSL", "GRPC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#protocol ComputeBackendService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * The security policy associated with this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#security_policy ComputeBackendService#security_policy}
     *
     * @stability stable
     */
    readonly securityPolicy?: string;
    /**
     * Type of session affinity to use.
     *
     * The default is NONE. Session affinity is
     * not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#session_affinity ComputeBackendService#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: string;
    /**
     * How many seconds to wait for the backend before considering it a failed request.
     *
     * Default is 30 seconds. Valid range is [1, 86400].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#timeout_sec ComputeBackendService#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * backend block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#backend ComputeBackendService#backend}
     *
     * @stability stable
     */
    readonly backend?: ComputeBackendServiceBackend[];
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#cdn_policy ComputeBackendService#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeBackendServiceCdnPolicy[];
    /**
     * circuit_breakers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#circuit_breakers ComputeBackendService#circuit_breakers}
     *
     * @stability stable
     */
    readonly circuitBreakers?: ComputeBackendServiceCircuitBreakers[];
    /**
     * consistent_hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consistent_hash ComputeBackendService#consistent_hash}
     *
     * @stability stable
     */
    readonly consistentHash?: ComputeBackendServiceConsistentHash[];
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#iap ComputeBackendService#iap}
     *
     * @stability stable
     */
    readonly iap?: ComputeBackendServiceIap[];
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#log_config ComputeBackendService#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeBackendServiceLogConfig[];
    /**
     * outlier_detection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#outlier_detection ComputeBackendService#outlier_detection}
     *
     * @stability stable
     */
    readonly outlierDetection?: ComputeBackendServiceOutlierDetection[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#timeouts ComputeBackendService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceBackend {
    /**
     * Specifies the balancing mode for this backend.
     *
     * For global HTTP(S) or TCP/SSL load balancing, the default is
     * UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S))
     * and CONNECTION (for TCP/SSL). Default value: "UTILIZATION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#balancing_mode ComputeBackendService#balancing_mode}
     *
     * @stability stable
     */
    readonly balancingMode?: string;
    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
     *
     * Default value is 1, which means the group will serve up to 100%
     * of its configured capacity (depending on balancingMode). A
     * setting of 0 means the group is completely drained, offering
     * 0% of its available Capacity. Valid range is [0.0,1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#capacity_scaler ComputeBackendService#capacity_scaler}
     *
     * @stability stable
     */
    readonly capacityScaler?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#description ComputeBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
     *
     * In case of instance group this defines the list
     * of instances that serve traffic. Member virtual machine
     * instances from each instance group must live in the same zone as
     * the instance group itself. No two backends in a backend service
     * are allowed to use same Instance Group resource.
     *
     * For Network Endpoint Groups this defines list of endpoints. All
     * endpoints of Network Endpoint Group must be hosted on instances
     * located in the same zone as the Network Endpoint Group.
     *
     * Backend services cannot mix Instance Group and
     * Network Endpoint Group backends.
     *
     * Note that you must specify an Instance Group or Network Endpoint
     * Group resource using the fully-qualified URL, rather than a
     * partial URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#group ComputeBackendService#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * The max number of simultaneous connections for the group. Can be used with either CONNECTION or UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either maxConnections or one
     * of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
     * as appropriate for group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections ComputeBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The max number of simultaneous connections that a single backend network endpoint can handle.
     *
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either
     * maxConnections or maxConnectionsPerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections_per_endpoint ComputeBackendService#max_connections_per_endpoint}
     *
     * @stability stable
     */
    readonly maxConnectionsPerEndpoint?: number;
    /**
     * The max number of simultaneous connections that a single backend instance can handle.
     *
     * This is used to calculate the
     * capacity of the group. Can be used in either CONNECTION or
     * UTILIZATION balancing modes.
     *
     * For CONNECTION mode, either maxConnections or
     * maxConnectionsPerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections_per_instance ComputeBackendService#max_connections_per_instance}
     *
     * @stability stable
     */
    readonly maxConnectionsPerInstance?: number;
    /**
     * The max requests per second (RPS) of the group.
     *
     * Can be used with either RATE or UTILIZATION balancing modes,
     * but required if RATE mode. For RATE mode, either maxRate or one
     * of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
     * group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate ComputeBackendService#max_rate}
     *
     * @stability stable
     */
    readonly maxRate?: number;
    /**
     * The max requests per second (RPS) that a single backend network endpoint can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate_per_endpoint ComputeBackendService#max_rate_per_endpoint}
     *
     * @stability stable
     */
    readonly maxRatePerEndpoint?: number;
    /**
     * The max requests per second (RPS) that a single backend instance can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_rate_per_instance ComputeBackendService#max_rate_per_instance}
     *
     * @stability stable
     */
    readonly maxRatePerInstance?: number;
    /**
     * Used when balancingMode is UTILIZATION.
     *
     * This ratio defines the
     * CPU utilization target for the group. The default is 0.8. Valid
     * range is [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_utilization ComputeBackendService#max_utilization}
     *
     * @stability stable
     */
    readonly maxUtilization?: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceCdnPolicyCacheKeyPolicy {
    /**
     * If true requests to different hosts will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_host ComputeBackendService#include_host}
     *
     * @stability stable
     */
    readonly includeHost?: boolean;
    /**
     * If true, http and https requests will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_protocol ComputeBackendService#include_protocol}
     *
     * @stability stable
     */
    readonly includeProtocol?: boolean;
    /**
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist.
     *
     * If neither is set, the entire query
     * string will be included.
     *
     * If false, the query string will be excluded from the cache
     * key entirely.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#include_query_string ComputeBackendService#include_query_string}
     *
     * @stability stable
     */
    readonly includeQueryString?: boolean;
    /**
     * Names of query string parameters to exclude in cache keys.
     *
     * All other parameters will be included. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#query_string_blacklist ComputeBackendService#query_string_blacklist}
     *
     * @stability stable
     */
    readonly queryStringBlacklist?: string[];
    /**
     * Names of query string parameters to include in cache keys.
     *
     * All other parameters will be excluded. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#query_string_whitelist ComputeBackendService#query_string_whitelist}
     *
     * @stability stable
     */
    readonly queryStringWhitelist?: string[];
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceCdnPolicy {
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh, defaults to 1hr (3600s).
     *
     * After this
     * time period, the response will be revalidated before
     * being served.
     *
     * When serving responses to signed URL requests, Cloud CDN will
     * internally behave as though all responses from this backend had a
     * "Cache-Control: public, max-age=[TTL]" header, regardless of any
     * existing Cache-Control header. The actual headers served in
     * responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#signed_url_cache_max_age_sec ComputeBackendService#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
     * cache_key_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#cache_key_policy ComputeBackendService#cache_key_policy}
     *
     * @stability stable
     */
    readonly cacheKeyPolicy?: ComputeBackendServiceCdnPolicyCacheKeyPolicy[];
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceCircuitBreakers {
    /**
     * The maximum number of connections to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_connections ComputeBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The maximum number of pending requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_pending_requests ComputeBackendService#max_pending_requests}
     *
     * @stability stable
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum number of parallel requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_requests ComputeBackendService#max_requests}
     *
     * @stability stable
     */
    readonly maxRequests?: number;
    /**
     * Maximum requests for a single backend connection.
     *
     * This parameter
     * is respected by both the HTTP/1.1 and HTTP/2 implementations. If
     * not specified, there is no limit. Setting this parameter to 1
     * will effectively disable keep alive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_requests_per_connection ComputeBackendService#max_requests_per_connection}
     *
     * @stability stable
     */
    readonly maxRequestsPerConnection?: number;
    /**
     * The maximum number of parallel retries to the backend cluster. Defaults to 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_retries ComputeBackendService#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHashHttpCookieTtl {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must
     * be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHashHttpCookie {
    /**
     * Name of the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#name ComputeBackendService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Path to set for the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#path ComputeBackendService#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * ttl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#ttl ComputeBackendService#ttl}
     *
     * @stability stable
     */
    readonly ttl?: ComputeBackendServiceConsistentHashHttpCookieTtl[];
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceConsistentHash {
    /**
     * The hash based on the value of the specified header field.
     *
     * This field is applicable if the sessionAffinity is set to HEADER_FIELD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#http_header_name ComputeBackendService#http_header_name}
     *
     * @stability stable
     */
    readonly httpHeaderName?: string;
    /**
     * The minimum number of virtual nodes to use for the hash ring.
     *
     * Larger ring sizes result in more granular load
     * distributions. If the number of hosts in the load balancing pool
     * is larger than the ring size, each host will be assigned a single
     * virtual node.
     * Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#minimum_ring_size ComputeBackendService#minimum_ring_size}
     *
     * @stability stable
     */
    readonly minimumRingSize?: number;
    /**
     * http_cookie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#http_cookie ComputeBackendService#http_cookie}
     *
     * @stability stable
     */
    readonly httpCookie?: ComputeBackendServiceConsistentHashHttpCookie[];
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceIap {
    /**
     * OAuth2 Client ID for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#oauth2_client_id ComputeBackendService#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 Client Secret for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#oauth2_client_secret ComputeBackendService#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceLogConfig {
    /**
     * Whether to enable logging for the load balancer traffic served by this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enable ComputeBackendService#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean;
    /**
     * This field can only be specified if logging is enabled for this backend service.
     *
     * The value of
     * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
     * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
     * The default value is 1.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#sample_rate ComputeBackendService#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetectionBaseEjectionTime {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetectionInterval {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#nanos ComputeBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#seconds ComputeBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceOutlierDetection {
    /**
     * Number of errors before a host is ejected from the connection pool.
     *
     * When the
     * backend host is accessed over HTTP, a 5xx return code qualifies as an error.
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consecutive_errors ComputeBackendService#consecutive_errors}
     *
     * @stability stable
     */
    readonly consecutiveErrors?: number;
    /**
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs.
     *
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#consecutive_gateway_failure ComputeBackendService#consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly consecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx.
     *
     * This setting can be used to disable
     * ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_consecutive_errors ComputeBackendService#enforcing_consecutive_errors}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveErrors?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures.
     *
     * This setting can be
     * used to disable ejection or to ramp it up slowly. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_consecutive_gateway_failure ComputeBackendService#enforcing_consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics.
     *
     * This setting can be used to
     * disable ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#enforcing_success_rate ComputeBackendService#enforcing_success_rate}
     *
     * @stability stable
     */
    readonly enforcingSuccessRate?: number;
    /**
     * Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 10%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#max_ejection_percent ComputeBackendService#max_ejection_percent}
     *
     * @stability stable
     */
    readonly maxEjectionPercent?: number;
    /**
     * The number of hosts in a cluster that must have enough request volume to detect success rate outliers.
     *
     * If the number of hosts is less than this setting, outlier
     * detection via success rate statistics is not performed for any host in the
     * cluster. Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_minimum_hosts ComputeBackendService#success_rate_minimum_hosts}
     *
     * @stability stable
     */
    readonly successRateMinimumHosts?: number;
    /**
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection.
     *
     * If the volume is lower than this setting, outlier
     * detection via success rate statistics is not performed for that host. Defaults
     * to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_request_volume ComputeBackendService#success_rate_request_volume}
     *
     * @stability stable
     */
    readonly successRateRequestVolume?: number;
    /**
     * This factor is used to determine the ejection threshold for success rate outlier ejection.
     *
     * The ejection threshold is the difference between the mean success
     * rate, and the product of this factor and the standard deviation of the mean
     * success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
     * by a thousand to get a double. That is, if the desired factor is 1.9, the
     * runtime value should be 1900. Defaults to 1900.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#success_rate_stdev_factor ComputeBackendService#success_rate_stdev_factor}
     *
     * @stability stable
     */
    readonly successRateStdevFactor?: number;
    /**
     * base_ejection_time block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#base_ejection_time ComputeBackendService#base_ejection_time}
     *
     * @stability stable
     */
    readonly baseEjectionTime?: ComputeBackendServiceOutlierDetectionBaseEjectionTime[];
    /**
     * interval block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#interval ComputeBackendService#interval}
     *
     * @stability stable
     */
    readonly interval?: ComputeBackendServiceOutlierDetectionInterval[];
}
/**
 * @stability stable
 */
export interface ComputeBackendServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#create ComputeBackendService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#delete ComputeBackendService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html#update ComputeBackendService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html google_compute_backend_service}.
 *
 * @stability stable
 */
export declare class ComputeBackendService extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service.html google_compute_backend_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendServiceConfig);
    private _affinityCookieTtlSec?;
    /**
     * @stability stable
     */
    get affinityCookieTtlSec(): number;
    /**
     * @stability stable
     */
    set affinityCookieTtlSec(value: number);
    /**
     * @stability stable
     */
    resetAffinityCookieTtlSec(): void;
    /**
     * @stability stable
     */
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSec(): number;
    /**
     * @stability stable
     */
    set connectionDrainingTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetConnectionDrainingTimeoutSec(): void;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _customRequestHeaders?;
    /**
     * @stability stable
     */
    get customRequestHeaders(): string[];
    /**
     * @stability stable
     */
    set customRequestHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetCustomRequestHeaders(): void;
    /**
     * @stability stable
     */
    get customRequestHeadersInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    private _healthChecks?;
    /**
     * @stability stable
     */
    get healthChecks(): string[];
    /**
     * @stability stable
     */
    set healthChecks(value: string[]);
    /**
     * @stability stable
     */
    resetHealthChecks(): void;
    /**
     * @stability stable
     */
    get healthChecksInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    /**
     * @stability stable
     */
    get localityLbPolicy(): string;
    /**
     * @stability stable
     */
    set localityLbPolicy(value: string);
    /**
     * @stability stable
     */
    resetLocalityLbPolicy(): void;
    /**
     * @stability stable
     */
    get localityLbPolicyInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _securityPolicy?;
    /**
     * @stability stable
     */
    get securityPolicy(): string;
    /**
     * @stability stable
     */
    set securityPolicy(value: string);
    /**
     * @stability stable
     */
    resetSecurityPolicy(): void;
    /**
     * @stability stable
     */
    get securityPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): string;
    /**
     * @stability stable
     */
    set sessionAffinity(value: string);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    set timeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    private _backend?;
    /**
     * @stability stable
     */
    get backend(): ComputeBackendServiceBackend[];
    /**
     * @stability stable
     */
    set backend(value: ComputeBackendServiceBackend[]);
    /**
     * @stability stable
     */
    resetBackend(): void;
    /**
     * @stability stable
     */
    get backendInput(): ComputeBackendServiceBackend[] | undefined;
    private _cdnPolicy?;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeBackendServiceCdnPolicy[];
    /**
     * @stability stable
     */
    set cdnPolicy(value: ComputeBackendServiceCdnPolicy[]);
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeBackendServiceCdnPolicy[] | undefined;
    private _circuitBreakers?;
    /**
     * @stability stable
     */
    get circuitBreakers(): ComputeBackendServiceCircuitBreakers[];
    /**
     * @stability stable
     */
    set circuitBreakers(value: ComputeBackendServiceCircuitBreakers[]);
    /**
     * @stability stable
     */
    resetCircuitBreakers(): void;
    /**
     * @stability stable
     */
    get circuitBreakersInput(): ComputeBackendServiceCircuitBreakers[] | undefined;
    private _consistentHash?;
    /**
     * @stability stable
     */
    get consistentHash(): ComputeBackendServiceConsistentHash[];
    /**
     * @stability stable
     */
    set consistentHash(value: ComputeBackendServiceConsistentHash[]);
    /**
     * @stability stable
     */
    resetConsistentHash(): void;
    /**
     * @stability stable
     */
    get consistentHashInput(): ComputeBackendServiceConsistentHash[] | undefined;
    private _iap?;
    /**
     * @stability stable
     */
    get iap(): ComputeBackendServiceIap[];
    /**
     * @stability stable
     */
    set iap(value: ComputeBackendServiceIap[]);
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): ComputeBackendServiceIap[] | undefined;
    private _logConfig?;
    /**
     * @stability stable
     */
    get logConfig(): ComputeBackendServiceLogConfig[];
    /**
     * @stability stable
     */
    set logConfig(value: ComputeBackendServiceLogConfig[]);
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeBackendServiceLogConfig[] | undefined;
    private _outlierDetection?;
    /**
     * @stability stable
     */
    get outlierDetection(): ComputeBackendServiceOutlierDetection[];
    /**
     * @stability stable
     */
    set outlierDetection(value: ComputeBackendServiceOutlierDetection[]);
    /**
     * @stability stable
     */
    resetOutlierDetection(): void;
    /**
     * @stability stable
     */
    get outlierDetectionInput(): ComputeBackendServiceOutlierDetection[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendServiceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeBackendServiceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
