import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeDiskResourcePolicyAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the disk in which the resource policies are attached to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#disk ComputeDiskResourcePolicyAttachment#disk}
     *
     * @stability stable
     */
    readonly disk: string;
    /**
     * The resource policy to be attached to the disk for scheduling snapshot creation. Do not specify the self link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#name ComputeDiskResourcePolicyAttachment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#project ComputeDiskResourcePolicyAttachment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A reference to the zone where the disk resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#zone ComputeDiskResourcePolicyAttachment#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#timeouts ComputeDiskResourcePolicyAttachment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeDiskResourcePolicyAttachmentTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeDiskResourcePolicyAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#create ComputeDiskResourcePolicyAttachment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html#delete ComputeDiskResourcePolicyAttachment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html google_compute_disk_resource_policy_attachment}.
 *
 * @stability stable
 */
export declare class ComputeDiskResourcePolicyAttachment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_disk_resource_policy_attachment.html google_compute_disk_resource_policy_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeDiskResourcePolicyAttachmentConfig);
    private _disk;
    /**
     * @stability stable
     */
    get disk(): string;
    /**
     * @stability stable
     */
    set disk(value: string);
    /**
     * @stability stable
     */
    get diskInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeDiskResourcePolicyAttachmentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeDiskResourcePolicyAttachmentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeDiskResourcePolicyAttachmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
