import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeGlobalNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * The default port used if the port number is not specified in the network endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#default_port ComputeGlobalNetworkEndpointGroup#default_port}
     *
     * @stability stable
     */
    readonly defaultPort?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#description ComputeGlobalNetworkEndpointGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#name ComputeGlobalNetworkEndpointGroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Type of network endpoints in this network endpoint group. Possible values: ["INTERNET_IP_PORT", "INTERNET_FQDN_PORT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#network_endpoint_type ComputeGlobalNetworkEndpointGroup#network_endpoint_type}
     *
     * @stability stable
     */
    readonly networkEndpointType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#project ComputeGlobalNetworkEndpointGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#timeouts ComputeGlobalNetworkEndpointGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeGlobalNetworkEndpointGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeGlobalNetworkEndpointGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#create ComputeGlobalNetworkEndpointGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html#delete ComputeGlobalNetworkEndpointGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html google_compute_global_network_endpoint_group}.
 *
 * @stability stable
 */
export declare class ComputeGlobalNetworkEndpointGroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint_group.html google_compute_global_network_endpoint_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalNetworkEndpointGroupConfig);
    private _defaultPort?;
    /**
     * @stability stable
     */
    get defaultPort(): number;
    /**
     * @stability stable
     */
    set defaultPort(value: number);
    /**
     * @stability stable
     */
    resetDefaultPort(): void;
    /**
     * @stability stable
     */
    get defaultPortInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _networkEndpointType;
    /**
     * @stability stable
     */
    get networkEndpointType(): string;
    /**
     * @stability stable
     */
    set networkEndpointType(value: string);
    /**
     * @stability stable
     */
    get networkEndpointTypeInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeGlobalNetworkEndpointGroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeGlobalNetworkEndpointGroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeGlobalNetworkEndpointGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
