import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeImageIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#image ComputeImageIamBinding#image}.
     *
     * @stability stable
     */
    readonly image: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#members ComputeImageIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#project ComputeImageIamBinding#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#role ComputeImageIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#condition ComputeImageIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: ComputeImageIamBindingCondition[];
}
/**
 * @stability stable
 */
export interface ComputeImageIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#description ComputeImageIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#expression ComputeImageIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html#title ComputeImageIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html google_compute_image_iam_binding}.
 *
 * @stability stable
 */
export declare class ComputeImageIamBinding extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding.html google_compute_image_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeImageIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _image;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    get imageInput(): string;
    private _members;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): ComputeImageIamBindingCondition[];
    /**
     * @stability stable
     */
    set condition(value: ComputeImageIamBindingCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): ComputeImageIamBindingCondition[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
