import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#description ComputeImage#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Size of the image when restored onto a persistent disk (in GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#disk_size_gb ComputeImage#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * The name of the image family to which this image belongs.
     *
     * You can
     * create disks by specifying an image family instead of a specific
     * image name. The image family always returns its latest image that is
     * not deprecated. The name of the image family must comply with
     * RFC1035.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#family ComputeImage#family}
     *
     * @stability stable
     */
    readonly family?: string;
    /**
     * Labels to apply to this Image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#labels ComputeImage#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Any applicable license URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#licenses ComputeImage#licenses}
     *
     * @stability stable
     */
    readonly licenses?: string[];
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#name ComputeImage#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#project ComputeImage#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The source disk to create this image based on.
     *
     * You must provide either this property or the
     * rawDisk.source property but not both to create an image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#source_disk ComputeImage#source_disk}
     *
     * @stability stable
     */
    readonly sourceDisk?: string;
    /**
     * URL of the source image used to create this image.
     *
     * In order to create an image, you must provide the full or partial
     * URL of one of the following:
     *
     * The selfLink URL
     * This property
     * The rawDisk.source URL
     * The sourceDisk URL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#source_image ComputeImage#source_image}
     *
     * @stability stable
     */
    readonly sourceImage?: string;
    /**
     * URL of the source snapshot used to create this image.
     *
     * In order to create an image, you must provide the full or partial URL of one of the following:
     *
     * The selfLink URL
     * This property
     * The sourceImage URL
     * The rawDisk.source URL
     * The sourceDisk URL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#source_snapshot ComputeImage#source_snapshot}
     *
     * @stability stable
     */
    readonly sourceSnapshot?: string;
    /**
     * guest_os_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#guest_os_features ComputeImage#guest_os_features}
     *
     * @stability stable
     */
    readonly guestOsFeatures?: ComputeImageGuestOsFeatures[];
    /**
     * raw_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#raw_disk ComputeImage#raw_disk}
     *
     * @stability stable
     */
    readonly rawDisk?: ComputeImageRawDisk[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#timeouts ComputeImage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeImageTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeImageGuestOsFeatures {
    /**
     * The type of supported feature.
     *
     * Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Possible values: ["MULTI_IP_SUBNET", "SECURE_BOOT", "SEV_CAPABLE", "UEFI_COMPATIBLE", "VIRTIO_SCSI_MULTIQUEUE", "WINDOWS", "GVNIC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#type ComputeImage#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface ComputeImageRawDisk {
    /**
     * The format used to encode and transmit the block device, which should be TAR.
     *
     * This is just a container and transmission format
     * and not a runtime format. Provided by the client when the disk
     * image is created. Default value: "TAR" Possible values: ["TAR"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#container_type ComputeImage#container_type}
     *
     * @stability stable
     */
    readonly containerType?: string;
    /**
     * An optional SHA1 checksum of the disk image before unpackaging.
     *
     * This is provided by the client when the disk image is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#sha1 ComputeImage#sha1}
     *
     * @stability stable
     */
    readonly sha1?: string;
    /**
     * The full Google Cloud Storage URL where disk storage is stored You must provide either this property or the sourceDisk property but not both.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#source ComputeImage#source}
     *
     * @stability stable
     */
    readonly source: string;
}
/**
 * @stability stable
 */
export interface ComputeImageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#create ComputeImage#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#delete ComputeImage#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image.html#update ComputeImage#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_image.html google_compute_image}.
 *
 * @stability stable
 */
export declare class ComputeImage extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_image.html google_compute_image} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeImageConfig);
    /**
     * @stability stable
     */
    get archiveSizeBytes(): number;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _family?;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    set family(value: string);
    /**
     * @stability stable
     */
    resetFamily(): void;
    /**
     * @stability stable
     */
    get familyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _licenses?;
    /**
     * @stability stable
     */
    get licenses(): string[];
    /**
     * @stability stable
     */
    set licenses(value: string[]);
    /**
     * @stability stable
     */
    resetLicenses(): void;
    /**
     * @stability stable
     */
    get licensesInput(): string[] | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sourceDisk?;
    /**
     * @stability stable
     */
    get sourceDisk(): string;
    /**
     * @stability stable
     */
    set sourceDisk(value: string);
    /**
     * @stability stable
     */
    resetSourceDisk(): void;
    /**
     * @stability stable
     */
    get sourceDiskInput(): string | undefined;
    private _sourceImage?;
    /**
     * @stability stable
     */
    get sourceImage(): string;
    /**
     * @stability stable
     */
    set sourceImage(value: string);
    /**
     * @stability stable
     */
    resetSourceImage(): void;
    /**
     * @stability stable
     */
    get sourceImageInput(): string | undefined;
    private _sourceSnapshot?;
    /**
     * @stability stable
     */
    get sourceSnapshot(): string;
    /**
     * @stability stable
     */
    set sourceSnapshot(value: string);
    /**
     * @stability stable
     */
    resetSourceSnapshot(): void;
    /**
     * @stability stable
     */
    get sourceSnapshotInput(): string | undefined;
    private _guestOsFeatures?;
    /**
     * @stability stable
     */
    get guestOsFeatures(): ComputeImageGuestOsFeatures[];
    /**
     * @stability stable
     */
    set guestOsFeatures(value: ComputeImageGuestOsFeatures[]);
    /**
     * @stability stable
     */
    resetGuestOsFeatures(): void;
    /**
     * @stability stable
     */
    get guestOsFeaturesInput(): ComputeImageGuestOsFeatures[] | undefined;
    private _rawDisk?;
    /**
     * @stability stable
     */
    get rawDisk(): ComputeImageRawDisk[];
    /**
     * @stability stable
     */
    set rawDisk(value: ComputeImageRawDisk[]);
    /**
     * @stability stable
     */
    resetRawDisk(): void;
    /**
     * @stability stable
     */
    get rawDiskInput(): ComputeImageRawDisk[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeImageTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeImageTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeImageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
