import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional textual description of the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#description ComputeInstanceGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * List of instances in the group.
     *
     * They should be given as self_link URLs. When adding instances they must all be in the same network and zone as the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#instances ComputeInstanceGroup#instances}
     *
     * @stability stable
     */
    readonly instances?: string[];
    /**
     * The name of the instance group.
     *
     * Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#name ComputeInstanceGroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The URL of the network the instance group is in.
     *
     * If this is different from the network where the instances are in, the creation fails. Defaults to the network where the instances are in (if neither network nor instances is specified, this field will be blank).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#network ComputeInstanceGroup#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#project ComputeInstanceGroup#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The zone that this instance group should be created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#zone ComputeInstanceGroup#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * named_port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#named_port ComputeInstanceGroup#named_port}
     *
     * @stability stable
     */
    readonly namedPort?: ComputeInstanceGroupNamedPort[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#timeouts ComputeInstanceGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupNamedPort {
    /**
     * The name which the port will be mapped to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#name ComputeInstanceGroup#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The port number to map the name to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#port ComputeInstanceGroup#port}
     *
     * @stability stable
     */
    readonly port: number;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#create ComputeInstanceGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#delete ComputeInstanceGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#update ComputeInstanceGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html google_compute_instance_group}.
 *
 * @stability stable
 */
export declare class ComputeInstanceGroup extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html google_compute_instance_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceGroupConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): string[];
    /**
     * @stability stable
     */
    set instances(value: string[]);
    /**
     * @stability stable
     */
    resetInstances(): void;
    /**
     * @stability stable
     */
    get instancesInput(): string[] | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get size(): number;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _namedPort?;
    /**
     * @stability stable
     */
    get namedPort(): ComputeInstanceGroupNamedPort[];
    /**
     * @stability stable
     */
    set namedPort(value: ComputeInstanceGroupNamedPort[]);
    /**
     * @stability stable
     */
    resetNamedPort(): void;
    /**
     * @stability stable
     */
    get namedPortInput(): ComputeInstanceGroupNamedPort[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceGroupTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeInstanceGroupTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
