import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringRoutesConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#export_custom_routes ComputeNetworkPeeringRoutesConfig#export_custom_routes}
     *
     * @stability stable
     */
    readonly exportCustomRoutes: boolean;
    /**
     * Whether to import the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#import_custom_routes ComputeNetworkPeeringRoutesConfig#import_custom_routes}
     *
     * @stability stable
     */
    readonly importCustomRoutes: boolean;
    /**
     * The name of the primary network for the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#network ComputeNetworkPeeringRoutesConfig#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#peering ComputeNetworkPeeringRoutesConfig#peering}
     *
     * @stability stable
     */
    readonly peering: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#project ComputeNetworkPeeringRoutesConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#timeouts ComputeNetworkPeeringRoutesConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkPeeringRoutesConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringRoutesConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#create ComputeNetworkPeeringRoutesConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#delete ComputeNetworkPeeringRoutesConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#update ComputeNetworkPeeringRoutesConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html google_compute_network_peering_routes_config}.
 *
 * @stability stable
 */
export declare class ComputeNetworkPeeringRoutesConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html google_compute_network_peering_routes_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringRoutesConfigConfig);
    private _exportCustomRoutes;
    /**
     * @stability stable
     */
    get exportCustomRoutes(): boolean;
    /**
     * @stability stable
     */
    set exportCustomRoutes(value: boolean);
    /**
     * @stability stable
     */
    get exportCustomRoutesInput(): boolean;
    /**
     * @stability stable
     */
    get id(): string;
    private _importCustomRoutes;
    /**
     * @stability stable
     */
    get importCustomRoutes(): boolean;
    /**
     * @stability stable
     */
    set importCustomRoutes(value: boolean);
    /**
     * @stability stable
     */
    get importCustomRoutesInput(): boolean;
    private _network;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string;
    private _peering;
    /**
     * @stability stable
     */
    get peering(): string;
    /**
     * @stability stable
     */
    set peering(value: string);
    /**
     * @stability stable
     */
    get peeringInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkPeeringRoutesConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeNetworkPeeringRoutesConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
