import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_custom_routes ComputeNetworkPeering#export_custom_routes}
     *
     * @stability stable
     */
    readonly exportCustomRoutes?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_subnet_routes_with_public_ip ComputeNetworkPeering#export_subnet_routes_with_public_ip}.
     *
     * @stability stable
     */
    readonly exportSubnetRoutesWithPublicIp?: boolean;
    /**
     * Whether to export the custom routes from the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_custom_routes ComputeNetworkPeering#import_custom_routes}
     *
     * @stability stable
     */
    readonly importCustomRoutes?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_subnet_routes_with_public_ip ComputeNetworkPeering#import_subnet_routes_with_public_ip}.
     *
     * @stability stable
     */
    readonly importSubnetRoutesWithPublicIp?: boolean;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#name ComputeNetworkPeering#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The primary network of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#network ComputeNetworkPeering#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * The peer network in the peering. The peer network may belong to a different project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#peer_network ComputeNetworkPeering#peer_network}
     *
     * @stability stable
     */
    readonly peerNetwork: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#timeouts ComputeNetworkPeering#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkPeeringTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#create ComputeNetworkPeering#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#delete ComputeNetworkPeering#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#update ComputeNetworkPeering#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering}.
 *
 * @stability stable
 */
export declare class ComputeNetworkPeering extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringConfig);
    private _exportCustomRoutes?;
    /**
     * @stability stable
     */
    get exportCustomRoutes(): boolean;
    /**
     * @stability stable
     */
    set exportCustomRoutes(value: boolean);
    /**
     * @stability stable
     */
    resetExportCustomRoutes(): void;
    /**
     * @stability stable
     */
    get exportCustomRoutesInput(): boolean | undefined;
    private _exportSubnetRoutesWithPublicIp?;
    /**
     * @stability stable
     */
    get exportSubnetRoutesWithPublicIp(): boolean;
    /**
     * @stability stable
     */
    set exportSubnetRoutesWithPublicIp(value: boolean);
    /**
     * @stability stable
     */
    resetExportSubnetRoutesWithPublicIp(): void;
    /**
     * @stability stable
     */
    get exportSubnetRoutesWithPublicIpInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _importCustomRoutes?;
    /**
     * @stability stable
     */
    get importCustomRoutes(): boolean;
    /**
     * @stability stable
     */
    set importCustomRoutes(value: boolean);
    /**
     * @stability stable
     */
    resetImportCustomRoutes(): void;
    /**
     * @stability stable
     */
    get importCustomRoutesInput(): boolean | undefined;
    private _importSubnetRoutesWithPublicIp?;
    /**
     * @stability stable
     */
    get importSubnetRoutesWithPublicIp(): boolean;
    /**
     * @stability stable
     */
    set importSubnetRoutesWithPublicIp(value: boolean);
    /**
     * @stability stable
     */
    resetImportSubnetRoutesWithPublicIp(): void;
    /**
     * @stability stable
     */
    get importSubnetRoutesWithPublicIpInput(): boolean | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string;
    private _peerNetwork;
    /**
     * @stability stable
     */
    get peerNetwork(): string;
    /**
     * @stability stable
     */
    set peerNetwork(value: string);
    /**
     * @stability stable
     */
    get peerNetworkInput(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get stateDetails(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkPeeringTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeNetworkPeeringTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
