import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * When set to 'true', the network is created in "auto subnet mode" and it will create a subnet for each region automatically across the '10.128.0.0/9' address range.
     *
     * When set to 'false', the network is created in "custom subnet mode" so
     * the user can explicitly connect subnetwork resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#auto_create_subnetworks ComputeNetwork#auto_create_subnetworks}
     *
     * @stability stable
     */
    readonly autoCreateSubnetworks?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#delete_default_routes_on_create ComputeNetwork#delete_default_routes_on_create}.
     *
     * @stability stable
     */
    readonly deleteDefaultRoutesOnCreate?: boolean;
    /**
     * An optional description of this resource. The resource must be recreated to modify this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#description ComputeNetwork#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1460 and the maximum value is 1500 bytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#mtu ComputeNetwork#mtu}
     *
     * @stability stable
     */
    readonly mtu?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#name ComputeNetwork#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#project ComputeNetwork#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The network-wide routing mode to use.
     *
     * If set to 'REGIONAL', this
     * network's cloud routers will only advertise routes with subnetworks
     * of this network in the same region as the router. If set to 'GLOBAL',
     * this network's cloud routers will advertise routes with all
     * subnetworks of this network, across regions. Possible values: ["REGIONAL", "GLOBAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#routing_mode ComputeNetwork#routing_mode}
     *
     * @stability stable
     */
    readonly routingMode?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#timeouts ComputeNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#create ComputeNetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#delete ComputeNetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#update ComputeNetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network.html google_compute_network}.
 *
 * @stability stable
 */
export declare class ComputeNetwork extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network.html google_compute_network} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkConfig);
    private _autoCreateSubnetworks?;
    /**
     * @stability stable
     */
    get autoCreateSubnetworks(): boolean;
    /**
     * @stability stable
     */
    set autoCreateSubnetworks(value: boolean);
    /**
     * @stability stable
     */
    resetAutoCreateSubnetworks(): void;
    /**
     * @stability stable
     */
    get autoCreateSubnetworksInput(): boolean | undefined;
    private _deleteDefaultRoutesOnCreate?;
    /**
     * @stability stable
     */
    get deleteDefaultRoutesOnCreate(): boolean;
    /**
     * @stability stable
     */
    set deleteDefaultRoutesOnCreate(value: boolean);
    /**
     * @stability stable
     */
    resetDeleteDefaultRoutesOnCreate(): void;
    /**
     * @stability stable
     */
    get deleteDefaultRoutesOnCreateInput(): boolean | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get gatewayIpv4(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _mtu?;
    /**
     * @stability stable
     */
    get mtu(): number;
    /**
     * @stability stable
     */
    set mtu(value: number);
    /**
     * @stability stable
     */
    resetMtu(): void;
    /**
     * @stability stable
     */
    get mtuInput(): number | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _routingMode?;
    /**
     * @stability stable
     */
    get routingMode(): string;
    /**
     * @stability stable
     */
    set routingMode(value: string);
    /**
     * @stability stable
     */
    resetRoutingMode(): void;
    /**
     * @stability stable
     */
    get routingModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeNetworkTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
