import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNodeTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * CPU overcommit. Default value: "NONE" Possible values: ["ENABLED", "NONE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#cpu_overcommit_type ComputeNodeTemplate#cpu_overcommit_type}
     *
     * @stability stable
     */
    readonly cpuOvercommitType?: string;
    /**
     * An optional textual description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#description ComputeNodeTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#name ComputeNodeTemplate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Labels to use for node affinity, which will be used in instance scheduling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_affinity_labels ComputeNodeTemplate#node_affinity_labels}
     *
     * @stability stable
     */
    readonly nodeAffinityLabels?: {
        [key: string]: string;
    };
    /**
     * Node type to use for nodes group that are created from this template.
     *
     * Only one of nodeTypeFlexibility and nodeType can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_type ComputeNodeTemplate#node_type}
     *
     * @stability stable
     */
    readonly nodeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#project ComputeNodeTemplate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where nodes using the node template will be created. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#region ComputeNodeTemplate#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * node_type_flexibility block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_type_flexibility ComputeNodeTemplate#node_type_flexibility}
     *
     * @stability stable
     */
    readonly nodeTypeFlexibility?: ComputeNodeTemplateNodeTypeFlexibility[];
    /**
     * server_binding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#server_binding ComputeNodeTemplate#server_binding}
     *
     * @stability stable
     */
    readonly serverBinding?: ComputeNodeTemplateServerBinding[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#timeouts ComputeNodeTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNodeTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNodeTemplateNodeTypeFlexibility {
    /**
     * Number of virtual CPUs to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#cpus ComputeNodeTemplate#cpus}
     *
     * @stability stable
     */
    readonly cpus?: string;
    /**
     * Physical memory available to the node, defined in MB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#memory ComputeNodeTemplate#memory}
     *
     * @stability stable
     */
    readonly memory?: string;
}
/**
 * @stability stable
 */
export interface ComputeNodeTemplateServerBinding {
    /**
     * Type of server binding policy. If 'RESTART_NODE_ON_ANY_SERVER', nodes using this template will restart on any physical server following a maintenance event.
     *
     * If 'RESTART_NODE_ON_MINIMAL_SERVER', nodes using this template
     * will restart on the same physical server following a maintenance
     * event, instead of being live migrated to or restarted on a new
     * physical server. This option may be useful if you are using
     * software licenses tied to the underlying server characteristics
     * such as physical sockets or cores, to avoid the need for
     * additional licenses when maintenance occurs. However, VMs on such
     * nodes will experience outages while maintenance is applied. Possible values: ["RESTART_NODE_ON_ANY_SERVER", "RESTART_NODE_ON_MINIMAL_SERVERS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#type ComputeNodeTemplate#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface ComputeNodeTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#create ComputeNodeTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#delete ComputeNodeTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html google_compute_node_template}.
 *
 * @stability stable
 */
export declare class ComputeNodeTemplate extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html google_compute_node_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: ComputeNodeTemplateConfig);
    private _cpuOvercommitType?;
    /**
     * @stability stable
     */
    get cpuOvercommitType(): string;
    /**
     * @stability stable
     */
    set cpuOvercommitType(value: string);
    /**
     * @stability stable
     */
    resetCpuOvercommitType(): void;
    /**
     * @stability stable
     */
    get cpuOvercommitTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeAffinityLabels?;
    /**
     * @stability stable
     */
    get nodeAffinityLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set nodeAffinityLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetNodeAffinityLabels(): void;
    /**
     * @stability stable
     */
    get nodeAffinityLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): string;
    /**
     * @stability stable
     */
    set nodeType(value: string);
    /**
     * @stability stable
     */
    resetNodeType(): void;
    /**
     * @stability stable
     */
    get nodeTypeInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _nodeTypeFlexibility?;
    /**
     * @stability stable
     */
    get nodeTypeFlexibility(): ComputeNodeTemplateNodeTypeFlexibility[];
    /**
     * @stability stable
     */
    set nodeTypeFlexibility(value: ComputeNodeTemplateNodeTypeFlexibility[]);
    /**
     * @stability stable
     */
    resetNodeTypeFlexibility(): void;
    /**
     * @stability stable
     */
    get nodeTypeFlexibilityInput(): ComputeNodeTemplateNodeTypeFlexibility[] | undefined;
    private _serverBinding?;
    /**
     * @stability stable
     */
    get serverBinding(): ComputeNodeTemplateServerBinding[];
    /**
     * @stability stable
     */
    set serverBinding(value: ComputeNodeTemplateServerBinding[]);
    /**
     * @stability stable
     */
    resetServerBinding(): void;
    /**
     * @stability stable
     */
    get serverBindingInput(): ComputeNodeTemplateServerBinding[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNodeTemplateTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeNodeTemplateTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNodeTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
