import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputePacketMirroringConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#description ComputePacketMirroring#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the packet mirroring rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#name ComputePacketMirroring#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Since only one rule can be active at a time, priority is used to break ties in the case of two rules that apply to the same instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#priority ComputePacketMirroring#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#project ComputePacketMirroring#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Region in which the created address should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#region ComputePacketMirroring#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * collector_ilb block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#collector_ilb ComputePacketMirroring#collector_ilb}
     *
     * @stability stable
     */
    readonly collectorIlb: ComputePacketMirroringCollectorIlb[];
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#filter ComputePacketMirroring#filter}
     *
     * @stability stable
     */
    readonly filter?: ComputePacketMirroringFilter[];
    /**
     * mirrored_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#mirrored_resources ComputePacketMirroring#mirrored_resources}
     *
     * @stability stable
     */
    readonly mirroredResources: ComputePacketMirroringMirroredResources[];
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#network ComputePacketMirroring#network}
     *
     * @stability stable
     */
    readonly network: ComputePacketMirroringNetwork[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#timeouts ComputePacketMirroring#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputePacketMirroringTimeouts;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringCollectorIlb {
    /**
     * The URL of the forwarding rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringFilter {
    /**
     * IP CIDR ranges that apply as a filter on the source (ingress) or destination (egress) IP in the IP header.
     *
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#cidr_ranges ComputePacketMirroring#cidr_ranges}
     *
     * @stability stable
     */
    readonly cidrRanges?: string[];
    /**
     * Direction of traffic to mirror. Default value: "BOTH" Possible values: ["INGRESS", "EGRESS", "BOTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#direction ComputePacketMirroring#direction}
     *
     * @stability stable
     */
    readonly direction?: string;
    /**
     * Protocols that apply as a filter on mirrored traffic. Possible values: ["tcp", "udp", "icmp"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#ip_protocols ComputePacketMirroring#ip_protocols}
     *
     * @stability stable
     */
    readonly ipProtocols?: string[];
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResourcesInstances {
    /**
     * The URL of the instances where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResourcesSubnetworks {
    /**
     * The URL of the subnetwork where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringMirroredResources {
    /**
     * All instances with these tags will be mirrored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#tags ComputePacketMirroring#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * instances block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#instances ComputePacketMirroring#instances}
     *
     * @stability stable
     */
    readonly instances?: ComputePacketMirroringMirroredResourcesInstances[];
    /**
     * subnetworks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#subnetworks ComputePacketMirroring#subnetworks}
     *
     * @stability stable
     */
    readonly subnetworks?: ComputePacketMirroringMirroredResourcesSubnetworks[];
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringNetwork {
    /**
     * The full self_link URL of the network where this rule is active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     *
     * @stability stable
     */
    readonly url: string;
}
/**
 * @stability stable
 */
export interface ComputePacketMirroringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#create ComputePacketMirroring#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#delete ComputePacketMirroring#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#update ComputePacketMirroring#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring}.
 *
 * @stability stable
 */
export declare class ComputePacketMirroring extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputePacketMirroringConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _collectorIlb;
    /**
     * @stability stable
     */
    get collectorIlb(): ComputePacketMirroringCollectorIlb[];
    /**
     * @stability stable
     */
    set collectorIlb(value: ComputePacketMirroringCollectorIlb[]);
    /**
     * @stability stable
     */
    get collectorIlbInput(): ComputePacketMirroringCollectorIlb[];
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): ComputePacketMirroringFilter[];
    /**
     * @stability stable
     */
    set filter(value: ComputePacketMirroringFilter[]);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ComputePacketMirroringFilter[] | undefined;
    private _mirroredResources;
    /**
     * @stability stable
     */
    get mirroredResources(): ComputePacketMirroringMirroredResources[];
    /**
     * @stability stable
     */
    set mirroredResources(value: ComputePacketMirroringMirroredResources[]);
    /**
     * @stability stable
     */
    get mirroredResourcesInput(): ComputePacketMirroringMirroredResources[];
    private _network;
    /**
     * @stability stable
     */
    get network(): ComputePacketMirroringNetwork[];
    /**
     * @stability stable
     */
    set network(value: ComputePacketMirroringNetwork[]);
    /**
     * @stability stable
     */
    get networkInput(): ComputePacketMirroringNetwork[];
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputePacketMirroringTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputePacketMirroringTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputePacketMirroringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
