import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeProjectMetadataItemConfig extends cdktf.TerraformMetaArguments {
    /**
     * The metadata key to set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#key ComputeProjectMetadataItem#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#project ComputeProjectMetadataItem#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The value to set for the given metadata key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#value ComputeProjectMetadataItem#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#timeouts ComputeProjectMetadataItem#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeProjectMetadataItemTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeProjectMetadataItemTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#create ComputeProjectMetadataItem#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#delete ComputeProjectMetadataItem#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html#update ComputeProjectMetadataItem#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html google_compute_project_metadata_item}.
 *
 * @stability stable
 */
export declare class ComputeProjectMetadataItem extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata_item.html google_compute_project_metadata_item} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeProjectMetadataItemConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _key;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _value;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeProjectMetadataItemTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeProjectMetadataItemTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeProjectMetadataItemTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
