import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeProjectMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
     * A series of key value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#metadata ComputeProjectMetadata#metadata}
     *
     * @stability stable
     */
    readonly metadata: {
        [key: string]: string;
    };
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#project ComputeProjectMetadata#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#timeouts ComputeProjectMetadata#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeProjectMetadataTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeProjectMetadataTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#create ComputeProjectMetadata#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#delete ComputeProjectMetadata#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html google_compute_project_metadata}.
 *
 * @stability stable
 */
export declare class ComputeProjectMetadata extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html google_compute_project_metadata} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeProjectMetadataConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    };
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeProjectMetadataTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeProjectMetadataTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeProjectMetadataTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
