import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE.
     *
     * If set to 0, the cookie is non-persistent and lasts
     * only until the end of the browser session (or equivalent). The
     * maximum allowed value for TTL is one day.
     *
     * When the load balancing scheme is INTERNAL, this field is not used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#affinity_cookie_ttl_sec ComputeRegionBackendService#affinity_cookie_ttl_sec}
     *
     * @stability stable
     */
    readonly affinityCookieTtlSec?: number;
    /**
     * Time for which instance will be drained (not accept new connections, but still work to finish started).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#connection_draining_timeout_sec ComputeRegionBackendService#connection_draining_timeout_sec}
     *
     * @stability stable
     */
    readonly connectionDrainingTimeoutSec?: number;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#description ComputeRegionBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this RegionBackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enable_cdn ComputeRegionBackendService#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean;
    /**
     * The set of URLs to HealthCheck resources for health checking this RegionBackendService. Currently at most one health check can be specified.
     *
     * A health check must be specified unless the backend service uses an internet
     * or serverless NEG as a backend.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#health_checks ComputeRegionBackendService#health_checks}
     *
     * @stability stable
     */
    readonly healthChecks?: string[];
    /**
     * Indicates what kind of load balancing this regional backend service will be used for.
     *
     * A backend service created for one type of load
     * balancing cannot be used with the other(s). Default value: "INTERNAL" Possible values: ["EXTERNAL", "INTERNAL", "INTERNAL_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#load_balancing_scheme ComputeRegionBackendService#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are -.
     *
     * ROUND_ROBIN - This is a simple policy in which each healthy backend
     *              is selected in round robin order.
     *
     * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
     *                hosts and picks the host which has fewer active requests.
     *
     * RING_HASH - The ring/modulo hash load balancer implements consistent
     *            hashing to backends. The algorithm has the property that the
     *            addition/removal of a host from a set of N hosts only affects
     *            1/N of the requests.
     *
     * RANDOM - The load balancer selects a random healthy host.
     *
     * ORIGINAL_DESTINATION - Backend host is selected based on the client
     *                       connection metadata, i.e., connections are opened
     *                       to the same address as the destination address of
     *                       the incoming connection before the connection
     *                       was redirected to the load balancer.
     *
     * MAGLEV - used as a drop in replacement for the ring hash load balancer.
     *         Maglev is not as stable as ring hash but has faster table lookup
     *         build times and host selection times. For more information about
     *         Maglev, refer to https://ai.google/research/pubs/pub44824
     *
     * This field is applicable only when the 'load_balancing_scheme' is set to
     * INTERNAL_MANAGED and the 'protocol' is set to HTTP, HTTPS, or HTTP2. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#locality_lb_policy ComputeRegionBackendService#locality_lb_policy}
     *
     * @stability stable
     */
    readonly localityLbPolicy?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#name ComputeRegionBackendService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The URL of the network to which this backend service belongs.
     *
     * This field can only be specified when the load balancing scheme is set to INTERNAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#network ComputeRegionBackendService#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group.
     *
     * Required when the
     * loadBalancingScheme is EXTERNAL, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
     * and the backends are instance groups. The named port must be defined on each
     * backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
     * default of "http" if not given.
     * Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#port_name ComputeRegionBackendService#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#project ComputeRegionBackendService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The protocol this RegionBackendService uses to communicate with backends.
     *
     * The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
     * types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "SSL", "TCP", "UDP", "GRPC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#protocol ComputeRegionBackendService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * The Region in which the created backend service should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#region ComputeRegionBackendService#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Type of session affinity to use.
     *
     * The default is NONE. Session affinity is
     * not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#session_affinity ComputeRegionBackendService#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: string;
    /**
     * How many seconds to wait for the backend before considering it a failed request.
     *
     * Default is 30 seconds. Valid range is [1, 86400].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#timeout_sec ComputeRegionBackendService#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * backend block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#backend ComputeRegionBackendService#backend}
     *
     * @stability stable
     */
    readonly backend?: ComputeRegionBackendServiceBackend[];
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#cdn_policy ComputeRegionBackendService#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeRegionBackendServiceCdnPolicy[];
    /**
     * circuit_breakers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#circuit_breakers ComputeRegionBackendService#circuit_breakers}
     *
     * @stability stable
     */
    readonly circuitBreakers?: ComputeRegionBackendServiceCircuitBreakers[];
    /**
     * consistent_hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consistent_hash ComputeRegionBackendService#consistent_hash}
     *
     * @stability stable
     */
    readonly consistentHash?: ComputeRegionBackendServiceConsistentHash[];
    /**
     * failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover_policy ComputeRegionBackendService#failover_policy}
     *
     * @stability stable
     */
    readonly failoverPolicy?: ComputeRegionBackendServiceFailoverPolicy[];
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#log_config ComputeRegionBackendService#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeRegionBackendServiceLogConfig[];
    /**
     * outlier_detection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#outlier_detection ComputeRegionBackendService#outlier_detection}
     *
     * @stability stable
     */
    readonly outlierDetection?: ComputeRegionBackendServiceOutlierDetection[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#timeouts ComputeRegionBackendService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionBackendServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceBackend {
    /**
     * Specifies the balancing mode for this backend. Default value: "CONNECTION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#balancing_mode ComputeRegionBackendService#balancing_mode}
     *
     * @stability stable
     */
    readonly balancingMode?: string;
    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
     *
     * ~>**NOTE**: This field cannot be set for
     * INTERNAL region backend services (default loadBalancingScheme),
     * but is required for non-INTERNAL backend service. The total
     * capacity_scaler for all backends must be non-zero.
     *
     * A setting of 0 means the group is completely drained, offering
     * 0% of its available Capacity. Valid range is [0.0,1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#capacity_scaler ComputeRegionBackendService#capacity_scaler}
     *
     * @stability stable
     */
    readonly capacityScaler?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#description ComputeRegionBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * This field designates whether this is a failover backend.
     *
     * More
     * than one failover backend can be configured for a given RegionBackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover ComputeRegionBackendService#failover}
     *
     * @stability stable
     */
    readonly failover?: boolean;
    /**
     * The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
     *
     * In case of instance group this defines the list
     * of instances that serve traffic. Member virtual machine
     * instances from each instance group must live in the same zone as
     * the instance group itself. No two backends in a backend service
     * are allowed to use same Instance Group resource.
     *
     * For Network Endpoint Groups this defines list of endpoints. All
     * endpoints of Network Endpoint Group must be hosted on instances
     * located in the same zone as the Network Endpoint Group.
     *
     * Backend services cannot mix Instance Group and
     * Network Endpoint Group backends.
     *
     * When the 'load_balancing_scheme' is INTERNAL, only instance groups
     * are supported.
     *
     * Note that you must specify an Instance Group or Network Endpoint
     * Group resource using the fully-qualified URL, rather than a
     * partial URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#group ComputeRegionBackendService#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * The max number of simultaneous connections for the group.
     *
     * Can
     * be used with either CONNECTION or UTILIZATION balancing modes.
     * Cannot be set for INTERNAL backend services.
     *
     * For CONNECTION mode, either maxConnections or one
     * of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
     * as appropriate for group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections ComputeRegionBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The max number of simultaneous connections that a single backend network endpoint can handle. Cannot be set for INTERNAL backend services.
     *
     * This is used to calculate the capacity of the group. Can be
     * used in either CONNECTION or UTILIZATION balancing modes. For
     * CONNECTION mode, either maxConnections or
     * maxConnectionsPerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections_per_endpoint ComputeRegionBackendService#max_connections_per_endpoint}
     *
     * @stability stable
     */
    readonly maxConnectionsPerEndpoint?: number;
    /**
     * The max number of simultaneous connections that a single backend instance can handle. Cannot be set for INTERNAL backend services.
     *
     * This is used to calculate the capacity of the group.
     * Can be used in either CONNECTION or UTILIZATION balancing modes.
     * For CONNECTION mode, either maxConnections or
     * maxConnectionsPerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections_per_instance ComputeRegionBackendService#max_connections_per_instance}
     *
     * @stability stable
     */
    readonly maxConnectionsPerInstance?: number;
    /**
     * The max requests per second (RPS) of the group. Cannot be set for INTERNAL backend services.
     *
     * Can be used with either RATE or UTILIZATION balancing modes,
     * but required if RATE mode. Either maxRate or one
     * of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
     * group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate ComputeRegionBackendService#max_rate}
     *
     * @stability stable
     */
    readonly maxRate?: number;
    /**
     * The max requests per second (RPS) that a single backend network endpoint can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerEndpoint must be set. Cannot be set
     * for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate_per_endpoint ComputeRegionBackendService#max_rate_per_endpoint}
     *
     * @stability stable
     */
    readonly maxRatePerEndpoint?: number;
    /**
     * The max requests per second (RPS) that a single backend instance can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerInstance must be set. Cannot be set
     * for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate_per_instance ComputeRegionBackendService#max_rate_per_instance}
     *
     * @stability stable
     */
    readonly maxRatePerInstance?: number;
    /**
     * Used when balancingMode is UTILIZATION.
     *
     * This ratio defines the
     * CPU utilization target for the group. Valid range is [0.0, 1.0].
     * Cannot be set for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_utilization ComputeRegionBackendService#max_utilization}
     *
     * @stability stable
     */
    readonly maxUtilization?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy {
    /**
     * If true requests to different hosts will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_host ComputeRegionBackendService#include_host}
     *
     * @stability stable
     */
    readonly includeHost?: boolean;
    /**
     * If true, http and https requests will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_protocol ComputeRegionBackendService#include_protocol}
     *
     * @stability stable
     */
    readonly includeProtocol?: boolean;
    /**
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist.
     *
     * If neither is set, the entire query
     * string will be included.
     *
     * If false, the query string will be excluded from the cache
     * key entirely.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_query_string ComputeRegionBackendService#include_query_string}
     *
     * @stability stable
     */
    readonly includeQueryString?: boolean;
    /**
     * Names of query string parameters to exclude in cache keys.
     *
     * All other parameters will be included. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#query_string_blacklist ComputeRegionBackendService#query_string_blacklist}
     *
     * @stability stable
     */
    readonly queryStringBlacklist?: string[];
    /**
     * Names of query string parameters to include in cache keys.
     *
     * All other parameters will be excluded. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#query_string_whitelist ComputeRegionBackendService#query_string_whitelist}
     *
     * @stability stable
     */
    readonly queryStringWhitelist?: string[];
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCdnPolicy {
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh, defaults to 1hr (3600s).
     *
     * After this
     * time period, the response will be revalidated before
     * being served.
     *
     * When serving responses to signed URL requests, Cloud CDN will
     * internally behave as though all responses from this backend had a
     * "Cache-Control: public, max-age=[TTL]" header, regardless of any
     * existing Cache-Control header. The actual headers served in
     * responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#signed_url_cache_max_age_sec ComputeRegionBackendService#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
     * cache_key_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#cache_key_policy ComputeRegionBackendService#cache_key_policy}
     *
     * @stability stable
     */
    readonly cacheKeyPolicy?: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy[];
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCircuitBreakers {
    /**
     * The maximum number of connections to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections ComputeRegionBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The maximum number of pending requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_pending_requests ComputeRegionBackendService#max_pending_requests}
     *
     * @stability stable
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum number of parallel requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_requests ComputeRegionBackendService#max_requests}
     *
     * @stability stable
     */
    readonly maxRequests?: number;
    /**
     * Maximum requests for a single backend connection.
     *
     * This parameter
     * is respected by both the HTTP/1.1 and HTTP/2 implementations. If
     * not specified, there is no limit. Setting this parameter to 1
     * will effectively disable keep alive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_requests_per_connection ComputeRegionBackendService#max_requests_per_connection}
     *
     * @stability stable
     */
    readonly maxRequestsPerConnection?: number;
    /**
     * The maximum number of parallel retries to the backend cluster. Defaults to 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_retries ComputeRegionBackendService#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHashHttpCookieTtl {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must
     * be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHashHttpCookie {
    /**
     * Name of the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#name ComputeRegionBackendService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Path to set for the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#path ComputeRegionBackendService#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * ttl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#ttl ComputeRegionBackendService#ttl}
     *
     * @stability stable
     */
    readonly ttl?: ComputeRegionBackendServiceConsistentHashHttpCookieTtl[];
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHash {
    /**
     * The hash based on the value of the specified header field.
     *
     * This field is applicable if the sessionAffinity is set to HEADER_FIELD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#http_header_name ComputeRegionBackendService#http_header_name}
     *
     * @stability stable
     */
    readonly httpHeaderName?: string;
    /**
     * The minimum number of virtual nodes to use for the hash ring.
     *
     * Larger ring sizes result in more granular load
     * distributions. If the number of hosts in the load balancing pool
     * is larger than the ring size, each host will be assigned a single
     * virtual node.
     * Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#minimum_ring_size ComputeRegionBackendService#minimum_ring_size}
     *
     * @stability stable
     */
    readonly minimumRingSize?: number;
    /**
     * http_cookie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#http_cookie ComputeRegionBackendService#http_cookie}
     *
     * @stability stable
     */
    readonly httpCookie?: ComputeRegionBackendServiceConsistentHashHttpCookie[];
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceFailoverPolicy {
    /**
     * On failover or failback, this field indicates whether connection drain will be honored.
     *
     * Setting this to true has the following effect: connections
     * to the old active pool are not drained. Connections to the new active pool
     * use the timeout of 10 min (currently fixed). Setting to false has the
     * following effect: both old and new connections will have a drain timeout
     * of 10 min.
     * This can be set to true only if the protocol is TCP.
     * The default is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#disable_connection_drain_on_failover ComputeRegionBackendService#disable_connection_drain_on_failover}
     *
     * @stability stable
     */
    readonly disableConnectionDrainOnFailover?: boolean;
    /**
     * This option is used only when no healthy VMs are detected in the primary and backup instance groups.
     *
     * When set to true, traffic is dropped. When
     * set to false, new connections are sent across all VMs in the primary group.
     * The default is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#drop_traffic_if_unhealthy ComputeRegionBackendService#drop_traffic_if_unhealthy}
     *
     * @stability stable
     */
    readonly dropTrafficIfUnhealthy?: boolean;
    /**
     * The value of the field must be in [0, 1].
     *
     * If the ratio of the healthy
     * VMs in the primary backend is at or below this number, traffic arriving
     * at the load-balanced IP will be directed to the failover backend.
     * In case where 'failoverRatio' is not set or all the VMs in the backup
     * backend are unhealthy, the traffic will be directed back to the primary
     * backend in the "force" mode, where traffic will be spread to the healthy
     * VMs with the best effort, or to all VMs when no VM is healthy.
     * This field is only used with l4 load balancing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover_ratio ComputeRegionBackendService#failover_ratio}
     *
     * @stability stable
     */
    readonly failoverRatio?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceLogConfig {
    /**
     * Whether to enable logging for the load balancer traffic served by this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enable ComputeRegionBackendService#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean;
    /**
     * This field can only be specified if logging is enabled for this backend service.
     *
     * The value of
     * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
     * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
     * The default value is 1.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#sample_rate ComputeRegionBackendService#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetectionInterval {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetection {
    /**
     * Number of errors before a host is ejected from the connection pool.
     *
     * When the
     * backend host is accessed over HTTP, a 5xx return code qualifies as an error.
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consecutive_errors ComputeRegionBackendService#consecutive_errors}
     *
     * @stability stable
     */
    readonly consecutiveErrors?: number;
    /**
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs.
     *
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consecutive_gateway_failure ComputeRegionBackendService#consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly consecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx.
     *
     * This setting can be used to disable
     * ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_consecutive_errors ComputeRegionBackendService#enforcing_consecutive_errors}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveErrors?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures.
     *
     * This setting can be
     * used to disable ejection or to ramp it up slowly. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_consecutive_gateway_failure ComputeRegionBackendService#enforcing_consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics.
     *
     * This setting can be used to
     * disable ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_success_rate ComputeRegionBackendService#enforcing_success_rate}
     *
     * @stability stable
     */
    readonly enforcingSuccessRate?: number;
    /**
     * Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 10%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_ejection_percent ComputeRegionBackendService#max_ejection_percent}
     *
     * @stability stable
     */
    readonly maxEjectionPercent?: number;
    /**
     * The number of hosts in a cluster that must have enough request volume to detect success rate outliers.
     *
     * If the number of hosts is less than this setting, outlier
     * detection via success rate statistics is not performed for any host in the
     * cluster. Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_minimum_hosts ComputeRegionBackendService#success_rate_minimum_hosts}
     *
     * @stability stable
     */
    readonly successRateMinimumHosts?: number;
    /**
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection.
     *
     * If the volume is lower than this setting, outlier
     * detection via success rate statistics is not performed for that host. Defaults
     * to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_request_volume ComputeRegionBackendService#success_rate_request_volume}
     *
     * @stability stable
     */
    readonly successRateRequestVolume?: number;
    /**
     * This factor is used to determine the ejection threshold for success rate outlier ejection.
     *
     * The ejection threshold is the difference between the mean success
     * rate, and the product of this factor and the standard deviation of the mean
     * success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
     * by a thousand to get a double. That is, if the desired factor is 1.9, the
     * runtime value should be 1900. Defaults to 1900.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_stdev_factor ComputeRegionBackendService#success_rate_stdev_factor}
     *
     * @stability stable
     */
    readonly successRateStdevFactor?: number;
    /**
     * base_ejection_time block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#base_ejection_time ComputeRegionBackendService#base_ejection_time}
     *
     * @stability stable
     */
    readonly baseEjectionTime?: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime[];
    /**
     * interval block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#interval ComputeRegionBackendService#interval}
     *
     * @stability stable
     */
    readonly interval?: ComputeRegionBackendServiceOutlierDetectionInterval[];
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#create ComputeRegionBackendService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#delete ComputeRegionBackendService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#update ComputeRegionBackendService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html google_compute_region_backend_service}.
 *
 * @stability stable
 */
export declare class ComputeRegionBackendService extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html google_compute_region_backend_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionBackendServiceConfig);
    private _affinityCookieTtlSec?;
    /**
     * @stability stable
     */
    get affinityCookieTtlSec(): number;
    /**
     * @stability stable
     */
    set affinityCookieTtlSec(value: number);
    /**
     * @stability stable
     */
    resetAffinityCookieTtlSec(): void;
    /**
     * @stability stable
     */
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSec(): number;
    /**
     * @stability stable
     */
    set connectionDrainingTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetConnectionDrainingTimeoutSec(): void;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    private _healthChecks?;
    /**
     * @stability stable
     */
    get healthChecks(): string[];
    /**
     * @stability stable
     */
    set healthChecks(value: string[]);
    /**
     * @stability stable
     */
    resetHealthChecks(): void;
    /**
     * @stability stable
     */
    get healthChecksInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    /**
     * @stability stable
     */
    get localityLbPolicy(): string;
    /**
     * @stability stable
     */
    set localityLbPolicy(value: string);
    /**
     * @stability stable
     */
    resetLocalityLbPolicy(): void;
    /**
     * @stability stable
     */
    get localityLbPolicyInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): string;
    /**
     * @stability stable
     */
    set sessionAffinity(value: string);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    set timeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    private _backend?;
    /**
     * @stability stable
     */
    get backend(): ComputeRegionBackendServiceBackend[];
    /**
     * @stability stable
     */
    set backend(value: ComputeRegionBackendServiceBackend[]);
    /**
     * @stability stable
     */
    resetBackend(): void;
    /**
     * @stability stable
     */
    get backendInput(): ComputeRegionBackendServiceBackend[] | undefined;
    private _cdnPolicy?;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeRegionBackendServiceCdnPolicy[];
    /**
     * @stability stable
     */
    set cdnPolicy(value: ComputeRegionBackendServiceCdnPolicy[]);
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeRegionBackendServiceCdnPolicy[] | undefined;
    private _circuitBreakers?;
    /**
     * @stability stable
     */
    get circuitBreakers(): ComputeRegionBackendServiceCircuitBreakers[];
    /**
     * @stability stable
     */
    set circuitBreakers(value: ComputeRegionBackendServiceCircuitBreakers[]);
    /**
     * @stability stable
     */
    resetCircuitBreakers(): void;
    /**
     * @stability stable
     */
    get circuitBreakersInput(): ComputeRegionBackendServiceCircuitBreakers[] | undefined;
    private _consistentHash?;
    /**
     * @stability stable
     */
    get consistentHash(): ComputeRegionBackendServiceConsistentHash[];
    /**
     * @stability stable
     */
    set consistentHash(value: ComputeRegionBackendServiceConsistentHash[]);
    /**
     * @stability stable
     */
    resetConsistentHash(): void;
    /**
     * @stability stable
     */
    get consistentHashInput(): ComputeRegionBackendServiceConsistentHash[] | undefined;
    private _failoverPolicy?;
    /**
     * @stability stable
     */
    get failoverPolicy(): ComputeRegionBackendServiceFailoverPolicy[];
    /**
     * @stability stable
     */
    set failoverPolicy(value: ComputeRegionBackendServiceFailoverPolicy[]);
    /**
     * @stability stable
     */
    resetFailoverPolicy(): void;
    /**
     * @stability stable
     */
    get failoverPolicyInput(): ComputeRegionBackendServiceFailoverPolicy[] | undefined;
    private _logConfig?;
    /**
     * @stability stable
     */
    get logConfig(): ComputeRegionBackendServiceLogConfig[];
    /**
     * @stability stable
     */
    set logConfig(value: ComputeRegionBackendServiceLogConfig[]);
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeRegionBackendServiceLogConfig[] | undefined;
    private _outlierDetection?;
    /**
     * @stability stable
     */
    get outlierDetection(): ComputeRegionBackendServiceOutlierDetection[];
    /**
     * @stability stable
     */
    set outlierDetection(value: ComputeRegionBackendServiceOutlierDetection[]);
    /**
     * @stability stable
     */
    resetOutlierDetection(): void;
    /**
     * @stability stable
     */
    get outlierDetectionInput(): ComputeRegionBackendServiceOutlierDetection[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionBackendServiceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeRegionBackendServiceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionBackendServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
