import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#minimal_action ComputeRegionPerInstanceConfig#minimal_action}.
     *
     * @stability stable
     */
    readonly minimalAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#most_disruptive_allowed_action ComputeRegionPerInstanceConfig#most_disruptive_allowed_action}.
     *
     * @stability stable
     */
    readonly mostDisruptiveAllowedAction?: string;
    /**
     * The name for this per-instance config and its corresponding instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#name ComputeRegionPerInstanceConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#project ComputeRegionPerInstanceConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the containing instance group manager is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#region ComputeRegionPerInstanceConfig#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The region instance group manager this instance config is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#region_instance_group_manager ComputeRegionPerInstanceConfig#region_instance_group_manager}
     *
     * @stability stable
     */
    readonly regionInstanceGroupManager: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#remove_instance_state_on_destroy ComputeRegionPerInstanceConfig#remove_instance_state_on_destroy}.
     *
     * @stability stable
     */
    readonly removeInstanceStateOnDestroy?: boolean;
    /**
     * preserved_state block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#preserved_state ComputeRegionPerInstanceConfig#preserved_state}
     *
     * @stability stable
     */
    readonly preservedState?: ComputeRegionPerInstanceConfigPreservedState[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#timeouts ComputeRegionPerInstanceConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionPerInstanceConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigPreservedStateDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
     * 'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
     * 'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
     * deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#delete_rule ComputeRegionPerInstanceConfig#delete_rule}
     *
     * @stability stable
     */
    readonly deleteRule?: string;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#device_name ComputeRegionPerInstanceConfig#device_name}
     *
     * @stability stable
     */
    readonly deviceName: string;
    /**
     * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#mode ComputeRegionPerInstanceConfig#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The URI of an existing persistent disk to attach under the specified device-name in the format 'projects/project-id/zones/zone/disks/disk-name'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#source ComputeRegionPerInstanceConfig#source}
     *
     * @stability stable
     */
    readonly source: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigPreservedState {
    /**
     * Preserved metadata defined for this instance. This is a list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#metadata ComputeRegionPerInstanceConfig#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#disk ComputeRegionPerInstanceConfig#disk}
     *
     * @stability stable
     */
    readonly disk?: ComputeRegionPerInstanceConfigPreservedStateDisk[];
}
/**
 * @stability stable
 */
export interface ComputeRegionPerInstanceConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#create ComputeRegionPerInstanceConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#delete ComputeRegionPerInstanceConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#update ComputeRegionPerInstanceConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html google_compute_region_per_instance_config}.
 *
 * @stability stable
 */
export declare class ComputeRegionPerInstanceConfig extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html google_compute_region_per_instance_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionPerInstanceConfigConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _minimalAction?;
    /**
     * @stability stable
     */
    get minimalAction(): string;
    /**
     * @stability stable
     */
    set minimalAction(value: string);
    /**
     * @stability stable
     */
    resetMinimalAction(): void;
    /**
     * @stability stable
     */
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedAction(): string;
    /**
     * @stability stable
     */
    set mostDisruptiveAllowedAction(value: string);
    /**
     * @stability stable
     */
    resetMostDisruptiveAllowedAction(): void;
    /**
     * @stability stable
     */
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _regionInstanceGroupManager;
    /**
     * @stability stable
     */
    get regionInstanceGroupManager(): string;
    /**
     * @stability stable
     */
    set regionInstanceGroupManager(value: string);
    /**
     * @stability stable
     */
    get regionInstanceGroupManagerInput(): string;
    private _removeInstanceStateOnDestroy?;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroy(): boolean;
    /**
     * @stability stable
     */
    set removeInstanceStateOnDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetRemoveInstanceStateOnDestroy(): void;
    /**
     * @stability stable
     */
    get removeInstanceStateOnDestroyInput(): boolean | undefined;
    private _preservedState?;
    /**
     * @stability stable
     */
    get preservedState(): ComputeRegionPerInstanceConfigPreservedState[];
    /**
     * @stability stable
     */
    set preservedState(value: ComputeRegionPerInstanceConfigPreservedState[]);
    /**
     * @stability stable
     */
    resetPreservedState(): void;
    /**
     * @stability stable
     */
    get preservedStateInput(): ComputeRegionPerInstanceConfigPreservedState[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionPerInstanceConfigTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeRegionPerInstanceConfigTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionPerInstanceConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
