import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match.
     *
     * If defaultRouteAction is additionally specified, advanced
     * routing actions like URL Rewrites, etc. take effect prior to sending the request to the
     * backend. However, if defaultService is specified, defaultRouteAction cannot contain any
     * weightedBackendServices. Conversely, if routeAction specifies any
     * weightedBackendServices, service must not be specified.  Only one of defaultService,
     * defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#default_service ComputeRegionUrlMap#default_service}
     *
     * @stability stable
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#description ComputeRegionUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#name ComputeRegionUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#project ComputeRegionUrlMap#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Region in which the url map should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#region ComputeRegionUrlMap#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#default_url_redirect ComputeRegionUrlMap#default_url_redirect}
     *
     * @stability stable
     */
    readonly defaultUrlRedirect?: ComputeRegionUrlMapDefaultUrlRedirect[];
    /**
     * host_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_rule ComputeRegionUrlMap#host_rule}
     *
     * @stability stable
     */
    readonly hostRule?: ComputeRegionUrlMapHostRule[];
    /**
     * path_matcher block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_matcher ComputeRegionUrlMap#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher?: ComputeRegionUrlMapPathMatcher[];
    /**
     * test block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#test ComputeRegionUrlMap#test}
     *
     * @stability stable
     */
    readonly test?: ComputeRegionUrlMapTest[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#timeouts ComputeRegionUrlMap#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionUrlMapTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_redirect ComputeRegionUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#https_redirect ComputeRegionUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_redirect ComputeRegionUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#strip_query ComputeRegionUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapHostRule {
    /**
     * An optional description of this HostRule. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#description ComputeRegionUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The list of host patterns to match.
     *
     * They must be valid
     * hostnames, except * will match any string of ([a-z0-9-.]*). In
     * that case, * must be the first character and must be followed in
     * the pattern by either - or ..
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#hosts ComputeRegionUrlMap#hosts}
     *
     * @stability stable
     */
    readonly hosts: string[];
    /**
     * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_matcher ComputeRegionUrlMap#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_redirect ComputeRegionUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#https_redirect ComputeRegionUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_redirect ComputeRegionUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#strip_query ComputeRegionUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_credentials ComputeRegionUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_headers ComputeRegionUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_methods ComputeRegionUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_origin_regexes ComputeRegionUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_origins ComputeRegionUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#disabled ComputeRegionUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#expose_headers ComputeRegionUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#max_age ComputeRegionUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#http_status ComputeRegionUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#percentage ComputeRegionUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#percentage ComputeRegionUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#fixed_delay ComputeRegionUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#abort ComputeRegionUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#delay ComputeRegionUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
     * The RegionBackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#backend_service ComputeRegionUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#num_retries ComputeRegionUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries?: number;
    /**
     * Specifies one or more conditions when this retry rule applies. Valid values are:.
     *
     * - 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * - gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * - connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * - retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * - refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * - cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * - deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * - resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * - unavailable: Loadbalancer will retry if
     * the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#retry_conditions ComputeRegionUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#per_try_timeout ComputeRegionUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_rewrite ComputeRegionUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_prefix_rewrite ComputeRegionUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
     * The default RegionBackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#backend_service ComputeRegionUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#weight ComputeRegionUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_action ComputeRegionUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#cors_policy ComputeRegionUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#fault_injection_policy ComputeRegionUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_mirror_policy ComputeRegionUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#retry_policy ComputeRegionUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#timeout ComputeRegionUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#url_rewrite ComputeRegionUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#weighted_backend_services ComputeRegionUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_redirect ComputeRegionUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request. This must only be set for UrlMaps used in
     * TargetHttpProxys. Setting this true for TargetHttpsProxy is not
     * permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#https_redirect ComputeRegionUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied
     * together with prefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_redirect ComputeRegionUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with
     * pathRedirect. Supply one alone or neither. If neither is supplied, the
     * path of the original request will be used for the redirect. The value
     * must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the
     * original URL is retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#strip_query ComputeRegionUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherPathRule {
    /**
     * The list of path patterns to match.
     *
     * Each must start with / and the only place a
     * is allowed is at the end following a /. The string fed to the path matcher
     * does not include any text after the first ? or #, and those chars are not
     * allowed here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#paths ComputeRegionUrlMap#paths}
     *
     * @stability stable
     */
    readonly paths: string[];
    /**
     * The region backend service resource to which traffic is directed if this rule is matched.
     *
     * If routeAction is additionally specified,
     * advanced routing actions like URL Rewrites, etc. take effect prior to sending
     * the request to the backend. However, if service is specified, routeAction cannot
     * contain any weightedBackendService s. Conversely, if routeAction specifies any
     * weightedBackendServices, service must not be specified. Only one of urlRedirect,
     * service or routeAction.weightedBackendService must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#service ComputeRegionUrlMap#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#route_action ComputeRegionUrlMap#route_action}
     *
     * @stability stable
     */
    readonly routeAction?: ComputeRegionUrlMapPathMatcherPathRuleRouteAction[];
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#url_redirect ComputeRegionUrlMap#url_redirect}
     *
     * @stability stable
     */
    readonly urlRedirect?: ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
     * The end of the range (exclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#range_end ComputeRegionUrlMap#range_end}
     *
     * @stability stable
     */
    readonly rangeEnd: number;
    /**
     * The start of the range (inclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#range_start ComputeRegionUrlMap#range_start}
     *
     * @stability stable
     */
    readonly rangeStart: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
     * The value should exactly match contents of exactMatch.
     *
     * Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#exact_match ComputeRegionUrlMap#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The name of the HTTP header to match.
     *
     * For matching against the HTTP request's
     * authority, use a headerMatch with the header name ":authority". For matching a
     * request's method, use the headerName ":method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * If set to false, the headerMatch is considered a match if the match criteria above are met.
     *
     * If set to true, the headerMatch is considered a match if the
     * match criteria above are NOT met. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#invert_match ComputeRegionUrlMap#invert_match}
     *
     * @stability stable
     */
    readonly invertMatch?: boolean;
    /**
     * The value of the header must start with the contents of prefixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_match ComputeRegionUrlMap#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * A header with the contents of headerName must exist.
     *
     * The match takes place
     * whether or not the request's header has a value or not. Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#present_match ComputeRegionUrlMap#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean;
    /**
     * The value of the header must match the regular expression specified in regexMatch.
     *
     * For regular expression grammar, please see:
     * en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
     * specified in the HTTP request, use a headerMatch with headerName set to PORT and
     * a regular expression that satisfies the RFC2616 Host header's port specifier.
     * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
     * rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#regex_match ComputeRegionUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
    /**
     * The value of the header must end with the contents of suffixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#suffix_match ComputeRegionUrlMap#suffix_match}
     *
     * @stability stable
     */
    readonly suffixMatch?: string;
    /**
     * range_match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#range_match ComputeRegionUrlMap#range_match}
     *
     * @stability stable
     */
    readonly rangeMatch?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
     * Name of metadata label.
     *
     * The name can have a maximum length of 1024 characters
     * and must be at least 1 character long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#name ComputeRegionUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The value of the label must match the specified value. value can have a maximum length of 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#value ComputeRegionUrlMap#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
     * Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match. Supported values are:.
     *
     * MATCH_ANY: At least one of the filterLabels must have a matching label in the
     * provided metadata.
     * MATCH_ALL: All filterLabels must have matching labels in
     * the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#filter_match_criteria ComputeRegionUrlMap#filter_match_criteria}
     *
     * @stability stable
     */
    readonly filterMatchCriteria: string;
    /**
     * filter_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#filter_labels ComputeRegionUrlMap#filter_labels}
     *
     * @stability stable
     */
    readonly filterLabels: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
     * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
     *
     * Only one of presentMatch, exactMatch and regexMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#exact_match ComputeRegionUrlMap#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The name of the query parameter to match.
     *
     * The query parameter must exist in the
     * request, in the absence of which the request match fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#name ComputeRegionUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
     *
     * Only one of
     * presentMatch, exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#present_match ComputeRegionUrlMap#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean;
    /**
     * The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch.
     *
     * For the regular expression grammar,
     * please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
     * exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#regex_match ComputeRegionUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRules {
    /**
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
     *
     * FullPathMatch must be between 1
     * and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
     * be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#full_path_match ComputeRegionUrlMap#full_path_match}
     *
     * @stability stable
     */
    readonly fullPathMatch?: string;
    /**
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#ignore_case ComputeRegionUrlMap#ignore_case}
     *
     * @stability stable
     */
    readonly ignoreCase?: boolean;
    /**
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch.
     *
     * prefixMatch must begin with a /. The value must be
     * between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
     * regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_match ComputeRegionUrlMap#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL.
     *
     * For regular expression grammar please
     * see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
     * fullPathMatch or regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#regex_match ComputeRegionUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
    /**
     * header_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_matches ComputeRegionUrlMap#header_matches}
     *
     * @stability stable
     */
    readonly headerMatches?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[];
    /**
     * metadata_filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#metadata_filters ComputeRegionUrlMap#metadata_filters}
     *
     * @stability stable
     */
    readonly metadataFilters?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[];
    /**
     * query_parameter_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#query_parameter_matches ComputeRegionUrlMap#query_parameter_matches}
     *
     * @stability stable
     */
    readonly queryParameterMatches?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_credentials ComputeRegionUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_headers ComputeRegionUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_methods ComputeRegionUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_origin_regexes ComputeRegionUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#allow_origins ComputeRegionUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled. which indicates that the CORS policy is in effect. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#disabled ComputeRegionUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#expose_headers ComputeRegionUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#max_age ComputeRegionUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#http_status ComputeRegionUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#percentage ComputeRegionUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#percentage ComputeRegionUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#fixed_delay ComputeRegionUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#abort ComputeRegionUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#delay ComputeRegionUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
     * The RegionBackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#backend_service ComputeRegionUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#num_retries ComputeRegionUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries: number;
    /**
     * Specifies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in
     * the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#retry_conditions ComputeRegionUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#per_try_timeout ComputeRegionUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#nanos ComputeRegionUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#seconds ComputeRegionUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_rewrite ComputeRegionUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_prefix_rewrite ComputeRegionUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_name ComputeRegionUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_value ComputeRegionUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#replace ComputeRegionUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
     * The default RegionBackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#backend_service ComputeRegionUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#weight ComputeRegionUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_action ComputeRegionUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#cors_policy ComputeRegionUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#fault_injection_policy ComputeRegionUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#request_mirror_policy ComputeRegionUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#retry_policy ComputeRegionUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#timeout ComputeRegionUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#url_rewrite ComputeRegionUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#weighted_backend_services ComputeRegionUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host_redirect ComputeRegionUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request. This must only be set for UrlMaps used in
     * TargetHttpProxys. Setting this true for TargetHttpsProxy is not
     * permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#https_redirect ComputeRegionUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied
     * together with prefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_redirect ComputeRegionUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with
     * pathRedirect. Supply one alone or neither. If neither is supplied, the
     * path of the original request will be used for the redirect. The value
     * must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query
     * portion of the original URL is retained. The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#strip_query ComputeRegionUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcherRouteRules {
    /**
     * For routeRules within a given pathMatcher, priority determines the order in which load balancer will interpret routeRules.
     *
     * RouteRules are evaluated
     * in order of priority, from the lowest to highest number. The priority of
     * a rule decreases as its number increases (1, 2, 3, N+1). The first rule
     * that matches the request is applied.
     *
     * You cannot configure two or more routeRules with the same priority.
     * Priority for each rule must be set to a number between 0 and
     * 2147483647 inclusive.
     *
     * Priority numbers can have gaps, which enable you to add or remove rules
     * in the future without affecting the rest of the rules. For example,
     * 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
     * you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
     * future without any impact on existing rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#priority ComputeRegionUrlMap#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * The region backend service resource to which traffic is directed if this rule is matched.
     *
     * If routeAction is additionally specified,
     * advanced routing actions like URL Rewrites, etc. take effect prior to sending
     * the request to the backend. However, if service is specified, routeAction cannot
     * contain any weightedBackendService s. Conversely, if routeAction specifies any
     * weightedBackendServices, service must not be specified. Only one of urlRedirect,
     * service or routeAction.weightedBackendService must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#service ComputeRegionUrlMap#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#header_action ComputeRegionUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction[];
    /**
     * match_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#match_rules ComputeRegionUrlMap#match_rules}
     *
     * @stability stable
     */
    readonly matchRules?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules[];
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#route_action ComputeRegionUrlMap#route_action}
     *
     * @stability stable
     */
    readonly routeAction?: ComputeRegionUrlMapPathMatcherRouteRulesRouteAction[];
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#url_redirect ComputeRegionUrlMap#url_redirect}
     *
     * @stability stable
     */
    readonly urlRedirect?: ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapPathMatcher {
    /**
     * A reference to a RegionBackendService resource.
     *
     * This will be used if
     * none of the pathRules defined by this PathMatcher is matched by
     * the URL's path portion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#default_service ComputeRegionUrlMap#default_service}
     *
     * @stability stable
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#description ComputeRegionUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name to which this PathMatcher is referred by the HostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#name ComputeRegionUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#default_url_redirect ComputeRegionUrlMap#default_url_redirect}
     *
     * @stability stable
     */
    readonly defaultUrlRedirect?: ComputeRegionUrlMapPathMatcherDefaultUrlRedirect[];
    /**
     * path_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path_rule ComputeRegionUrlMap#path_rule}
     *
     * @stability stable
     */
    readonly pathRule?: ComputeRegionUrlMapPathMatcherPathRule[];
    /**
     * route_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#route_rules ComputeRegionUrlMap#route_rules}
     *
     * @stability stable
     */
    readonly routeRules?: ComputeRegionUrlMapPathMatcherRouteRules[];
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapTest {
    /**
     * Description of this test case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#description ComputeRegionUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Host portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#host ComputeRegionUrlMap#host}
     *
     * @stability stable
     */
    readonly host: string;
    /**
     * Path portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#path ComputeRegionUrlMap#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * A reference to expected RegionBackendService resource the given URL should be mapped to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#service ComputeRegionUrlMap#service}
     *
     * @stability stable
     */
    readonly service: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionUrlMapTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#create ComputeRegionUrlMap#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#delete ComputeRegionUrlMap#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html#update ComputeRegionUrlMap#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html google_compute_region_url_map}.
 *
 * @stability stable
 */
export declare class ComputeRegionUrlMap extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map.html google_compute_region_url_map} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionUrlMapConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _defaultService?;
    /**
     * @stability stable
     */
    get defaultService(): string;
    /**
     * @stability stable
     */
    set defaultService(value: string);
    /**
     * @stability stable
     */
    resetDefaultService(): void;
    /**
     * @stability stable
     */
    get defaultServiceInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get mapId(): number;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _defaultUrlRedirect?;
    /**
     * @stability stable
     */
    get defaultUrlRedirect(): ComputeRegionUrlMapDefaultUrlRedirect[];
    /**
     * @stability stable
     */
    set defaultUrlRedirect(value: ComputeRegionUrlMapDefaultUrlRedirect[]);
    /**
     * @stability stable
     */
    resetDefaultUrlRedirect(): void;
    /**
     * @stability stable
     */
    get defaultUrlRedirectInput(): ComputeRegionUrlMapDefaultUrlRedirect[] | undefined;
    private _hostRule?;
    /**
     * @stability stable
     */
    get hostRule(): ComputeRegionUrlMapHostRule[];
    /**
     * @stability stable
     */
    set hostRule(value: ComputeRegionUrlMapHostRule[]);
    /**
     * @stability stable
     */
    resetHostRule(): void;
    /**
     * @stability stable
     */
    get hostRuleInput(): ComputeRegionUrlMapHostRule[] | undefined;
    private _pathMatcher?;
    /**
     * @stability stable
     */
    get pathMatcher(): ComputeRegionUrlMapPathMatcher[];
    /**
     * @stability stable
     */
    set pathMatcher(value: ComputeRegionUrlMapPathMatcher[]);
    /**
     * @stability stable
     */
    resetPathMatcher(): void;
    /**
     * @stability stable
     */
    get pathMatcherInput(): ComputeRegionUrlMapPathMatcher[] | undefined;
    private _test?;
    /**
     * @stability stable
     */
    get test(): ComputeRegionUrlMapTest[];
    /**
     * @stability stable
     */
    set test(value: ComputeRegionUrlMapTest[]);
    /**
     * @stability stable
     */
    resetTest(): void;
    /**
     * @stability stable
     */
    get testInput(): ComputeRegionUrlMapTest[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionUrlMapTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeRegionUrlMapTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionUrlMapTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
