import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The certificate in PEM format.
     *
     * The certificate chain must be no greater than 5 certs long.
     * The chain must include at least one intermediate cert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#certificate ComputeSslCertificate#certificate}
     *
     * @stability stable
     */
    readonly certificate: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#description ComputeSslCertificate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     *
     * These are in the same namespace as the managed SSL certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#name ComputeSslCertificate#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#name_prefix ComputeSslCertificate#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The write-only private key in PEM format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#private_key ComputeSslCertificate#private_key}
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#project ComputeSslCertificate#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#timeouts ComputeSslCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSslCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSslCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#create ComputeSslCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html#delete ComputeSslCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html google_compute_ssl_certificate}.
 *
 * @stability stable
 */
export declare class ComputeSslCertificate extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_certificate.html google_compute_ssl_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSslCertificateConfig);
    private _certificate;
    /**
     * @stability stable
     */
    get certificate(): string;
    /**
     * @stability stable
     */
    set certificate(value: string);
    /**
     * @stability stable
     */
    get certificateInput(): string;
    /**
     * @stability stable
     */
    get certificateId(): number;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    set namePrefix(value: string);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _privateKey;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSslCertificateTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeSslCertificateTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSslCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
