import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Provide this property when
     * you create the resource. This field can be set only at resource
     * creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#description ComputeSubnetwork#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The range of internal addresses that are owned by this subnetwork.
     *
     * Provide this property when you create the subnetwork. For example,
     * 10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
     * non-overlapping within a network. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#ip_cidr_range ComputeSubnetwork#ip_cidr_range}
     *
     * @stability stable
     */
    readonly ipCidrRange: string;
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
     * means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#name ComputeSubnetwork#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The network this subnet belongs to. Only networks that are in the distributed mode can have subnetworks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#network ComputeSubnetwork#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * When enabled, VMs in this subnetwork without external IP addresses can access Google APIs and services by using Private Google Access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#private_ip_google_access ComputeSubnetwork#private_ip_google_access}
     *
     * @stability stable
     */
    readonly privateIpGoogleAccess?: boolean;
    /**
     * The private IPv6 google access type for the VMs in this subnet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#private_ipv6_google_access ComputeSubnetwork#private_ipv6_google_access}
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#project ComputeSubnetwork#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The GCP region for this subnetwork.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#region ComputeSubnetwork#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork.
     *
     * The primary IP of such VM must belong
     * to the primary ipCidrRange of the subnetwork. The alias IPs may belong
     * to either primary or secondary ranges.
     *
     * *Note**: This field uses [attr-as-block mode](https://www.terraform.io/docs/configuration/attr-as-blocks.html) to avoid
     * breaking users during the 0.12 upgrade. To explicitly send a list
     * of zero objects you must use the following syntax:
     * 'example=[]'
     * For more details about this behavior, see [this section](https://www.terraform.io/docs/configuration/attr-as-blocks.html#defining-a-fixed-object-collection-value).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#secondary_ip_range ComputeSubnetwork#secondary_ip_range}
     *
     * @stability stable
     */
    readonly secondaryIpRange?: ComputeSubnetworkSecondaryIpRange[];
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#log_config ComputeSubnetwork#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeSubnetworkLogConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#timeouts ComputeSubnetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSubnetworkTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkSecondaryIpRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#ip_cidr_range ComputeSubnetwork#ip_cidr_range}.
     *
     * @stability stable
     */
    readonly ipCidrRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#range_name ComputeSubnetwork#range_name}.
     *
     * @stability stable
     */
    readonly rangeName?: string;
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkLogConfig {
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Toggles the aggregation interval for collecting flow logs. Increasing the
     * interval time will reduce the amount of generated flow logs for long
     * lasting connections. Default is an interval of 5 seconds per connection. Default value: "INTERVAL_5_SEC" Possible values: ["INTERVAL_5_SEC", "INTERVAL_30_SEC", "INTERVAL_1_MIN", "INTERVAL_5_MIN", "INTERVAL_10_MIN", "INTERVAL_15_MIN"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#aggregation_interval ComputeSubnetwork#aggregation_interval}
     *
     * @stability stable
     */
    readonly aggregationInterval?: string;
    /**
     * Export filter used to define which VPC flow logs should be logged, as as CEL expression.
     *
     * See
     * https://cloud.google.com/vpc/docs/flow-logs#filtering for details on how to format this field.
     * The default value is 'true', which evaluates to include everything.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#filter_expr ComputeSubnetwork#filter_expr}
     *
     * @stability stable
     */
    readonly filterExpr?: string;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * The value of the field must be in [0, 1]. Set the sampling rate of VPC
     * flow logs within the subnetwork where 1.0 means all collected logs are
     * reported and 0.0 means no logs are reported. Default is 0.5 which means
     * half of all collected logs are reported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#flow_sampling ComputeSubnetwork#flow_sampling}
     *
     * @stability stable
     */
    readonly flowSampling?: number;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Configures whether metadata fields should be added to the reported VPC
     * flow logs. Default value: "INCLUDE_ALL_METADATA" Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA", "CUSTOM_METADATA"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#metadata ComputeSubnetwork#metadata}
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * List of metadata fields that should be added to reported logs.
     *
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" is set to CUSTOM_METADATA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#metadata_fields ComputeSubnetwork#metadata_fields}
     *
     * @stability stable
     */
    readonly metadataFields?: string[];
}
/**
 * @stability stable
 */
export interface ComputeSubnetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#create ComputeSubnetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#delete ComputeSubnetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#update ComputeSubnetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html google_compute_subnetwork}.
 *
 * @stability stable
 */
export declare class ComputeSubnetwork extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html google_compute_subnetwork} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSubnetworkConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get gatewayAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipCidrRange;
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    set ipCidrRange(value: string);
    /**
     * @stability stable
     */
    get ipCidrRangeInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _network;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string;
    private _privateIpGoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpGoogleAccess(): boolean;
    /**
     * @stability stable
     */
    set privateIpGoogleAccess(value: boolean);
    /**
     * @stability stable
     */
    resetPrivateIpGoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpGoogleAccessInput(): boolean | undefined;
    private _privateIpv6GoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    /**
     * @stability stable
     */
    set privateIpv6GoogleAccess(value: string);
    /**
     * @stability stable
     */
    resetPrivateIpv6GoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _secondaryIpRange?;
    /**
     * @stability stable
     */
    get secondaryIpRange(): ComputeSubnetworkSecondaryIpRange[];
    /**
     * @stability stable
     */
    set secondaryIpRange(value: ComputeSubnetworkSecondaryIpRange[]);
    /**
     * @stability stable
     */
    resetSecondaryIpRange(): void;
    /**
     * @stability stable
     */
    get secondaryIpRangeInput(): ComputeSubnetworkSecondaryIpRange[] | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _logConfig?;
    /**
     * @stability stable
     */
    get logConfig(): ComputeSubnetworkLogConfig[];
    /**
     * @stability stable
     */
    set logConfig(value: ComputeSubnetworkLogConfig[]);
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeSubnetworkLogConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSubnetworkTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeSubnetworkTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSubnetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
