import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetSslProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A reference to the BackendService resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#backend_service ComputeTargetSslProxy#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#description ComputeTargetSslProxy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#name ComputeTargetSslProxy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#project ComputeTargetSslProxy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#proxy_header ComputeTargetSslProxy#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * A list of SslCertificate resources that are used to authenticate connections between users and the load balancer.
     *
     * At least one
     * SSL certificate must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#ssl_certificates ComputeTargetSslProxy#ssl_certificates}
     *
     * @stability stable
     */
    readonly sslCertificates: string[];
    /**
     * A reference to the SslPolicy resource that will be associated with the TargetSslProxy resource.
     *
     * If not set, the TargetSslProxy
     * resource will not have any SSL policy configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#ssl_policy ComputeTargetSslProxy#ssl_policy}
     *
     * @stability stable
     */
    readonly sslPolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#timeouts ComputeTargetSslProxy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetSslProxyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetSslProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#create ComputeTargetSslProxy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#delete ComputeTargetSslProxy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#update ComputeTargetSslProxy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html google_compute_target_ssl_proxy}.
 *
 * @stability stable
 */
export declare class ComputeTargetSslProxy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html google_compute_target_ssl_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetSslProxyConfig);
    private _backendService;
    /**
     * @stability stable
     */
    get backendService(): string;
    /**
     * @stability stable
     */
    set backendService(value: string);
    /**
     * @stability stable
     */
    get backendServiceInput(): string;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxyId(): number;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sslCertificates;
    /**
     * @stability stable
     */
    get sslCertificates(): string[];
    /**
     * @stability stable
     */
    set sslCertificates(value: string[]);
    /**
     * @stability stable
     */
    get sslCertificatesInput(): string[];
    private _sslPolicy?;
    /**
     * @stability stable
     */
    get sslPolicy(): string;
    /**
     * @stability stable
     */
    set sslPolicy(value: string);
    /**
     * @stability stable
     */
    resetSslPolicy(): void;
    /**
     * @stability stable
     */
    get sslPolicyInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetSslProxyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeTargetSslProxyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetSslProxyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
