import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
     * The backend service or backend bucket to use when none of the given rules match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_service ComputeUrlMap#default_service}
     *
     * @stability stable
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is created. The
     * name must be 1-63 characters long, and comply with RFC1035. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a lowercase
     * letter, and all following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#project ComputeUrlMap#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * default_route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_route_action ComputeUrlMap#default_route_action}
     *
     * @stability stable
     */
    readonly defaultRouteAction?: ComputeUrlMapDefaultRouteAction[];
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_url_redirect ComputeUrlMap#default_url_redirect}
     *
     * @stability stable
     */
    readonly defaultUrlRedirect?: ComputeUrlMapDefaultUrlRedirect[];
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapHeaderAction[];
    /**
     * host_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rule ComputeUrlMap#host_rule}
     *
     * @stability stable
     */
    readonly hostRule?: ComputeUrlMapHostRule[];
    /**
     * path_matcher block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_matcher ComputeUrlMap#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher?: ComputeUrlMapPathMatcher[];
    /**
     * test block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#test ComputeUrlMap#test}
     *
     * @stability stable
     */
    readonly test?: ComputeUrlMapTest[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeouts ComputeUrlMap#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeUrlMapTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-Control-Allow-Credentials header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For regular expression grammar
     * please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * The default value is false, which indicates that the CORS policy is in effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionRequestMirrorPolicy {
    /**
     * The full or partial URL to the BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries?: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
     * or if the backend service does not respond at all, example: disconnects, reset, read timeout,
     * connection failure, and refused streams.
     * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures connecting to backend services,
     * for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
     * This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServices {
    /**
     * The full or partial URL to the default BackendService resource.
     *
     * Before forwarding the
     * request to backendService, the loadbalancer applies any relevant headerActions
     * specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService?: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a backend service is determined only for new traffic. Once a user's request
     * has been directed to a backendService, subsequent requests will be sent to the same backendService
     * as determined by the BackendService's session affinity policy.
     *
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight?: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeUrlMapDefaultRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeUrlMapDefaultRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeUrlMapDefaultRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeUrlMapDefaultRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeUrlMapDefaultRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained. The default is set to false.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapHostRule {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The list of host patterns to match.
     *
     * They must be valid hostnames, except * will
     * match any string of ([a-z0-9-.]*). In that case, * must be the first character
     * and must be followed in the pattern by either - or ..
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#hosts ComputeUrlMap#hosts}
     *
     * @stability stable
     */
    readonly hosts: string[];
    /**
     * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_matcher ComputeUrlMap#path_matcher}
     *
     * @stability stable
     */
    readonly pathMatcher: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-Control-Allow-Credentials header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For regular expression grammar
     * please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * The default value is false, which indicates that the CORS policy is in effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy {
    /**
     * The full or partial URL to the BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries?: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
     * or if the backend service does not respond at all, example: disconnects, reset, read timeout,
     * connection failure, and refused streams.
     * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures connecting to backend services,
     * for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
     * This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices {
    /**
     * The full or partial URL to the default BackendService resource.
     *
     * Before forwarding the
     * request to backendService, the loadbalancer applies any relevant headerActions
     * specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService?: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a backend service is determined only for new traffic. Once a user's request
     * has been directed to a backendService, subsequent requests will be sent to the same backendService
     * as determined by the BackendService's session affinity policy.
     *
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight?: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeUrlMapPathMatcherDefaultRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
     * The BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries?: number;
    /**
     * Specifies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if
     * the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
     * The default BackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRuleUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request. This must only be set for UrlMaps used in
     * TargetHttpProxys. Setting this true for TargetHttpsProxy is not
     * permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied
     * together with prefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with
     * pathRedirect. Supply one alone or neither. If neither is supplied, the
     * path of the original request will be used for the redirect. The value
     * must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query
     * portion of the original URL is retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherPathRule {
    /**
     * The list of path patterns to match.
     *
     * Each must start with / and the only place a
     * is allowed is at the end following a /. The string fed to the path matcher
     * does not include any text after the first ? or #, and those chars are not
     * allowed here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#paths ComputeUrlMap#paths}
     *
     * @stability stable
     */
    readonly paths: string[];
    /**
     * The backend service or backend bucket to use if any of the given paths match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_action ComputeUrlMap#route_action}
     *
     * @stability stable
     */
    readonly routeAction?: ComputeUrlMapPathMatcherPathRuleRouteAction[];
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_redirect ComputeUrlMap#url_redirect}
     *
     * @stability stable
     */
    readonly urlRedirect?: ComputeUrlMapPathMatcherPathRuleUrlRedirect[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
     * The end of the range (exclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_end ComputeUrlMap#range_end}
     *
     * @stability stable
     */
    readonly rangeEnd: number;
    /**
     * The start of the range (inclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_start ComputeUrlMap#range_start}
     *
     * @stability stable
     */
    readonly rangeStart: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
     * The value should exactly match contents of exactMatch.
     *
     * Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#exact_match ComputeUrlMap#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The name of the HTTP header to match.
     *
     * For matching against the HTTP request's
     * authority, use a headerMatch with the header name ":authority". For matching a
     * request's method, use the headerName ":method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * If set to false, the headerMatch is considered a match if the match criteria above are met.
     *
     * If set to true, the headerMatch is considered a match if the
     * match criteria above are NOT met. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#invert_match ComputeUrlMap#invert_match}
     *
     * @stability stable
     */
    readonly invertMatch?: boolean;
    /**
     * The value of the header must start with the contents of prefixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_match ComputeUrlMap#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * A header with the contents of headerName must exist.
     *
     * The match takes place
     * whether or not the request's header has a value or not. Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#present_match ComputeUrlMap#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean;
    /**
     * The value of the header must match the regular expression specified in regexMatch.
     *
     * For regular expression grammar, please see:
     * en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
     * specified in the HTTP request, use a headerMatch with headerName set to PORT and
     * a regular expression that satisfies the RFC2616 Host header's port specifier.
     * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
     * rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
    /**
     * The value of the header must end with the contents of suffixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#suffix_match ComputeUrlMap#suffix_match}
     *
     * @stability stable
     */
    readonly suffixMatch?: string;
    /**
     * range_match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_match ComputeUrlMap#range_match}
     *
     * @stability stable
     */
    readonly rangeMatch?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
     * Name of metadata label.
     *
     * The name can have a maximum length of 1024 characters
     * and must be at least 1 character long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The value of the label must match the specified value. value can have a maximum length of 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#value ComputeUrlMap#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
     * Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
     *
     * Supported values are:
     * - MATCH_ANY: At least one of the filterLabels must have a matching label in the
     * provided metadata.
     * - MATCH_ALL: All filterLabels must have matching labels in
     * the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#filter_match_criteria ComputeUrlMap#filter_match_criteria}
     *
     * @stability stable
     */
    readonly filterMatchCriteria: string;
    /**
     * filter_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#filter_labels ComputeUrlMap#filter_labels}
     *
     * @stability stable
     */
    readonly filterLabels: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
     * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
     *
     * Only one of presentMatch, exactMatch and regexMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#exact_match ComputeUrlMap#exact_match}
     *
     * @stability stable
     */
    readonly exactMatch?: string;
    /**
     * The name of the query parameter to match.
     *
     * The query parameter must exist in the
     * request, in the absence of which the request match fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
     *
     * Only one of
     * presentMatch, exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#present_match ComputeUrlMap#present_match}
     *
     * @stability stable
     */
    readonly presentMatch?: boolean;
    /**
     * The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch.
     *
     * For the regular expression grammar,
     * please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
     * exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesMatchRules {
    /**
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
     *
     * FullPathMatch must be between 1
     * and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
     * be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#full_path_match ComputeUrlMap#full_path_match}
     *
     * @stability stable
     */
    readonly fullPathMatch?: string;
    /**
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#ignore_case ComputeUrlMap#ignore_case}
     *
     * @stability stable
     */
    readonly ignoreCase?: boolean;
    /**
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch.
     *
     * prefixMatch must begin with a /. The value must be
     * between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
     * regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_match ComputeUrlMap#prefix_match}
     *
     * @stability stable
     */
    readonly prefixMatch?: string;
    /**
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL.
     *
     * For regular expression grammar please
     * see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
     * fullPathMatch or regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     *
     * @stability stable
     */
    readonly regexMatch?: string;
    /**
     * header_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_matches ComputeUrlMap#header_matches}
     *
     * @stability stable
     */
    readonly headerMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[];
    /**
     * metadata_filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#metadata_filters ComputeUrlMap#metadata_filters}
     *
     * @stability stable
     */
    readonly metadataFilters?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[];
    /**
     * query_parameter_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#query_parameter_matches ComputeUrlMap#query_parameter_matches}
     *
     * @stability stable
     */
    readonly queryParameterMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     *
     * @stability stable
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     *
     * @stability stable
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     *
     * @stability stable
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     *
     * @stability stable
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled. which indicates that the CORS policy is in effect. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     *
     * @stability stable
     */
    readonly maxAge?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     *
     * @stability stable
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     *
     * @stability stable
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     *
     * @stability stable
     */
    readonly fixedDelay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     *
     * @stability stable
     */
    readonly abort?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort[];
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     *
     * @stability stable
     */
    readonly delay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
     * The BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     *
     * @stability stable
     */
    readonly numRetries: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in
     * the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     *
     * @stability stable
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     *
     * @stability stable
     */
    readonly seconds: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     *
     * @stability stable
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     *
     * @stability stable
     */
    readonly pathPrefixRewrite?: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     *
     * @stability stable
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     *
     * @stability stable
     */
    readonly replace: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     *
     * @stability stable
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     *
     * @stability stable
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     *
     * @stability stable
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     *
     * @stability stable
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
     * The default BackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     *
     * @stability stable
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     *
     * @stability stable
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy[];
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     *
     * @stability stable
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy[];
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     *
     * @stability stable
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy[];
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     *
     * @stability stable
     */
    readonly timeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout[];
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     *
     * @stability stable
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite[];
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     *
     * @stability stable
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     *
     * @stability stable
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set
     * to false, the URL scheme of the redirected request will remain the same as that
     * of the request. This must only be set for UrlMaps used in TargetHttpProxys.
     * Setting this true for TargetHttpsProxy is not permitted. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     *
     * @stability stable
     */
    readonly httpsRedirect?: boolean;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * Only one of pathRedirect or prefixRedirect must be
     * specified. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     *
     * @stability stable
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     *
     * @stability stable
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     *
     * @stability stable
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the
     * original URL is retained. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     *
     * @stability stable
     */
    readonly stripQuery?: boolean;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcherRouteRules {
    /**
     * For routeRules within a given pathMatcher, priority determines the order in which load balancer will interpret routeRules.
     *
     * RouteRules are evaluated
     * in order of priority, from the lowest to highest number. The priority of
     * a rule decreases as its number increases (1, 2, 3, N+1). The first rule
     * that matches the request is applied.
     *
     * You cannot configure two or more routeRules with the same priority.
     * Priority for each rule must be set to a number between 0 and
     * 2147483647 inclusive.
     *
     * Priority numbers can have gaps, which enable you to add or remove rules
     * in the future without affecting the rest of the rules. For example,
     * 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
     * you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
     * future without any impact on existing rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#priority ComputeUrlMap#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * The backend service resource to which traffic is directed if this rule is matched.
     *
     * If routeAction is additionally specified,
     * advanced routing actions like URL Rewrites, etc. take effect prior to sending
     * the request to the backend. However, if service is specified, routeAction cannot
     * contain any weightedBackendService s. Conversely, if routeAction specifies any
     * weightedBackendServices, service must not be specified. Only one of urlRedirect,
     * service or routeAction.weightedBackendService must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     *
     * @stability stable
     */
    readonly service?: string;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesHeaderAction[];
    /**
     * match_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#match_rules ComputeUrlMap#match_rules}
     *
     * @stability stable
     */
    readonly matchRules?: ComputeUrlMapPathMatcherRouteRulesMatchRules[];
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_action ComputeUrlMap#route_action}
     *
     * @stability stable
     */
    readonly routeAction?: ComputeUrlMapPathMatcherRouteRulesRouteAction[];
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_redirect ComputeUrlMap#url_redirect}
     *
     * @stability stable
     */
    readonly urlRedirect?: ComputeUrlMapPathMatcherRouteRulesUrlRedirect[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapPathMatcher {
    /**
     * The backend service or backend bucket to use when none of the given paths match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_service ComputeUrlMap#default_service}
     *
     * @stability stable
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name to which this PathMatcher is referred by the HostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * default_route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_route_action ComputeUrlMap#default_route_action}
     *
     * @stability stable
     */
    readonly defaultRouteAction?: ComputeUrlMapPathMatcherDefaultRouteAction[];
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_url_redirect ComputeUrlMap#default_url_redirect}
     *
     * @stability stable
     */
    readonly defaultUrlRedirect?: ComputeUrlMapPathMatcherDefaultUrlRedirect[];
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     *
     * @stability stable
     */
    readonly headerAction?: ComputeUrlMapPathMatcherHeaderAction[];
    /**
     * path_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_rule ComputeUrlMap#path_rule}
     *
     * @stability stable
     */
    readonly pathRule?: ComputeUrlMapPathMatcherPathRule[];
    /**
     * route_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_rules ComputeUrlMap#route_rules}
     *
     * @stability stable
     */
    readonly routeRules?: ComputeUrlMapPathMatcherRouteRules[];
}
/**
 * @stability stable
 */
export interface ComputeUrlMapTest {
    /**
     * Description of this test case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Host portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host ComputeUrlMap#host}
     *
     * @stability stable
     */
    readonly host: string;
    /**
     * Path portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path ComputeUrlMap#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * The backend service or backend bucket link that should be matched by this test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     *
     * @stability stable
     */
    readonly service: string;
}
/**
 * @stability stable
 */
export interface ComputeUrlMapTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#create ComputeUrlMap#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delete ComputeUrlMap#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#update ComputeUrlMap#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html google_compute_url_map}.
 *
 * @stability stable
 */
export declare class ComputeUrlMap extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html google_compute_url_map} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeUrlMapConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _defaultService?;
    /**
     * @stability stable
     */
    get defaultService(): string;
    /**
     * @stability stable
     */
    set defaultService(value: string);
    /**
     * @stability stable
     */
    resetDefaultService(): void;
    /**
     * @stability stable
     */
    get defaultServiceInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get mapId(): number;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _defaultRouteAction?;
    /**
     * @stability stable
     */
    get defaultRouteAction(): ComputeUrlMapDefaultRouteAction[];
    /**
     * @stability stable
     */
    set defaultRouteAction(value: ComputeUrlMapDefaultRouteAction[]);
    /**
     * @stability stable
     */
    resetDefaultRouteAction(): void;
    /**
     * @stability stable
     */
    get defaultRouteActionInput(): ComputeUrlMapDefaultRouteAction[] | undefined;
    private _defaultUrlRedirect?;
    /**
     * @stability stable
     */
    get defaultUrlRedirect(): ComputeUrlMapDefaultUrlRedirect[];
    /**
     * @stability stable
     */
    set defaultUrlRedirect(value: ComputeUrlMapDefaultUrlRedirect[]);
    /**
     * @stability stable
     */
    resetDefaultUrlRedirect(): void;
    /**
     * @stability stable
     */
    get defaultUrlRedirectInput(): ComputeUrlMapDefaultUrlRedirect[] | undefined;
    private _headerAction?;
    /**
     * @stability stable
     */
    get headerAction(): ComputeUrlMapHeaderAction[];
    /**
     * @stability stable
     */
    set headerAction(value: ComputeUrlMapHeaderAction[]);
    /**
     * @stability stable
     */
    resetHeaderAction(): void;
    /**
     * @stability stable
     */
    get headerActionInput(): ComputeUrlMapHeaderAction[] | undefined;
    private _hostRule?;
    /**
     * @stability stable
     */
    get hostRule(): ComputeUrlMapHostRule[];
    /**
     * @stability stable
     */
    set hostRule(value: ComputeUrlMapHostRule[]);
    /**
     * @stability stable
     */
    resetHostRule(): void;
    /**
     * @stability stable
     */
    get hostRuleInput(): ComputeUrlMapHostRule[] | undefined;
    private _pathMatcher?;
    /**
     * @stability stable
     */
    get pathMatcher(): ComputeUrlMapPathMatcher[];
    /**
     * @stability stable
     */
    set pathMatcher(value: ComputeUrlMapPathMatcher[]);
    /**
     * @stability stable
     */
    resetPathMatcher(): void;
    /**
     * @stability stable
     */
    get pathMatcherInput(): ComputeUrlMapPathMatcher[] | undefined;
    private _test?;
    /**
     * @stability stable
     */
    get test(): ComputeUrlMapTest[];
    /**
     * @stability stable
     */
    set test(value: ComputeUrlMapTest[]);
    /**
     * @stability stable
     */
    resetTest(): void;
    /**
     * @stability stable
     */
    get testInput(): ComputeUrlMapTest[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ComputeUrlMapTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ComputeUrlMapTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeUrlMapTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
